/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerEnvironmentSettings;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerEnvironmentPanel
extends ListenerSettings {
    private JTextField _defaultWebPage;
    private JTextField _docTable;
    private JTextField _extClasses;
    private JCheckBox _recordProcedure;

    public ListenerEnvironmentPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._defaultWebPage = new JTextField();
        this._docTable = new JTextField();
        this._extClasses = new JTextField();
        this._recordProcedure = new JCheckBox();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._defaultWebPage, (String)ListenerArb.getString("DEFAULT_WEB_PAGE"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._docTable, (String)ListenerArb.getString("DOC_TABLE"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._extClasses, (String)ListenerArb.getString("EXTENSION_CLASSES"));
        ResourceUtils.resButton((AbstractButton)this._recordProcedure, (String)ListenerArb.getString("RECORDER_PROCEDURE"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._docTable, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)ListenerArb.getString("APEX_LABEL"));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._defaultWebPage, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel2.add((Component)this._extClasses, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel2.add((Component)this._recordProcedure, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)ListenerArb.getString("GATEWAY_LABEL"));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel3);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Environment");
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getEnvironmentSettings() != null) {
            ListenerEnvironmentSettings listenerEnvironmentSettings = listenerModel.getEnvironmentSettings();
            this._defaultWebPage.setText(listenerEnvironmentSettings.getDefaultWebPage());
            this._docTable.setText(listenerEnvironmentSettings.getDocTable());
            this._extClasses.setText(listenerEnvironmentSettings.getExtensionClasses());
            this._recordProcedure.setSelected(listenerEnvironmentSettings.isRecordProcedure());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getEnvironmentSettings() != null) {
            ListenerEnvironmentSettings listenerEnvironmentSettings = this._model.getEnvironmentSettings();
            listenerEnvironmentSettings.setDefaultWebPage(this._defaultWebPage.getText());
            listenerEnvironmentSettings.setDocTable(this._docTable.getText());
            listenerEnvironmentSettings.setExtensionClasses(this._extClasses.getText());
            listenerEnvironmentSettings.setRecordProcedure(this._recordProcedure.isSelected());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerEnvironmentSettings listenerEnvironmentSettings = listenerModel.getEnvironmentSettings();
        this.updateTextHandler(this._defaultWebPage, listenerEnvironmentSettings.getDefaultWebPage());
        this.updateTextHandler(this._docTable, listenerEnvironmentSettings.getDocTable());
        this.updateTextHandler(this._extClasses, listenerEnvironmentSettings.getExtensionClasses());
        this.updateCheckBoxHandler(this._recordProcedure, listenerEnvironmentSettings.isRecordProcedure());
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerEnvironmentSettings listenerEnvironmentSettings = this._model.getEnvironmentSettings();
            if (this._defaultWebPage.getText() != listenerEnvironmentSettings.getDefaultWebPage() || this._docTable.getText() != listenerEnvironmentSettings.getDocTable() || this._extClasses.getText() != listenerEnvironmentSettings.getExtensionClasses() || this._recordProcedure.isSelected() != listenerEnvironmentSettings.isRecordProcedure()) {
                return true;
            }
        }
        return false;
    }
}

