/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.ListenerWindow;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerNewAdminDialog;
import oracle.dbtools.listener.ui.ListenerNewDBSettingsDialog;
import oracle.dbtools.listener.ui.ListenerNodeInfo;
import oracle.dbtools.listener.ui.ListenerPanel;
import oracle.dbtools.listener.ui.ListenerValidateDialog;
import oracle.dbtools.listener.utils.ListenerConnection;
import oracle.dbtools.listener.utils.ListenerValidator;
import oracle.dbtools.listener.xml.ListenerExportAdmin;
import oracle.dbtools.listener.xml.ListenerImportAdmin;
import oracle.dbtools.raptor.cloud.connection.CConnectionEvent;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.CConnectionsListener;
import oracle.dbtools.raptor.cloud.connection.listener.ListenerConnectionType;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;

public class ListenerController
implements Controller,
ActionListener,
CConnectionsListener {
    public static final WildcardURLFilter ZIP_FILTER = new WildcardURLFilter(ListenerArb.getString("ZIP_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), ListenerArb.getString("ZIP_FILTER_NAME"));
    public static final String UPLOAD_FILENAME = "confs.zip";
    public static int CONNECT_ACTION = Ide.findOrCreateCmdID((String)"listener_connect");
    public static int DISCONNECT_ACTION = Ide.findOrCreateCmdID((String)"listener_disconnect");
    public static int OPEN_FILE_ACTION = Ide.findOrCreateCmdID((String)"listener_fileopen");
    public static int SAVE_FILE_ACTION = Ide.findOrCreateCmdID((String)"listener_filesave");
    public static int NEW_ADMIN_ACTION = Ide.findOrCreateCmdID((String)"listener_newadmin");
    public static int RETRIEVE_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_retrieve");
    public static int UPLOAD_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_upload");
    public static int TEST_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_test");
    public static int NEW_DB_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_newdbsettings");
    public static int DEL_DB_SETTINGS_ACTION = Ide.findOrCreateCmdID((String)"listener_deldbsettings");
    public static int LAUNCH_URL_ACTION = Ide.findOrCreateCmdID((String)"listener_launchurl");
    public static int REPORT_REFRESH_ACTION = Ide.findOrCreateCmdID((String)"listener_reportrefresh");
    private static ListenerController _instance;
    private static boolean _init;
    private static boolean _loaded;
    private static boolean _preserveSettings;
    private static boolean _serverReporting;
    private static ListenerModel _model;
    private static ListenerNodeInfo _lastSelectedNode;
    private static File _lastUrl;

    private ListenerController() {
        this.init();
    }

    public static synchronized ListenerController getInstance() {
        if (_instance == null) {
            _instance = new ListenerController();
        }
        return _instance;
    }

    public void init() {
        if (_init) {
            _init = false;
            _loaded = false;
            _preserveSettings = false;
            this.initActions();
        }
    }

    private void initActions() {
        IdeAction.get((int)OPEN_FILE_ACTION).setEnabled(true);
        IdeAction.get((int)NEW_ADMIN_ACTION).setEnabled(true);
        IdeAction.get((int)NEW_DB_SETTINGS_ACTION).setEnabled(true);
        IdeAction.get((int)DEL_DB_SETTINGS_ACTION).setEnabled(true);
        boolean bl = ListenerConnection.getInstance().isConnectionOpen();
        IdeAction.get((int)CONNECT_ACTION).setEnabled(!bl);
        IdeAction.get((int)DISCONNECT_ACTION).setEnabled(bl);
        IdeAction.get((int)RETRIEVE_SETTINGS_ACTION).setEnabled(bl);
        IdeAction.get((int)UPLOAD_SETTINGS_ACTION).setEnabled(bl && _loaded);
        IdeAction.get((int)LAUNCH_URL_ACTION).setEnabled(bl && Desktop.isDesktopSupported());
        if (IdeAction.get((int)LAUNCH_URL_ACTION).isEnabled()) {
            IdeAction.get((int)LAUNCH_URL_ACTION).setName(ListenerArb.format("LAUNCH_URL_PATH", ListenerConnection.getInstance().getURI().toString()));
        } else {
            IdeAction.get((int)LAUNCH_URL_ACTION).setName(ListenerArb.getString("LAUNCH_URL_LABEL"));
        }
        IdeAction.get((int)SAVE_FILE_ACTION).setEnabled(_loaded);
        IdeAction.get((int)TEST_SETTINGS_ACTION).setEnabled(_loaded);
        IdeAction.get((int)REPORT_REFRESH_ACTION).setEnabled(true);
    }

    private String getDirectory() {
        Object object = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
        if (object == null || ((String)object).isEmpty()) {
            object = System.getProperty("user.home");
        }
        return object;
    }

    public Toolbar createToolbar(Toolbar toolbar) {
        toolbar.add((ToggleAction)IdeAction.get((int)NEW_ADMIN_ACTION));
        toolbar.addSeparator();
        toolbar.add((ToggleAction)IdeAction.get((int)OPEN_FILE_ACTION));
        toolbar.add((ToggleAction)IdeAction.get((int)SAVE_FILE_ACTION));
        toolbar.addSeparator();
        toolbar.add((ToggleAction)IdeAction.get((int)RETRIEVE_SETTINGS_ACTION));
        toolbar.add((ToggleAction)IdeAction.get((int)UPLOAD_SETTINGS_ACTION));
        toolbar.addSeparator();
        toolbar.add((ToggleAction)IdeAction.get((int)TEST_SETTINGS_ACTION));
        toolbar.addSeparator();
        toolbar.add((ToggleAction)IdeAction.get((int)LAUNCH_URL_ACTION));
        return toolbar;
    }

    public void attachTreeToMouseListener(JTree jTree) {
        jTree.addMouseListener(new CustomTreeMouseListener());
    }

    public void listenerConnect() {
        boolean bl = ListenerConnection.getInstance().connectToListener();
        if (bl) {
            CConnections.getInstance((SessionType)ListenerConnectionType.getInstance()).addListener((CConnectionsListener)this);
            ListenerPanel.getInstance().setConnectionName(ListenerConnection.getInstance().getConnectionName());
            boolean bl2 = true;
            if (_model != null && _loaded) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ListenerArb.getString("ADMIN_SETTINGS_CONNECT_RETRIEVE")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
                bl2 = MessageDialog.confirm(null, (Object)stringBuffer, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            }
            if (bl2) {
                this.retrieveSettings();
            }
        }
        this.updateListenerToolbarActions();
    }

    public void listenerDisconnect() {
        ListenerPanel.getInstance().setConnectionName(ListenerArb.getString("NOT_CONNECTED"));
        ListenerConnection.getInstance().disconnectFromListener();
        View.updateToolbarActions((Toolbar)ListenerPanel.getInstance().getToolbar());
        CConnections.getInstance((SessionType)ListenerConnectionType.getInstance()).removeListener((CConnectionsListener)this);
    }

    public void openFileDialog() {
        int n;
        Object object;
        if (_model != null && _loaded) {
            object = new StringBuffer();
            ((StringBuffer)object).append(ListenerArb.getString("ADMIN_SETTINGS_OPEN")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
            n = MessageDialog.confirm(null, (Object)object, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            if (n == 0) {
                return;
            }
        }
        if (_lastUrl == null) {
            object = DBConfig.getInstance().getString("IMPORTDIR") + File.separator;
            if (object == null || ((String)object).equals("")) {
                object = System.getProperty("user.home");
            }
            _lastUrl = new File((String)object);
        }
        object = new URLFileChooser(_lastUrl);
        object.setPathContext("IMPORTDIR");
        object.clearChooseableURLFilters();
        object.setURLFilter((URLFilter)ZIP_FILTER);
        object.setSelectionScope(2);
        object.setSelectionMode(0);
        object.setShowJarsAsDirs(false);
        n = object.showOpenDialog((Component)Ide.getMainWindow(), ListenerArb.getString("OPEN_ADMINISTRATION"));
        if (n == 0) {
            int n2;
            String string = object.getSelectedFile().toString();
            String string2 = string.substring(n2 = string.lastIndexOf(File.separator));
            _lastUrl = string2.lastIndexOf(".") > -1 ? object.getSelectedFile() : new File(object.getSelectedFile().toString() + ".zip");
            ListenerImportAdmin listenerImportAdmin = ListenerImportAdmin.getInstance();
            boolean bl = false;
            try {
                bl = listenerImportAdmin.importAdministration(_lastUrl, ListenerConnection.getInstance().isAdminRole());
            }
            catch (Exception exception) {
                MessageDialog.error(null, (Object)exception.getLocalizedMessage(), (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            }
            if (bl) {
                _model = listenerImportAdmin.getModel();
                if (ListenerConnection.getInstance().isAdminRole()) {
                    ListenerPanel.getInstance().loadAdministration(_model, ListenerConnection.getInstance().isAdminRole());
                } else {
                    ListenerPanel.getInstance().loadReports(_model);
                }
                _loaded = true;
                _preserveSettings = true;
                View.updateToolbarActions((Toolbar)ListenerPanel.getInstance().getToolbar());
                if (listenerImportAdmin.isPasswordClearText()) {
                    MessageDialog.critical(null, (Object)ListenerArb.getString("PASSWORD_CLEAR_TXT"), (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
                }
            }
        }
    }

    public void saveAdministrationDialog() {
        if (!ListenerPanel.getInstance().isLastPanelValidInput()) {
            return;
        }
        if (_lastUrl == null) {
            _lastUrl = new File(this.getDirectory());
        }
        URLFileChooser uRLFileChooser = new URLFileChooser(_lastUrl);
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setURLFilter((URLFilter)ZIP_FILTER);
        uRLFileChooser.setSelectionScope(2);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setShowJarsAsDirs(false);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), ListenerArb.getString("SAVE_ADMINISTRATION"));
        if (n == 0) {
            int n2;
            String string = uRLFileChooser.getSelectedFile().toString();
            String string2 = string.substring(n2 = string.lastIndexOf(File.separator));
            _lastUrl = string2.lastIndexOf(".") > -1 ? uRLFileChooser.getSelectedFile() : new File(uRLFileChooser.getSelectedFile().toString() + ".zip");
            _model = ListenerPanel.getInstance().getAllSettingsValues();
            ListenerExportAdmin listenerExportAdmin = new ListenerExportAdmin(_model);
            listenerExportAdmin.exportAdministration(_lastUrl, null, _preserveSettings);
        }
    }

    public void newAdministrationDialog() {
        Object object;
        if (_model != null && _loaded) {
            object = new StringBuffer();
            ((StringBuffer)object).append(ListenerArb.getString("ADMIN_SETTINGS_NEW")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
            boolean bl = MessageDialog.confirm(null, (Object)object, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            if (!bl) {
                return;
            }
        }
        if (((ListenerNewAdminDialog)(object = new ListenerNewAdminDialog(ListenerArb.getString("CREATE_ADMIN_SETTING")))).runDialog()) {
            _model = new ListenerModel();
            ((ListenerNewAdminDialog)object).assignValues(_model);
            ListenerPanel.getInstance().newAdministration(_model);
            _loaded = true;
            _preserveSettings = false;
            View.updateToolbarActions((Toolbar)ListenerPanel.getInstance().getToolbar());
        }
    }

    public void retrieveSettingsDialog() {
        if (ListenerConnection.getInstance().isConnectionOpen()) {
            if (_model != null && _loaded) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ListenerArb.getString("ADMIN_SETTINGS_RETRIEVE")).append(System.getProperty("line.separator")).append(ListenerArb.getString("ADMIN_SETTINGS_CONTINUE"));
                boolean bl = MessageDialog.confirm(null, (Object)stringBuffer, (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
                if (!bl) {
                    return;
                }
            }
            this.retrieveSettings();
            if (ListenerImportAdmin.getInstance().isPasswordClearText()) {
                MessageDialog.critical(null, (Object)ListenerArb.getString("PASSWORD_CLEAR_TXT"), (String)ListenerArb.getString("ADMIN_SETTINGS_TITLE"), null);
            }
        }
    }

    private void retrieveSettings() {
        if (ListenerConnection.getInstance().retrieveSettings()) {
            _model = ListenerImportAdmin.getInstance().getModel();
            _serverReporting = _model.getReportSettings().isReporting();
            ListenerConnection.getInstance().retrieveReports(_serverReporting);
            ListenerPanel.getInstance().loadAdministration(_model, ListenerConnection.getInstance().isAdminRole());
            _loaded = true;
            _preserveSettings = true;
            View.updateToolbarActions((Toolbar)ListenerPanel.getInstance().getToolbar());
        } else {
            _loaded = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadSettingsDialog() {
        if (!ListenerPanel.getInstance().isLastPanelValidInput()) {
            return;
        }
        if (_model != null && ListenerConnection.getInstance().isConnectionOpen()) {
            boolean bl = MessageDialog.confirm(null, (Object)ListenerArb.getString("ADMIN_SETTINGS_UPLOAD"), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
            if (!bl) {
                return;
            }
            boolean bl2 = false;
            _model = ListenerPanel.getInstance().getAllSettingsValues();
            ListenerValidator listenerValidator = new ListenerValidator(_model);
            if (listenerValidator.isValidDBSettings()) {
                URL uRL = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.listener");
                URL uRL2 = null;
                try {
                    uRL2 = URLFileSystem.createTempFile((String)"upload", (String)".zip", (URL)uRL);
                }
                catch (Exception exception) {
                    MessageDialog.error(null, (Object)exception.getLocalizedMessage(), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
                    return;
                }
                try {
                    ListenerExportAdmin listenerExportAdmin = new ListenerExportAdmin(_model);
                    boolean bl3 = listenerExportAdmin.exportAdministration(uRL2.getPath(), null, _preserveSettings);
                    if (bl3 && (bl2 = ListenerConnection.getInstance().uploadSettings(uRL2))) {
                        _serverReporting = _model.getReportSettings().isReporting();
                        if (ListenerConnection.getInstance().retrieveReports(_serverReporting)) {
                            ListenerPanel.getInstance().refreshReports(_model, _serverReporting);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (URLFileSystem.exists((URL)uRL2)) {
                        URLFileSystem.delete((URL)uRL2);
                    }
                }
                if (bl2) {
                    MessageDialog.information(null, (Object)ListenerArb.getString("UPLOAD_SUCCESSFUL"), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
                } else {
                    MessageDialog.critical(null, (Object)ListenerArb.getString("UPLOAD_FAILED"), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
                }
            } else {
                MessageDialog.error(null, (Object)ListenerArb.getString("VALIDATE_DB_SETTINGS"), (String)ListenerArb.getString("ADMIN_UPLOAD_TITLE"), null);
            }
        }
    }

    public void testSettingsDialog() {
        if (ListenerPanel.getInstance().isLastPanelValidInput()) {
            _model = ListenerPanel.getInstance().getAllSettingsValues();
            new ListenerValidateDialog(_model);
        }
    }

    public void newDBSettingsDialog() {
        ListenerModel listenerModel = ListenerPanel.getInstance().updateGlobalSettingsValues();
        ListenerNewDBSettingsDialog listenerNewDBSettingsDialog = new ListenerNewDBSettingsDialog(listenerModel);
        if (listenerNewDBSettingsDialog.runDialog()) {
            ListenerModel listenerModel2 = listenerNewDBSettingsDialog.getModel();
            ListenerPanel.getInstance().newDBSettings(listenerModel2);
        }
    }

    public void removeDBSettingsDialog() {
        if (_lastSelectedNode != null) {
            String string = _lastSelectedNode.getName();
            String string2 = ListenerArb.format("DELETE_SETTINGS_CONFIRM", string);
            boolean bl = MessageDialog.confirm(null, (Object)string2, (String)ListenerArb.getString("DELETE_SETTINGS_TITLE"), null);
            if (bl) {
                ListenerPanel.getInstance().removeDBSettings(_lastSelectedNode.getKey());
            }
        }
    }

    public void launchURL() {
        URI uRI = null;
        try {
            uRI = ListenerConnection.getInstance().getURI();
            if (uRI != null) {
                Desktop.getDesktop().browse(uRI);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ListenerArb.format("LAUNCH_ERRORED", uRI.getPath()));
            stringBuffer.append(System.getProperty("line.separator")).append(exception.getLocalizedMessage());
            MessageDialog.error(null, (Object)stringBuffer.toString(), (String)ListenerArb.getString("LAUNCH_ERROR_TITLE"), null);
        }
    }

    public void refreshReports() {
        if (ListenerConnection.getInstance().isConnectionOpen()) {
            WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
            try {
                waitCursor.show();
                if (ListenerConnection.getInstance().retrieveReports(_serverReporting)) {
                    _model = ListenerImportAdmin.getInstance().getModel();
                    ListenerPanel.getInstance().refreshReports(_model, _serverReporting);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(ListenerArb.getString("ERROR_RETRIEVE_REPORTS")).append(System.getProperty("line.separator")).append(ListenerConnection.getInstance().getErrorMessage());
                    waitCursor.hide();
                    MessageDialog.error(null, (Object)stringBuffer.toString(), (String)ListenerArb.getString("REPORTS_TITLE"), null);
                }
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    public ListenerModel getGlobalSettingsValues(String string) {
        return ListenerPanel.getInstance().updateGlobalSettingsValues(string);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        block14: {
            int n = ideAction.getCommandId();
            try {
                if (n == CONNECT_ACTION) {
                    this.listenerConnect();
                    break block14;
                }
                if (n == DISCONNECT_ACTION) {
                    this.listenerDisconnect();
                    break block14;
                }
                if (n == NEW_ADMIN_ACTION) {
                    this.newAdministrationDialog();
                    break block14;
                }
                if (n == OPEN_FILE_ACTION) {
                    this.openFileDialog();
                    break block14;
                }
                if (n == SAVE_FILE_ACTION) {
                    this.saveAdministrationDialog();
                    break block14;
                }
                if (n == RETRIEVE_SETTINGS_ACTION) {
                    this.retrieveSettingsDialog();
                    break block14;
                }
                if (n == UPLOAD_SETTINGS_ACTION) {
                    this.uploadSettingsDialog();
                    break block14;
                }
                if (n == TEST_SETTINGS_ACTION) {
                    this.testSettingsDialog();
                    break block14;
                }
                if (n == NEW_DB_SETTINGS_ACTION) {
                    this.newDBSettingsDialog();
                    break block14;
                }
                if (n == DEL_DB_SETTINGS_ACTION) {
                    this.removeDBSettingsDialog();
                    break block14;
                }
                if (n == LAUNCH_URL_ACTION) {
                    this.launchURL();
                    break block14;
                }
                if (n == REPORT_REFRESH_ACTION) {
                    this.refreshReports();
                    break block14;
                }
                return false;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (context.getView() instanceof ListenerWindow) {
            int n = ideAction.getCommandId();
            if (n == CONNECT_ACTION) {
                ideAction.setEnabled(!ListenerConnection.getInstance().isConnectionOpen());
            } else if (n == DISCONNECT_ACTION) {
                ideAction.setEnabled(ListenerConnection.getInstance().isConnectionOpen());
            } else if (n == NEW_ADMIN_ACTION) {
                ideAction.setEnabled(true);
            } else if (n == OPEN_FILE_ACTION) {
                ideAction.setEnabled(true);
            } else if (n == SAVE_FILE_ACTION) {
                ideAction.setEnabled(_loaded);
            } else if (n == RETRIEVE_SETTINGS_ACTION) {
                ideAction.setEnabled(ListenerConnection.getInstance().isConnectionOpen());
            } else if (n == UPLOAD_SETTINGS_ACTION) {
                ideAction.setEnabled(ListenerConnection.getInstance().isConnectionOpen() && _loaded);
            } else if (n == TEST_SETTINGS_ACTION) {
                ideAction.setEnabled(_loaded);
            } else if (n == NEW_DB_SETTINGS_ACTION) {
                ideAction.setEnabled(true);
            } else if (n == DEL_DB_SETTINGS_ACTION) {
                ideAction.setEnabled(true);
            } else if (n == LAUNCH_URL_ACTION) {
                ideAction.setEnabled(ListenerConnection.getInstance().isConnectionOpen() && Desktop.isDesktopSupported());
                if (ideAction.isEnabled()) {
                    ideAction.setName(ListenerArb.format("LAUNCH_URL_PATH", ListenerConnection.getInstance().getURI().toString()));
                } else {
                    ideAction.setName(ListenerArb.getString("LAUNCH_URL_LABEL"));
                }
            } else if (n == REPORT_REFRESH_ACTION) {
                ideAction.setEnabled(true);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void connectionAdded(CConnectionEvent cConnectionEvent) {
    }

    public void connectionRemoved(CConnectionEvent cConnectionEvent) {
    }

    public void connectionModified(CConnectionEvent cConnectionEvent) {
    }

    public void connectionOpened(CConnectionEvent cConnectionEvent) {
    }

    public void connectionClosed(CConnectionEvent cConnectionEvent) {
        this.listenerConnectionClosed(cConnectionEvent);
    }

    private void listenerConnectionClosed(CConnectionEvent cConnectionEvent) {
        String string;
        String string2 = cConnectionEvent.getConnectionName();
        String string3 = ListenerConnection.getInstance().getConnectionName();
        if (string3 != null && string3.equals(string2) && (string = ListenerPanel.getInstance().getConnectionName()) != null && string.equals(string2)) {
            this.listenerDisconnect();
            this.updateListenerToolbarActions();
        }
    }

    private void updateListenerToolbarActions() {
        boolean bl = ListenerConnection.getInstance().isConnectionOpen();
        IdeAction.find((int)RETRIEVE_SETTINGS_ACTION).setEnabled(bl);
        IdeAction.find((int)UPLOAD_SETTINGS_ACTION).setEnabled(bl && _loaded);
        IdeAction.find((int)LAUNCH_URL_ACTION).setEnabled(bl && Desktop.isDesktopSupported());
        if (IdeAction.find((int)LAUNCH_URL_ACTION).isEnabled()) {
            IdeAction.find((int)LAUNCH_URL_ACTION).setName(ListenerArb.format("LAUNCH_URL_PATH", ListenerConnection.getInstance().getURI().toString()));
        } else {
            IdeAction.find((int)LAUNCH_URL_ACTION).setName(ListenerArb.getString("LAUNCH_URL_LABEL"));
        }
        IdeAction.find((int)SAVE_FILE_ACTION).setEnabled(_loaded);
        IdeAction.find((int)TEST_SETTINGS_ACTION).setEnabled(_loaded);
    }

    static {
        _init = true;
        _loaded = false;
        _preserveSettings = false;
        _serverReporting = false;
        _model = null;
    }

    public final class CustomTreeMouseListener
    extends MouseAdapter
    implements ContextMenuListener {
        private ContextMenu _contextMenu;
        private String _nodeType;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            JTree jTree = null;
            if (!(mouseEvent.getSource() instanceof JTree)) {
                return;
            }
            jTree = (JTree)mouseEvent.getSource();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            _lastSelectedNode = (ListenerNodeInfo)defaultMutableTreeNode.getUserObject();
            this._nodeType = _lastSelectedNode.getType();
            if (this._contextMenu == null) {
                this._contextMenu = new ContextMenu();
                this._contextMenu.addContextMenuListener((ContextMenuListener)this);
            }
            Context context = Context.newIdeContext();
            context.setEvent((EventObject)mouseEvent);
            this._contextMenu.show(context);
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (this._nodeType == null) {
                return;
            }
            contextMenu.removeAll();
            if (this._nodeType.equals("Listener")) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)CONNECT_ACTION)));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)DISCONNECT_ACTION)));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)NEW_ADMIN_ACTION)));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)OPEN_FILE_ACTION)));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)SAVE_FILE_ACTION)));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)RETRIEVE_SETTINGS_ACTION)));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)UPLOAD_SETTINGS_ACTION)));
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)TEST_SETTINGS_ACTION)));
            } else if (this._nodeType.equals("DBSettings")) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)NEW_DB_SETTINGS_ACTION)));
            } else if (this._nodeType.equals("DBSettingsName")) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)DEL_DB_SETTINGS_ACTION)));
            } else if (this._nodeType.equals("Reports")) {
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)IdeAction.get((int)REPORT_REFRESH_ACTION)));
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }
    }
}

