/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.ide.config.IdeSettings;
import oracle.ide.help.HelpSystem;
import oracle.ide.localhistory.res.Bundle;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.history.HistoryOptions;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.data.PropertyStorage;

public class HistoryOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox enabledCheckBox;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lifespanLabel = new JLabel();
    private JSpinner lifespanSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 365, 1));
    private JLabel revisionsLabel = new JLabel();
    private JSpinner revisionsSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 999, 1));
    private JLabel revisionsHint = new JLabel();

    public HistoryOptionsPanel() {
        try {
            this.jbInit();
            HelpSystem hs = HelpSystem.getHelpSystem();
            if (hs != null) {
                hs.registerTopic((JComponent)((Object)this), "f1_idedidesetlocalhistory_html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.enabledCheckBox = new JCheckBox();
        this.setLayout(this.gridBagLayout1);
        this.enabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HistoryOptionsPanel.this.updateEnabled(e);
            }
        });
        this.revisionsHint.setText(Bundle.get("HISTORY_OPTIONS_RESTART"));
        this.revisionsHint.setHorizontalAlignment(2);
        ResourceUtils.resButton((AbstractButton)this.enabledCheckBox, (String)HistoryOptions.getEnabledLabel());
        ResourceUtils.resSpinner((JLabel)this.lifespanLabel, (JSpinner)this.lifespanSpinner, (String)IdeImplArb.getString((int)79));
        ResourceUtils.resSpinner((JLabel)this.revisionsLabel, (JSpinner)this.revisionsSpinner, (String)IdeImplArb.getString((int)80));
        this.add(this.enabledCheckBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.lifespanLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 5), 0, 0));
        this.add(this.lifespanSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.revisionsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 5), 0, 0));
        this.add(this.revisionsSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.revisionsHint, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 25, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        HistoryOptions options = HistoryOptions.getInstance((PropertyStorage)tc.getPropertyStorage());
        this.enabledCheckBox.setSelected(options.isEnabled());
        this.lifespanSpinner.setValue(options.getLifespan());
        this.revisionsSpinner.setValue(options.getRevisions());
        this.updateEnabled(null);
    }

    public void onExit(TraversableContext tc) {
        HistoryOptions options = HistoryOptions.getInstance((PropertyStorage)tc.getPropertyStorage());
        int lifespan = (Integer)this.lifespanSpinner.getValue();
        int revisions = (Integer)this.revisionsSpinner.getValue();
        boolean restart = lifespan != options.getLifespan() || revisions != options.getRevisions();
        options.setEnabled(this.enabledCheckBox.isSelected());
        options.setLifespan(lifespan);
        options.setRevisions(revisions);
        if (restart) {
            IdeSettings settings = (IdeSettings)tc.find("ide-options");
            settings.setAskExit(true);
        }
    }

    private void updateEnabled(ItemEvent e) {
        this.lifespanSpinner.setEnabled(this.enabledCheckBox.isSelected());
        this.revisionsSpinner.setEnabled(this.enabledCheckBox.isSelected());
    }
}

