/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.TuningResources;
import oracle.dbtools.raptor.sqltrace.SqlCursorPanel;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.Stat;
import oracle.dbtools.raptor.sqltrace.parser.WaitSummary;
import oracle.dbtools.raptor.sqltrace.ui.WaitSummaryTable;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlCursorBorderRenderer;
import oracle.dbtools.raptor.sqltrace.ui.renderer.SqlTraceNumberRenderer;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.TreeTableModel;

public class SqlCursorRenderer
extends DefaultTableCellRenderer
implements TableCellEditor {
    private boolean _withSql;
    private boolean _withWaits;
    private long _factor = 1000000L;
    private WaitSummaryTable _ws;
    private JScrollPane _waitPane;
    private SqlCursorPanel _cursorPanel;
    private static final String PADDING = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public SqlCursorRenderer() {
        this(true, true);
    }

    public SqlCursorRenderer(boolean bl, boolean bl2) {
        this._withSql = bl;
        this._withWaits = bl2;
    }

    private Component getCompForValue(JTable jTable, Object object, int n, int n2) {
        JComponent jComponent = null;
        if (object instanceof SqlCursor) {
            if (this._cursorPanel == null) {
                this._cursorPanel = new SqlCursorPanel((SqlCursor)object, this._withSql, this._withWaits);
                this._cursorPanel.setTimeFactor(this._factor);
                this._cursorPanel.setMinimumSize(new Dimension(425, 95));
                int n3 = jTable.getRowHeight();
                jTable.setRowHeight(n, 95);
                jTable.setRowHeight(n, jTable.getRowHeight(n));
            } else {
                this._cursorPanel.setTimeFactor(this._factor);
                this._cursorPanel.setCursor((SqlCursor)object);
            }
            jComponent = this._cursorPanel;
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof WaitSummary) {
            if (this._ws == null) {
                this._ws = new WaitSummaryTable((ArrayList)object);
                this._ws.setTimeFactor(this._factor);
                this._waitPane = new JScrollPane(this._ws);
                this._ws.setTimeFactor(this._factor);
                this._waitPane.setVerticalScrollBarPolicy(20);
                this._waitPane.setBackground(Color.LIGHT_GRAY);
                this._ws.setMinimumSize(new Dimension(200, 300));
                this._ws.setSize(this._ws.getWidth(), 95);
                this._ws.setMinimumSize(new Dimension(this._ws.getWidth(), 95));
                jTable.setRowHeight(n, 110);
            } else {
                this._ws.setTimeFactor(this._factor);
                this._ws.setWaits((ArrayList)object);
            }
            jComponent = this._waitPane;
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof Stat) {
            ArrayList arrayList = (ArrayList)object;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(arrayList.get(0));
            this.getBuildTree(defaultMutableTreeNode, ((Stat)arrayList.get(0)).getStats());
            AbstractTreeTableModel abstractTreeTableModel = new AbstractTreeTableModel(defaultMutableTreeNode){

                public int getColumnCount() {
                    return 2;
                }

                public Class getColumnClass(int n) {
                    return n == 0 ? TreeTableModel.class : String.class;
                }

                public String getColumnName(int n) {
                    switch (n) {
                        case 0: {
                            return TuningResources.getString("SqlCursorRenderer.0");
                        }
                        case 1: {
                            return TuningResources.getString("SqlCursorRenderer.1");
                        }
                    }
                    return "----";
                }

                public Object getValueAt(Object object, int n) {
                    if (object instanceof ArrayList) {
                        return "__";
                    }
                    if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof Stat) {
                        Stat stat = (Stat)((DefaultMutableTreeNode)object).getUserObject();
                        switch (n) {
                            case 0: {
                                return stat == null ? "" : stat.getOperation();
                            }
                            case 1: {
                                return stat == null ? "" : Double.valueOf(stat.getRows());
                            }
                        }
                    } else {
                        return n == 0 ? ((DefaultMutableTreeNode)object).getUserObject().toString() : null;
                    }
                    return "--";
                }

                public Object getChild(Object object, int n) {
                    if (object instanceof DefaultMutableTreeNode) {
                        return ((DefaultMutableTreeNode)object).getChildAt(n);
                    }
                    return "xx";
                }

                public int getChildCount(Object object) {
                    if (object instanceof DefaultMutableTreeNode) {
                        return ((DefaultMutableTreeNode)object).getChildCount();
                    }
                    return 0;
                }
            };
            JFastTreeTable jFastTreeTable = new JFastTreeTable((TreeTableModel)abstractTreeTableModel);
            jFastTreeTable.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                    jLabel.setIcon(new ImageIcon());
                    if (object instanceof DefaultMutableTreeNode) {
                        Stat stat = (Stat)((DefaultMutableTreeNode)object).getUserObject();
                        jLabel.setText(stat.getOperation());
                    }
                    return jLabel;
                }
            });
            jFastTreeTable.setMinimumSize(new Dimension(300, 300));
            jFastTreeTable.setPreferredSize(jFastTreeTable.getMinimumSize());
            this.expandAll(jFastTreeTable.getTree(), true);
            jFastTreeTable.getColumnModel().getColumn(1).setMaxWidth(50);
            jFastTreeTable.getColumnModel().getColumn(1).setCellRenderer(new SqlTraceNumberRenderer());
            jFastTreeTable.getTableHeader().setDefaultRenderer(new SqlCursorBorderRenderer());
            JScrollPane jScrollPane = new JScrollPane((Component)jFastTreeTable);
            jScrollPane.setVerticalScrollBarPolicy(21);
            jComponent = jScrollPane;
        }
        return jComponent;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = this.getCompForValue(jTable, object, n, n2);
        if (component == null) {
            if (object instanceof ArrayList && ((ArrayList)object).size() == 0) {
                component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ((JLabel)component).setText("");
                ((JLabel)component).setAlignmentX(0.0f);
                component.setBackground(Color.WHITE);
            } else {
                component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ((JLabel)component).setToolTipText(((JLabel)component).getText());
                ((JLabel)component).setAlignmentX(0.0f);
                component.setBackground(Color.WHITE);
            }
        }
        return component;
    }

    public void getBuildTree(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<Stat> arrayList) {
        for (Stat stat : arrayList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stat);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (stat.getStats() == null) continue;
            this.getBuildTree(defaultMutableTreeNode2, stat.getStats());
        }
    }

    public void expandAll(JTree jTree, boolean bl) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode), bl);
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    public void printCursorStats(StringBuilder stringBuilder, String string, ArrayList<Stat> arrayList, int n) {
        for (Stat stat : arrayList) {
            if (stat.getOperation().indexOf("(cr") > 0) {
                stringBuilder.append(String.format(string, stat.getRows(), PADDING.substring(0, n * 6 * 2) + stat.getOperation().substring(0, stat.getOperation().indexOf("(cr"))));
            }
            this.printCursorStats(stringBuilder, string, stat.getStats(), n + 1);
        }
    }

    public void setTimeFactor(long l) {
        this._factor = l;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = this.getCompForValue(jTable, object, n, n2);
        return component;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        return false;
    }
}

