/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dbtools.raptor.controls.IPopupSupplier;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.parser.Stat;
import oracle.dbtools.raptor.sqltrace.parser.WaitSummary;
import oracle.dbtools.raptor.sqltrace.ui.StatisticsSummaryTable;
import oracle.dbtools.raptor.sqltrace.ui.WaitSummaryTable;

public abstract class TracePopupProvider
implements IPopupSupplier {
    private StatisticsSummaryTable _cp = null;
    private WaitSummaryTable _ws = null;
    private JScrollPane _sp = null;
    private static final String PADDING = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public Component getPopup(Object object) {
        Component component = null;
        if (object instanceof SqlCursor) {
            if (this._cp == null) {
                this._cp = new StatisticsSummaryTable((SqlCursor)object);
                this._cp.setPreferredSize(new Dimension(450, 95));
                this._cp.setMinimumSize(this._cp.getPreferredSize());
                this._cp.setMaximumSize(this._cp.getPreferredSize());
            } else {
                this._cp.setPreferredSize(new Dimension(450, 95));
                this._cp.setMinimumSize(this._cp.getPreferredSize());
                this._cp.setMaximumSize(this._cp.getPreferredSize());
                this._cp.setCursor((SqlCursor)object);
            }
            component = this._cp;
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof WaitSummary) {
            if (this._ws == null) {
                this._ws = new WaitSummaryTable((ArrayList)object);
                this._ws.setMinimumSize(new Dimension(300, this._ws.getRowHeight() * (this._ws.getRowCount() + 5)));
                this._ws.setPreferredSize(this._ws.getMinimumSize());
            } else {
                if (this._ws.getWaits() == object) {
                    this._ws.setMinimumSize(new Dimension(300, this._ws.getRowHeight() * (this._ws.getRowCount() + 5)));
                    this._ws.setPreferredSize(this._ws.getMinimumSize());
                }
                this._ws.setWaits((ArrayList)object);
            }
            component = this._ws;
        } else if (object instanceof ArrayList && ((ArrayList)object).size() > 0 && ((ArrayList)object).get(0) instanceof Stat) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            String string = "%8d-%s<br>";
            JLabel jLabel = new JLabel();
            this.printCursorStats(stringBuilder, string, (ArrayList)object, 0);
            jLabel.setBackground(Color.WHITE);
            jLabel.setText(stringBuilder.toString());
            Dimension dimension = jLabel.getPreferredSize();
            jLabel.setMinimumSize(new Dimension(250, 100));
            component = jLabel;
        } else if (object instanceof String) {
            MultiLineLabel multiLineLabel = new MultiLineLabel();
            multiLineLabel.setText(object.toString());
            multiLineLabel.setBackground(Color.WHITE);
            multiLineLabel.setForceWrapping(true);
            String[] stringArray = object.toString().split("\n");
            if (stringArray.length < 20) {
                multiLineLabel.setMinimumRows(stringArray.length + 2);
            } else {
                multiLineLabel.setMinimumRows(21);
            }
            multiLineLabel.setOpaque(true);
            for (int i = 0; i < 20; ++i) {
                if (stringArray.length <= i || multiLineLabel.getMinimumColumns() >= stringArray[i].length()) continue;
                multiLineLabel.setMinimumColumns(stringArray[i].length() + 10);
            }
            component = multiLineLabel;
        } else {
            component = null;
        }
        if (component != null && component instanceof JTable) {
            if (this._sp == null) {
                this._sp = new JScrollPane(component);
                this._sp.setVerticalScrollBarPolicy(21);
            }
            this._sp.setViewportView(component);
            if (this._sp.getPreferredSize() != component.getPreferredSize()) {
                this._sp.setPreferredSize(((JTable)component).getPreferredSize());
                this._sp.setMinimumSize(((JTable)component).getPreferredSize());
            }
            component = this._sp;
        }
        return component;
    }

    public void printCursorStats(StringBuilder stringBuilder, String string, ArrayList<Stat> arrayList, int n) {
        for (Stat stat : arrayList) {
            if (stat.getOperation().indexOf("(cr") > 0) {
                stringBuilder.append(String.format(string, stat.getRows(), PADDING.substring(0, n * 6 * 2) + stat.getOperation().substring(0, stat.getOperation().indexOf("(cr"))));
            }
            this.printCursorStats(stringBuilder, string, stat.getStats(), n + 1);
        }
    }
}

