/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.IResourceEvent;

public class EventExecute
implements IElapsedEvent,
IResourceEvent {
    private static final Logger LOGGER = Logger.getLogger(EventExecute.class.getName());
    private double _num;
    private double _cpuTime;
    private double _elapsed;
    private double _phyReads;
    private double _consReads;
    private double _logicalReads;
    private int _miss;
    private double _rows;
    private double _dep;
    private double _og;
    private double _time;
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++):c=([0-9]++),e=([0-9]++),p=([0-9]++),cr=([0-9]++),cu=([0-9]++),mis=([0-9]++),r=([0-9]++),dep=([0-9]++),og=([0-9]++),tim=([0-9]++)");

    public EventExecute(String string) {
        string = EventExecute.trimPLH(string);
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this._num = Double.parseDouble(matcher.group(1));
            this._cpuTime = Double.parseDouble(matcher.group(2));
            this._elapsed = Double.parseDouble(matcher.group(3));
            this._phyReads = Double.parseDouble(matcher.group(4));
            this._consReads = Double.parseDouble(matcher.group(5));
            this._logicalReads = Double.parseDouble(matcher.group(6));
            this._miss = Integer.parseInt(matcher.group(7));
            this._rows = Double.parseDouble(matcher.group(8));
            this._dep = Double.parseDouble(matcher.group(9));
            this._og = Double.parseDouble(matcher.group(10));
            this._time = Double.parseDouble(matcher.group(11));
        } else {
            LOGGER.severe("no match for line:" + string);
        }
    }

    public static String trimPLH(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
                continue;
            }
            if (!string2.startsWith("plh=")) {
                stringBuilder.append(string2);
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return String.format("EXEC #%d:c=%d,e=%d,p=%d,cr=%d,cu=%d,mis=%d,r=%d,dep=%d,og=%d,tim=%d", this._num, this._cpuTime, this._elapsed, this._phyReads, this._consReads, this._logicalReads, this._miss, this._rows, this._dep, this._og, this._time);
    }

    public static void main(String[] stringArray) {
        String string;
        String string2 = "EXEC #4:c=0,e=795,p=0,cr=0,cu=0,mis=0,r=0,dep=0,og=4,tim=308638731695";
        string2 = string = "EXEC #5:c=0,e=0,p=0,cr=2,cu=0,mis=0,r=1,dep=0,og=1,plh=0,tim=67318275176203";
        EventExecute eventExecute = new EventExecute(string2);
        PrintStream printStream = System.out;
        printStream.println("TEST:" + string2);
        printStream.println("REST:" + eventExecute.toString());
    }

    @Override
    public double getConsistantIO() {
        return this._consReads;
    }

    public double getCpuTime() {
        return this._cpuTime;
    }

    public double getDep() {
        return this._dep;
    }

    @Override
    public double getElapsed() {
        return this._elapsed;
    }

    @Override
    public double getLogicalIO() {
        return this._logicalReads;
    }

    @Override
    public double getCacheMisses() {
        return this._miss;
    }

    public double getNum() {
        return this._num;
    }

    public double getOptimizerGoal() {
        return this._og;
    }

    @Override
    public double getPhysicalIO() {
        return this._phyReads;
    }

    @Override
    public double getRows() {
        return this._rows;
    }

    @Override
    public double getTime() {
        return this._time;
    }
}

