/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.net.URL;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.PLSQLProfiles;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.javatools.buffer.TextBuffer;

public class PLSQLController
implements Controller {
    private static final Object LOCK = new Object();
    private static PLSQLController _controller;
    private static final int PROFILE_COMMAND;
    private static IdeAction s_actionProfile;
    public IdeAction actionProfile;
    public JMenuItem profileMenu;

    public static IdeAction getProfileAction() {
        if (s_actionProfile == null) {
            String string = CompileArb.getString((String)"PROFILE_MENU_LABEL");
            s_actionProfile = IdeAction.get((int)PROFILE_COMMAND, (String)StringUtils.stripMnemonic((String)string), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)));
            s_actionProfile.addController((Controller)PLSQLController.getInstance());
        }
        return s_actionProfile;
    }

    private PLSQLController() {
        this.createActions();
    }

    private void createActions() {
        this.hookAction(PROFILE_COMMAND);
    }

    private void hookAction(int n) {
        IdeAction ideAction = IdeAction.get((int)n);
        ideAction.addController((Controller)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PLSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new PLSQLController();
            }
        }
        return _controller;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PROFILE_COMMAND) {
            Node node = context.getNode();
            if (node instanceof PlSqlNode) {
                boolean bl;
                PlSqlNode plSqlNode = (PlSqlNode)node;
                boolean bl2 = bl = Boolean.valueOf((String)plSqlNode.getProperty("INVALID")) == false;
                if ("BLOCK".equals(plSqlNode.getObjectType())) {
                    bl = false;
                }
                ideAction.setEnabled(bl);
                if (DBURLFormatHelper.isDBURL((URL)plSqlNode.getURL()) && Boolean.valueOf((String)plSqlNode.getProperty("INVALID")).booleanValue()) {
                    ideAction.setEnabled(false);
                }
                if (("TYPE".equals(plSqlNode.getObjectType()) || "PACKAGE".equals(plSqlNode.getObjectType())) && !plSqlNode.hasBody()) {
                    ideAction.setEnabled(false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, final Context context) {
        DBConfig dBConfig = DBConfig.getInstance();
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == PROFILE_COMMAND) {
            final PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
            PlSqlRunnerPanel.PlSqlProfilerPanel plSqlProfilerPanel = new PlSqlRunnerPanel.PlSqlProfilerPanel(plSqlNode);
            TextBuffer textBuffer = plSqlProfilerPanel.runDialog();
            if (textBuffer == null) {
                return true;
            }
            final String string = textBuffer.getString(0, textBuffer.getLength());
            String string2 = dBConfig.getString("PLSQLPROFILERDIR");
            if (string2 == null || "".equals(string2.trim())) {
                string2 = "PLSHPROF_DIR";
            }
            final String string3 = string2;
            final String string4 = "begin dbms_hprof.start_profiling('" + string3 + "', 'test1.trc');end;";
            final String string5 = "begin :1 := dbms_hprof.analyze('" + string3 + "','test1.trc',run_comment=>'" + plSqlNode.getProperty("commentReturn") + "'); end; ";
            final boolean bl2 = (Boolean)plSqlNode.getProperty("gatherSQLStats");
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker("PL/SQL Profiler Starter Thread"){
                private int attempt;
                {
                    super(string6);
                    this.attempt = 0;
                }

                /*
                 * Exception decompiling
                 */
                public Object construct() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK], 47[CATCHBLOCK], 7[TRYBLOCK], 50[CATCHBLOCK]], but top level block is 17[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public void finished() {
                    PLSQLController.this.setSelection(context);
                }
            };
            namedSwingWorker.start();
            return true;
        }
        return bl;
    }

    private void setSelection(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, PLSQLProfiles.class);
        PLSQLProfiles pLSQLProfiles = (PLSQLProfiles)editorManager.openEditor(openEditorOptions);
    }

    static {
        PROFILE_COMMAND = Ide.findOrCreateCmdID((String)"ProfileSelectionCommand");
    }
}

