/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.navigator;

import java.text.MessageFormat;
import javax.swing.Icon;
import oracle.dbtools.raptor.ssh.SshSupportResources;
import oracle.dbtools.raptor.ssh.core.ClientEvent;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.Tunnel;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;
import oracle.dbtools.raptor.ssh.navigator.SshBaseElement;
import oracle.dbtools.raptor.ssh.navigator.SshController;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class SshTunnelElement
extends SshBaseElement {
    private static final String TOOLTIP_FORMAT = "<HTML>{0}<BR><B>Hostname</B>: {1}<BR><B>Host port</B>: {2}<BR><B>{3}</B>: {4}<BR></HTML>";
    private String mName;
    private TunnelDescriptor mDesc;
    private String mTooltip;

    static SshTunnelElement createTunnelElement(String string, TunnelDescriptor tunnelDescriptor) {
        SshTunnelElement sshTunnelElement = new SshTunnelElement(string, tunnelDescriptor);
        sshTunnelElement.initListeners();
        return sshTunnelElement;
    }

    private SshTunnelElement(String string, TunnelDescriptor tunnelDescriptor) {
        this.mName = string;
        this.mDesc = tunnelDescriptor;
    }

    TunnelDescriptor getTunnel() {
        return this.mDesc;
    }

    public String getShortLabel() {
        return this.mName;
    }

    public String getToolTipText() {
        if (this.mTooltip == null) {
            this.mTooltip = this.formatTooltip(-1);
        }
        return this.mTooltip;
    }

    private String formatTooltip(int n) {
        String string = this.mDesc.getHostname();
        int n2 = this.mDesc.getHostport();
        TunnelDescriptor.Type type = this.mDesc.getType();
        String string2 = SshSupportResources.getString(type.equals((Object)TunnelDescriptor.Type.LOCAL) ? "SSH_TUNNEL_TOOLTIP_LOCALPORT" : "SSH_TUNNEL_TOOLTIP_REMOTEPORT");
        String string3 = n >= 0 ? Integer.toString(n) : SshSupportResources.getString("SSH_TUNNEL_TOOLTIP_DISCONNECTED");
        return MessageFormat.format(TOOLTIP_FORMAT, this.mName, string, Integer.toString(n2), string2, string3);
    }

    @Override
    protected void handleTunnelChanged(StoreEvent storeEvent) {
        if (this.mDesc.equals((Object)storeEvent.getOldDescriptor())) {
            TunnelDescriptor tunnelDescriptor = storeEvent.getTunnelDescriptor();
            this.mName = tunnelDescriptor.getName();
            this.mDesc = tunnelDescriptor;
            UpdateMessage.fireStructureChanged((Subject)this);
        }
    }

    @Override
    protected void processClientEvent(ClientEvent clientEvent) {
        switch (clientEvent.getType()) {
            case TUNNEL_CLOSED: 
            case TUNNEL_OPENED: {
                Tunnel tunnel = clientEvent.getTunnel();
                TunnelDescriptor tunnelDescriptor = tunnel.getDescriptor();
                if (!this.mDesc.equals((Object)tunnelDescriptor)) break;
                SshController.updateOverlays((Element)this);
                this.mTooltip = this.formatTooltip(tunnel.getPort());
                UpdateMessage.fireStructureChanged((Subject)this);
                break;
            }
        }
    }

    @Override
    protected Icon loadIcon() {
        return SshSupportResources.getIcon(this.mDesc.getType() == TunnelDescriptor.Type.LOCAL ? "LOCAL_TUNNEL_ICON" : "REMOTE_TUNNEL_ICON");
    }
}

