/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;

public class CollectionStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = -2055664308810750671L;
    private Vector styleParameters = null;
    private Object defaultStyle = null;
    public static String POINT_SHAPE = "POINT";
    public static String LINE_SHAPE = "LINE";
    public static String POLYGON_SHAPE = "POLYGON";

    public CollectionStyleModel() {
        this.type = 9;
        this.styleParameters = new Vector();
    }

    @Override
    public Object clone() {
        CollectionStyleModel collectionStyleModel = (CollectionStyleModel)super.clone();
        return collectionStyleModel;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    public int getNumberOfStyles() {
        return this.styleParameters.size();
    }

    public boolean addStyle(String string, Object object, String string2) {
        if (string == null) {
            return false;
        }
        StyleParameters styleParameters = new StyleParameters();
        styleParameters.name = string;
        styleParameters.style = object == null ? this.defaultStyle : object;
        styleParameters.shape = string2;
        this.styleParameters.add(styleParameters);
        return true;
    }

    public void removeStyle(String string) {
        if (string == null) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            if (!styleParameters.name.equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.styleParameters.remove(n);
        }
    }

    public boolean containsStyle(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            if (!styleParameters.name.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String[] getStyleNames() {
        int n = this.styleParameters.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            stringArray[i] = styleParameters.name;
        }
        return stringArray;
    }

    public Object getStyle(String string) {
        Object object = null;
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            if (!styleParameters.name.equalsIgnoreCase(string)) continue;
            object = styleParameters.style;
            break;
        }
        return object;
    }

    public boolean setStyle(String string, Object object) {
        if (string == null || object == null) {
            return false;
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            if (!styleParameters.name.equalsIgnoreCase(string)) continue;
            styleParameters.style = object;
            return true;
        }
        return false;
    }

    public String getStyleShape(String string) {
        String string2 = null;
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            if (!styleParameters.name.equalsIgnoreCase(string)) continue;
            string2 = styleParameters.shape;
            break;
        }
        return string2;
    }

    public boolean setStyleShape(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (!(string2.equalsIgnoreCase(POINT_SHAPE) || string2.equalsIgnoreCase(LINE_SHAPE) || string2.equalsIgnoreCase(POLYGON_SHAPE))) {
            return false;
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            if (!styleParameters.name.equalsIgnoreCase(string)) continue;
            styleParameters.shape = string2;
            return true;
        }
        return false;
    }

    @Override
    public String toXMLString() {
        String string = "<?xml version=\"1.0\" ?>\n";
        string = string + "<AdvancedStyle>\n  <CollectionStyle>\n";
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            string = string + "  <style name=\"" + XMLUtil.replaceXMLEntities(styleParameters.name) + "\"";
            string = styleParameters.shape != null ? string + " shape=\"" + XMLUtil.replaceXMLEntities(styleParameters.shape) + "\" />\n" : string + "/>\n";
        }
        string = string + "  </CollectionStyle>\n</AdvancedStyle>";
        return string;
    }

    public String getStyleName(int n) {
        if (n < 0 || n >= this.styleParameters.size()) {
            return null;
        }
        StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(n);
        return styleParameters.name;
    }

    public Object getStyle(int n) {
        if (n < 0 || n >= this.styleParameters.size()) {
            return null;
        }
        StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(n);
        return styleParameters.style;
    }

    public String getStyleShape(int n) {
        if (n < 0 || n >= this.styleParameters.size()) {
            return null;
        }
        StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(n);
        return styleParameters.shape;
    }

    public void setDefaultStyle(Object object) {
        this.defaultStyle = object;
    }

    public Object getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    public String[] getStyleDependency() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.defaultStyle != null) {
            // empty if block
        }
        for (int i = 0; i < this.styleParameters.size(); ++i) {
            StyleParameters styleParameters = (StyleParameters)this.styleParameters.get(i);
            if (styleParameters.name == null || arrayList.contains(styleParameters.name)) continue;
            arrayList.add(styleParameters.name);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static class StyleParameters
    implements Serializable {
        static final long serialVersionUID = 1467133582389982868L;
        public String name = null;
        public Object style = null;
        public String shape = null;
    }
}

