/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;

public class ColorStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = -6980461813241800978L;
    protected Color fillColor = null;
    protected Color strokeColor = null;
    protected float strokeWidth = 1.0f;

    public ColorStyleModel() {
        this.type = 1;
    }

    @Override
    public Object clone() {
        ColorStyleModel colorStyleModel = (ColorStyleModel)super.clone();
        return colorStyleModel;
    }

    @Override
    public String getTypeName() {
        return "COLOR";
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeWidth(float f) {
        this.strokeWidth = f;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public String toXMLString() {
        int n;
        String string = "";
        String string2 = "";
        if (this.strokeColor != null) {
            string = string + "stroke:" + StyleUtils.getHexidecimalString(this.strokeColor);
            n = this.strokeColor.getAlpha();
            if (n < 255) {
                string = string + ";stroke-opacity:" + n;
            }
            if (this.strokeWidth != 1.0f) {
                string = string + ";stroke-width:" + this.strokeWidth;
            }
            if (this.fillColor != null) {
                string = string + ";";
            }
        }
        if (this.fillColor != null) {
            string2 = string2 + "fill:" + StyleUtils.getHexidecimalString(this.fillColor);
            n = this.fillColor.getAlpha();
            if (n < 255) {
                string2 = string2 + ";fill-opacity:" + n;
            }
        }
        String string3 = string + string2;
        String string4 = "<?xml version=\"1.0\" standalone=\"yes\"?>\n";
        string4 = string4 + "<svg width=\"1in\" height=\"1in\">\n";
        string4 = string4 + "  <desc/>\n";
        string4 = string4 + "  <g class=\"color\" style=\"" + string3 + "\">\n";
        string4 = string4 + "    <rect width=\"50\" height=\"50\"/>\n";
        string4 = string4 + "  </g>\n";
        string4 = string4 + "</svg>";
        return string4;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }
}

