/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.mapcache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.mapviewer.share.mapcache.TileDefinition;
import oracle.mapviewer.share.util.LogFactory;

public abstract class MapSourceAdapter {
    public static final int DEFAULT_TIMEOUT = 15000;
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SHARE);
    private String mapServiceURL = null;
    private Properties props = null;
    private String httpMethod = "POST";
    private int timeOut = 15000;
    private int proxyPort = 80;
    private String proxyHost = null;
    transient HttpURLConnection mHttp = null;

    public abstract String getMapTileRequest(TileDefinition var1);

    public byte[] getTileImageBytes(TileDefinition tileDefinition) throws Exception {
        Object object;
        String string = this.getMapTileRequest(tileDefinition);
        log.finer(string);
        if (string == null) {
            throw new Exception("Null map tile request string in map source adapter!");
        }
        if (string.indexOf("?&?") == 0) {
            return string.getBytes();
        }
        Properties properties = System.getProperties();
        Proxy proxy = null;
        boolean bl = "NONE".equalsIgnoreCase(this.getProxyHost());
        if (this.getProxyHost() != null && !bl) {
            object = new InetSocketAddress(this.proxyHost, this.proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, (SocketAddress)object);
        }
        object = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            String string2 = this.mapServiceURL;
            if ("GET".equalsIgnoreCase(this.httpMethod)) {
                string2 = this.mapServiceURL.indexOf(63) > 0 ? (!this.mapServiceURL.endsWith("&") ? this.mapServiceURL + "&" + string : this.mapServiceURL + string) : this.mapServiceURL + "?" + string;
            }
            log.finest("http " + this.httpMethod + ": " + string2);
            URL uRL = new URL(string2);
            URLConnection uRLConnection = proxy != null ? uRL.openConnection(proxy) : (bl ? uRL.openConnection(Proxy.NO_PROXY) : uRL.openConnection());
            uRLConnection.setConnectTimeout(this.timeOut);
            if ("GET".equalsIgnoreCase(this.httpMethod)) {
                uRLConnection.connect();
            } else {
                uRLConnection.setDoOutput(true);
                object = new PrintWriter(uRLConnection.getOutputStream());
                ((PrintWriter)object).print(string);
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
                object = null;
            }
            bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            byte[] byArray = this.toBytes(bufferedInputStream);
            bufferedInputStream.close();
            bufferedInputStream = null;
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw new Exception("Failed to fetch external map tile.", exception);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
                bufferedInputStream = null;
            }
            if (object != null) {
                ((PrintWriter)object).close();
                object = null;
            }
        }
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setHTTPMethod(String string) {
        this.httpMethod = string;
    }

    public String getHTTPMethod() {
        return this.httpMethod;
    }

    public void setProxyHost(String string) {
        if (string != null && string.trim().length() > 0) {
            this.proxyHost = string;
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String string) {
        try {
            this.proxyPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setMapServiceURL(String string) {
        this.mapServiceURL = string;
    }

    public String getMapServiceURL() {
        return this.mapServiceURL;
    }

    public void setConnectionTimeout(int n) {
        this.timeOut = n;
    }

    public int getConnectionTimeout() {
        return this.timeOut;
    }

    private byte[] toBytes(BufferedInputStream bufferedInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        int n = 0;
        while (0 < (n = bufferedInputStream.read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

