/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.awt.geom.Rectangle2D;
import java.util.Vector;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyNode;

public class TopologyPrimitives {
    private Vector<TopologyNode> nodes = new Vector();
    private Vector<TopologyEdge> edges = new Vector();
    private Vector<TopologyFace> faces = new Vector();

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.faces.clear();
    }

    public void addNode(TopologyNode topologyNode) {
        if (topologyNode == null) {
            return;
        }
        this.nodes.add(topologyNode);
    }

    public boolean removeNode(TopologyNode topologyNode) {
        if (topologyNode == null) {
            return false;
        }
        return this.nodes.remove(topologyNode);
    }

    public TopologyNode[] getNodes() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.toArray(new TopologyNode[this.nodes.size()]);
    }

    public void addEdge(TopologyEdge topologyEdge) {
        if (topologyEdge == null) {
            return;
        }
        this.edges.add(topologyEdge);
    }

    public boolean removeEdge(TopologyEdge topologyEdge) {
        if (topologyEdge == null) {
            return false;
        }
        return this.edges.remove(topologyEdge);
    }

    public TopologyEdge[] getEdges() {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.toArray(new TopologyEdge[this.edges.size()]);
    }

    public void addFace(TopologyFace topologyFace) {
        if (topologyFace == null) {
            return;
        }
        this.faces.add(topologyFace);
    }

    public boolean removeFace(TopologyFace topologyFace) {
        if (topologyFace == null) {
            return false;
        }
        return this.faces.remove(topologyFace);
    }

    public TopologyFace[] getFaces() {
        if (this.faces.size() == 0) {
            return null;
        }
        return this.faces.toArray(new TopologyFace[this.faces.size()]);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getNumberOfEdges() {
        return this.edges.size();
    }

    public int getNumberOfFaces() {
        return this.faces.size();
    }

    public int getNumberOfPrimitives() {
        return this.getNumberOfNodes() + this.getNumberOfEdges() + this.getNumberOfFaces();
    }

    public TopologyFace getFace(int n) {
        if (n < 0 || n >= this.faces.size()) {
            return null;
        }
        return this.faces.get(n);
    }

    public TopologyEdge getEdge(int n) {
        if (n < 0 || n >= this.edges.size()) {
            return null;
        }
        return this.edges.get(n);
    }

    public TopologyNode getNode(int n) {
        if (n < 0 || n >= this.nodes.size()) {
            return null;
        }
        return this.nodes.get(n);
    }

    public Rectangle2D getMBR() {
        Rectangle2D rectangle2D;
        int n;
        Rectangle2D rectangle2D2 = null;
        for (n = 0; n < this.faces.size(); ++n) {
            rectangle2D = this.faces.get(n).getMBR();
            if (rectangle2D == null) continue;
            if (rectangle2D2 == null) {
                rectangle2D2 = new Rectangle2D.Double();
            }
            rectangle2D2.add(rectangle2D);
        }
        for (n = 0; n < this.edges.size(); ++n) {
            rectangle2D = this.edges.get(n).getMBR();
            if (rectangle2D == null) continue;
            if (rectangle2D2 == null) {
                rectangle2D2 = new Rectangle2D.Double();
            }
            rectangle2D2.add(rectangle2D);
        }
        for (n = 0; n < this.nodes.size(); ++n) {
            rectangle2D = this.nodes.get(n).getMBR();
            if (rectangle2D == null) continue;
            if (rectangle2D2 == null) {
                rectangle2D2 = new Rectangle2D.Double();
            }
            rectangle2D2.add(rectangle2D);
        }
        return rectangle2D2;
    }

    public int getSrid() {
        if (this.getNumberOfPrimitives() == 0) {
            return 0;
        }
        if (this.nodes.size() > 0 && this.nodes.get(0).getGeometry() != null) {
            return this.nodes.get(0).getGeometry().getSRID();
        }
        if (this.edges.size() > 0 && this.edges.get(0).getGeometry() != null) {
            return this.edges.get(0).getGeometry().getSRID();
        }
        return 0;
    }
}

