/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.io.Serializable;

public class MapBounds
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2154217047200597000L;
    public static final int TYPE_NOBOUNDS = 0;
    public static final int TYPE_RECT = 1;
    public static final int TYPE_CENTERSIZE = 2;
    public static final int TYPE_BOUNDINGTHEMES = 3;
    public static final int TYPE_CENTERSCALE = 4;
    protected int srid;
    protected int type = 0;
    protected double[] rect = null;
    protected boolean rectKeepAspectRatio = false;
    protected double[] centerSize = null;
    protected String[] boundingThemes = null;
    protected float boundingThemeBorderMargin = 0.05f;
    protected boolean boundingThemeKeepAspectRatio = true;
    protected double boundingThemeSizeHint = 0.0;
    protected long scale;

    public MapBounds() {
        this.type = 0;
        this.srid = 0;
    }

    public MapBounds(double d, double d2, double d3, double d4, int n) {
        this.type = 1;
        this.srid = n;
        this.rect = new double[4];
        this.rect[0] = Math.min(d, d3);
        this.rect[1] = Math.min(d2, d4);
        this.rect[2] = Math.max(d3, d);
        this.rect[3] = Math.max(d4, d2);
    }

    public MapBounds(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 0);
    }

    public MapBounds(double d, double d2, double d3, double d4, int n, boolean bl) {
        this(d, d2, d3, d4, n);
        this.rectKeepAspectRatio = bl;
    }

    public MapBounds(double d, double d2, double d3, double d4, boolean bl) {
        this(d, d2, d3, d4, 0, bl);
    }

    public MapBounds(double d, double d2, double d3, int n) {
        this.type = 2;
        this.srid = n;
        this.centerSize = new double[3];
        this.centerSize[0] = d;
        this.centerSize[1] = d2;
        this.centerSize[2] = d3;
    }

    public MapBounds(double d, double d2, double d3) {
        this(d, d2, d3, 0);
    }

    public MapBounds(String[] stringArray, float f, boolean bl, double d, int n) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("invalid param for bounding themes.");
        }
        this.type = 3;
        this.srid = n;
        this.boundingThemeBorderMargin = f;
        this.boundingThemeKeepAspectRatio = bl;
        this.boundingThemeSizeHint = d;
        this.boundingThemes = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.boundingThemes[i] = stringArray[i];
        }
    }

    public MapBounds(String[] stringArray) {
        this(stringArray, 0.05f, true, 0.0, 0);
    }

    public MapBounds(String[] stringArray, float f, boolean bl) {
        this(stringArray, 0.05f, bl, 0.0, 0);
    }

    public MapBounds(double d, double d2, long l, int n) {
        this.type = 4;
        this.srid = n;
        this.centerSize = new double[2];
        this.centerSize[0] = d;
        this.centerSize[1] = d2;
        this.scale = l;
    }

    public Object clone() {
        try {
            MapBounds mapBounds = (MapBounds)super.clone();
            if (this.centerSize != null) {
                mapBounds.centerSize = new double[this.centerSize.length];
                System.arraycopy(this.centerSize, 0, mapBounds.centerSize, 0, this.centerSize.length);
            }
            if (this.boundingThemes != null) {
                mapBounds.boundingThemes = new String[this.boundingThemes.length];
                System.arraycopy(this.boundingThemes, 0, mapBounds.boundingThemes, 0, this.boundingThemes.length);
            }
            if (this.rect != null) {
                mapBounds.rect = new double[this.rect.length];
                System.arraycopy(this.rect, 0, mapBounds.rect, 0, this.rect.length);
            }
            return mapBounds;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSrid() {
        return this.srid;
    }

    public double[] getRect() {
        return this.rect;
    }

    public double[] getCenterSize() {
        return this.centerSize;
    }

    public String[] getBoundingThemes() {
        return this.boundingThemes;
    }

    public float getBoundingThemeBorderMargin() {
        return this.boundingThemeBorderMargin;
    }

    public boolean isBoundingThemeKeepAspectRatio() {
        return this.boundingThemeKeepAspectRatio;
    }

    public double getBoundingThemeSizeHint() {
        return this.boundingThemeSizeHint;
    }

    public long getScale() {
        return this.scale;
    }

    public boolean isUniverse() {
        return this.type == 0;
    }

    public boolean isKeepBoxAspectRatio() {
        return this.type == 1 && this.rectKeepAspectRatio;
    }
}

