/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapclient;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.lbs.mapclient.CMBundle;
import oracle.lbs.mapclient.ClientMapRequest;
import oracle.lbs.mapclient.GeoFeature;
import oracle.lbs.mapclient.MapDefinition;
import oracle.lbs.mapclient.SVGFragment;
import oracle.lbs.mapclient.ScaleBarDef;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.lbs.mapcommon.MapResponse;
import oracle.mapviewer.share.GeoRasterBitmapMask;
import oracle.mapviewer.share.NorthArrow;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ThemeStyleInfo;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.mapviewer.share.style.StyleModel;
import oracle.sdovis.LiveFeature;
import oracle.sdovis.Proj;
import oracle.sdovis.ProjAzEd;
import oracle.sdovis.util.ShapeUtil;

public class MapViewer
implements Serializable {
    public static final int FORMAT_GIF_URL = 3;
    public static final int FORMAT_RAW_COMPRESSED = 9;
    public static final int FORMAT_PNG_URL = 13;
    public static final int FORMAT_JPEG_URL = 21;
    public static final int FORMAT_PNG8_URL = 25;
    public static final int FORMAT_PDF_URL = 51;
    protected transient HttpURLConnection mHttp = null;
    protected transient Image mImage = null;
    protected transient String mImageURL = null;
    protected transient String xmlreq = null;
    protected transient String xmlres = null;
    protected URL mURL = null;
    transient byte[] buf = new byte[4096];
    protected static int mDPI = 96;
    String mURLString = null;
    ClientMapRequest mRequest = null;
    MapDefinition mMapDef = null;
    MapResponse mResponse = null;
    GeoFeature[] mGeoFeatures = null;
    double[] mbr = null;
    SVGFragment svgStream = null;
    private static final String REQ_PARAM = "xml_request=";
    private static final String XML_HEADER = "<?xml version=\"1.0\" standalone=\"yes\" ?>";
    private static final String STY_APPEND = "    ";
    String wspName = null;
    String wspSavedPoint = null;
    String wspDate = null;
    String wspDateFormat = "mmddyyyyhh24miss";
    String wspDateNlsparam = null;
    boolean wspTimestamp = false;
    String cookies = null;
    public static String STYLE_COLOR;
    public static String STYLE_MARKER;
    public static String STYLE_AREA;
    public static String STYLE_LINE;
    public static String STYLE_TEXT;
    public static String STYLE_ADVANCED;
    private static final String AMP_ASCII;
    private static final String PERCENT_ASCII;
    private static final String PLUS_ASCII;

    public MapViewer() {
    }

    public MapViewer(String string) {
        this.setServiceURL(string);
    }

    public void setWebProxy(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        Properties properties = new Properties(System.getProperties());
        properties.put("proxySet", "true");
        properties.put("proxyHost", string);
        properties.put("proxyPort", string2);
        System.setProperties(properties);
    }

    public void init() {
        this.mRequest = new ClientMapRequest();
        this.mMapDef = new MapDefinition();
        this.mRequest.setMapDefinition(this.mMapDef);
        this.connect();
    }

    public void connect() {
        this.disConnect();
        try {
            this.mHttp = (HttpURLConnection)this.mURL.openConnection();
            this.mHttp.setDoOutput(true);
            this.mHttp.setDoInput(true);
            this.mHttp.setUseCaches(false);
            this.mHttp.setRequestMethod("POST");
            this.mHttp.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (this.cookies != null) {
                this.mHttp.setRequestProperty("Cookie", this.cookies);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            this.mHttp = null;
        }
    }

    public void disConnect() {
        try {
            if (this.mHttp != null) {
                this.mHttp.disconnect();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public Image getGeneratedMapImage() {
        return this.mImage;
    }

    public String getGeneratedMapImageURL() {
        return this.mImageURL;
    }

    public String getServiceURL() {
        return this.mURLString;
    }

    public void setServiceURL(String string) {
        this.mURLString = string;
        try {
            this.mURL = new URL(this.mURLString);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        this.init();
    }

    public String getDataSourceName() {
        return this.mMapDef.getMapDataSource();
    }

    public void setDataSourceName(String string) {
        this.mMapDef.setMapDataSource(string);
    }

    public void setWrapAround(boolean bl) {
        this.mMapDef.setWrapAround(bl);
    }

    public String getBaseMapName() {
        return this.mMapDef.getBaseMap();
    }

    public boolean dataSourceExists(String string) throws Exception {
        String string2 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <data_source_exists data_source=\"" + string + "\"/>" + "</non_map_request>";
        this.sendXMLRequest(string2);
        String string3 = this.getXMLResponse();
        if (string3.indexOf("succeed=\"true\"") < 0) {
            throw new Exception("cannot check existance for " + string);
        }
        return string3.indexOf("exists=\"true\"") > 0;
    }

    public String[] getDataSources() throws Exception {
        String string = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <list_data_sources /></non_map_request>";
        this.sendXMLRequest(string);
        String string2 = this.getXMLResponse();
        if (string2.indexOf("succeed=\"true\"") < 0) {
            throw new Exception("Error listing data sources.");
        }
        Vector<String> vector = new Vector<String>(5);
        int n = -1;
        int n2 = 0;
        while ((n = string2.indexOf("name=\"")) >= 0) {
            n2 = string2.indexOf("\"", n + 6);
            vector.add(string2.substring(n + 6, n2));
            string2 = string2.substring(n2, string2.length());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] getMapTileLayerNames() throws Exception {
        String string = "<?xml version=\"1.0\" standalone=\"yes\" ?><map_cache_admin_request>\n  <get_cache_status />\n</map_cache_admin_request>";
        String string2 = this.getServiceURL();
        if (string2 == null) {
            throw new Exception("No MapViewer server url specified.");
        }
        URL uRL = new URL(string2 = string2.replaceFirst("omserver", "mcserver"));
        String string3 = this.postXMLRequest(uRL, string);
        if (string3 == null) {
            throw new Exception("Error listing map cache instances.");
        }
        if (string3.indexOf("<cache_instance ") < 0) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>(5);
        int n = -1;
        int n2 = 0;
        while ((n = string3.indexOf("<cache_instance ")) >= 0) {
            n2 = string3.indexOf("/>", n + 10);
            int n3 = string3.indexOf("name=\"", n + 6);
            int n4 = string3.indexOf("\"", n3 + 6);
            String string4 = string3.substring(n3 + 6, n4);
            vector.add(string4);
            string3 = string3.substring(n2, string3.length());
        }
        return vector.toArray(new String[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postXMLRequest(URL uRL, String string) {
        try {
            String string2;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (httpURLConnection == null) {
                throw new Exception(CMBundle.getMsg("MAPVIEWER-03006"));
            }
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(REQ_PARAM.getBytes());
            outputStream.write(string.getBytes("UTF8"));
            outputStream.flush();
            outputStream.close();
            outputStream = null;
            InputStream inputStream = httpURLConnection.getInputStream();
            int n = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            byteArrayOutputStream.close();
            String string3 = string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            String string4 = null;
            return string4;
        }
    }

    public boolean styleExists(String string) throws Exception {
        if (this.mRequest != null && this.mRequest.getDynamicStyle(string) != null) {
            return true;
        }
        String string2 = this.getDataSourceName();
        if (string2 == null) {
            return false;
        }
        String string3 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <style_exists style_name=\"" + string + "\" data_source=\"" + string2 + "\"/>" + "</non_map_request>";
        this.sendXMLRequest(string3);
        String string4 = this.getXMLResponse();
        if (string4.indexOf("succeed=\"true\"") < 0) {
            throw new Exception(CMBundle.getMsg("MAPVIEWER-03002") + " Style name: " + string);
        }
        return string4.indexOf("exists=\"true\"") > 0;
    }

    public void addDataSource(String string, String string2, int n, String string3, String string4, String string5, String string6, int n2) throws Exception {
        String string7 = "<?xml version=\"1.0\" standalone=\"yes\" ?> <non_map_request>   <add_data_source          name=\"" + string + "\" " + "         jdbc_host=\"" + string2 + "\"" + "         jdbc_port=\"" + n + "\"" + "         jdbc_sid=\"" + string3 + "\"" + "         jdbc_user=\"" + string4 + "\"" + "         jdbc_password=\"" + string5 + "\"" + "         jdbc_mode=\"" + string6 + "\"" + "         number_of_mappers=\"" + n2 + "\" />" + " </non_map_request>";
        this.sendXMLRequest(string7);
        String string8 = this.getXMLResponse();
        if (string8.indexOf("succeed=\"true\"") < 0) {
            throw new Exception(CMBundle.getMsg("MAPVIEWER-03003") + string);
        }
    }

    public void setBaseMapName(String string) {
        this.mMapDef.setBaseMap(string);
    }

    public void addThemesFromBaseMap(String string) throws Exception {
        String string2 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>  <list_predefined_themes data_source=\"" + this.getDataSourceName() + "\" map=\"" + string + "\" />" + "</non_map_request>";
        this.sendXMLRequest(string2);
        String string3 = this.getXMLResponse();
        if (string3.indexOf("succeed=\"true\"") < 0) {
            throw new Exception(CMBundle.getMsg("MAPVIEWER-03004") + " Basemap name: " + string);
        }
        int n = -1;
        while ((n = string3.indexOf("name=\"")) > 0) {
            int n2 = string3.indexOf("/>", n);
            String string4 = string3.substring(n, n2);
            String[][] stringArray = MapViewer.parseNamedAttrs(string4);
            if (stringArray.length > 0) {
                String string5 = stringArray[0][1];
                String string6 = null;
                String string7 = null;
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.NEGATIVE_INFINITY;
                double d3 = Double.POSITIVE_INFINITY;
                double d4 = Double.NEGATIVE_INFINITY;
                boolean bl = false;
                boolean bl2 = true;
                double d5 = 0.5;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = true;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                String string11 = null;
                boolean bl6 = true;
                int n3 = 0;
                float f = 1.0f;
                String string12 = null;
                String string13 = null;
                String string14 = null;
                String string15 = "mmddyyyyhh24miss";
                String string16 = null;
                boolean bl7 = false;
                String string17 = null;
                int n4 = 10;
                long l = 0L;
                boolean bl8 = false;
                boolean bl9 = true;
                boolean bl10 = false;
                String string18 = "unbiased";
                int n5 = 8;
                if (stringArray.length > 1) {
                    for (int i = 1; i < stringArray.length; ++i) {
                        if ("min_scale".equalsIgnoreCase(stringArray[i][0])) {
                            string6 = stringArray[i][1];
                            try {
                                d = Double.parseDouble(string6);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if ("max_scale".equalsIgnoreCase(stringArray[i][0])) {
                            string7 = stringArray[i][1];
                            try {
                                d2 = Double.parseDouble(string7);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if ("label_min_scale".equalsIgnoreCase(stringArray[i][0])) {
                            string6 = stringArray[i][1];
                            try {
                                d3 = Double.parseDouble(string6);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if ("label_max_scale".equalsIgnoreCase(stringArray[i][0])) {
                            string7 = stringArray[i][1];
                            try {
                                d4 = Double.parseDouble(string7);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if ("label_always_on".equalsIgnoreCase(stringArray[i][0])) {
                            bl = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("min_dist".equalsIgnoreCase(stringArray[i][0])) {
                            try {
                                d5 = Double.parseDouble(stringArray[i][1]);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if ("visible_in_svg".equalsIgnoreCase(stringArray[i][0])) {
                            bl2 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("selectable_in_svg".equalsIgnoreCase(stringArray[i][0])) {
                            bl3 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("onclick".equalsIgnoreCase(stringArray[i][0])) {
                            string8 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("onmouseover".equalsIgnoreCase(stringArray[i][0])) {
                            string10 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("onmousemove".equalsIgnoreCase(stringArray[i][0])) {
                            string9 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("onmouseout".equalsIgnoreCase(stringArray[i][0])) {
                            string11 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("fixed_svglabel".equalsIgnoreCase(stringArray[i][0])) {
                            bl4 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("fast_unpickle".equalsIgnoreCase(stringArray[i][0])) {
                            bl6 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("simplify_shapes".equalsIgnoreCase(stringArray[i][0])) {
                            bl5 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("transparency".equalsIgnoreCase(stringArray[i][0])) {
                            try {
                                f = Float.parseFloat(stringArray[i][1]);
                                if (!(f < 0.0f) && !(f > 1.0f)) continue;
                                f = 1.0f;
                            }
                            catch (Exception exception) {
                                f = 1.0f;
                            }
                            continue;
                        }
                        if ("minimum_pixels".equalsIgnoreCase(stringArray[i][0])) {
                            try {
                                n3 = Integer.parseInt(stringArray[i][1]);
                            }
                            catch (Exception exception) {
                                n3 = 0;
                            }
                            continue;
                        }
                        if ("workspace_name".equalsIgnoreCase(stringArray[i][0])) {
                            string12 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("workspace_savepoint".equalsIgnoreCase(stringArray[i][0]) || "workspace_savedpoint".equalsIgnoreCase(stringArray[i][0])) {
                            string13 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("workspace_date".equalsIgnoreCase(stringArray[i][0])) {
                            string14 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("workspace_date_format".equalsIgnoreCase(stringArray[i][0])) {
                            string15 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("workspace_date_nlsparam".equalsIgnoreCase(stringArray[i][0])) {
                            string16 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("workspace_date_tswtz".equalsIgnoreCase(stringArray[i][0])) {
                            bl7 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("scale_mode".equalsIgnoreCase(stringArray[i][0])) {
                            string17 = stringArray[i][1].trim();
                            continue;
                        }
                        if ("fetch_size".equalsIgnoreCase(stringArray[i][0])) {
                            try {
                                n4 = Integer.parseInt(stringArray[i][1]);
                            }
                            catch (Exception exception) {
                                n4 = 10;
                            }
                            continue;
                        }
                        if ("timeout".equalsIgnoreCase(stringArray[i][0])) {
                            try {
                                l = Long.parseLong(stringArray[i][1]);
                            }
                            catch (Exception exception) {
                                l = 0L;
                            }
                            continue;
                        }
                        if ("no_repetitive_label".equalsIgnoreCase(stringArray[i][0])) {
                            bl8 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("allow_naked_points".equalsIgnoreCase(stringArray[i][0])) {
                            bl9 = "TRUE".equalsIgnoreCase(stringArray[i][1]);
                            continue;
                        }
                        if ("snap_to_tile_scale".equalsIgnoreCase(stringArray[i][0])) {
                            try {
                                bl10 = Boolean.parseBoolean(stringArray[i][1]);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if ("tile_resizing_option".equalsIgnoreCase(stringArray[i][0])) {
                            string18 = stringArray[i][1].trim();
                            continue;
                        }
                        if (!"current_threads".equalsIgnoreCase(stringArray[i][0])) continue;
                        try {
                            n5 = Integer.parseInt(stringArray[i][1]);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                this.addPredefinedTheme(string5);
                if (string6 != null && string7 != null) {
                    this.setThemeScale(string5, d, d2);
                    this.setThemeLabelScale(string5, d3, d4);
                    if (string17 != null && string17.trim().length() > 0) {
                        if (string17.trim().equalsIgnoreCase("RATIO")) {
                            this.setThemeScaleMode(string5, "RATIO");
                        }
                    } else {
                        this.setThemeScaleMode(string5, "MAPVIEWER_NATIVE");
                    }
                }
                this.setLabelAlwaysOn(bl, string5);
                this.setNoRepetitiveLabel(string5, bl8);
                this.setAllowNakedPoints(string5, bl9);
                this.mMapDef.setThemeMinDistForSVG(string5, d5);
                if (!bl2) {
                    this.setThemeVisibleInSVG(string5, false);
                }
                if (bl3) {
                    this.setThemeSelectableInSVG(string5, true);
                }
                if (string8 != null) {
                    this.setThemeOnClickInSVG(string5, string8);
                }
                if (string9 != null) {
                    this.setThemeOnMouseMoveInSVG(string5, string9);
                }
                if (string10 != null) {
                    this.setThemeOnMouseOverInSVG(string5, string10);
                }
                if (string11 != null) {
                    this.setThemeOnMouseOutInSVG(string5, string11);
                }
                if (bl4) {
                    this.setThemeFixedLabelInSVG(string5, true);
                }
                if (!bl6) {
                    this.setThemeFastUnpickle(string5, false);
                }
                if (!bl5) {
                    this.setThemeSimplifyShapes(string5, false);
                }
                this.setThemeTransparency(string5, f);
                if (n3 > 0) {
                    this.setThemePixelsForGeneralizedView(string5, n3);
                }
                if (string12 != null) {
                    this.setThemeWorkspace(string5, string12);
                    this.setThemeWorkspaceSavedPoint(string5, string13);
                    this.setThemeWorkspaceDate(string5, string14);
                    this.setThemeWorkspaceDateFormat(string5, string15, string16, bl7);
                }
                if (n4 > 0) {
                    this.setThemeFetchSize(string5, n4);
                }
                if (l > 0L) {
                    this.setThemeRequestTimeout(string5, l);
                }
                if (bl10) {
                    this.setSnapToTileScale(string5, bl10);
                }
                if (!string18.equalsIgnoreCase("unbiased")) {
                    this.setTileResizingOption(string5, string18);
                }
                if (n5 != 8) {
                    this.setCurrentThreads(string5, Math.max(1, n5));
                }
            }
            string3 = string3.substring(n2, string3.length());
        }
    }

    public void setBox(double d, double d2, double d3, double d4) {
        this.mRequest.setBox(d, d2, d3, d4);
    }

    public double[] getBox() {
        return this.mRequest.getBox();
    }

    public void setBoxWithSRID(double d, double d2, double d3, double d4, int n) {
        this.mRequest.setBoxWithSrid(d, d2, d3, d4, n);
    }

    public void setBox(double d, double d2, double d3, double d4, int n, boolean bl) {
        this.mRequest.setBox(d, d2, d3, d4, n, bl);
    }

    public double[] getRequestBox() {
        return this.mRequest.getBox();
    }

    public void setCenterAndSize(double d, double d2, double d3) {
        this.mRequest.setCenterAndSize(d, d2, d3);
    }

    public void setCenterAndSizeWithSRID(double d, double d2, double d3, int n) {
        this.mRequest.setCenterAndSizeWithSrid(d, d2, d3, n);
    }

    public void setCenterAndScale(double d, double d2, long l) {
        this.mRequest.setCenterAndScale(d, d2, l);
    }

    public void setCenterAndScaleWithSRID(double d, double d2, long l, int n) {
        this.mRequest.setCenterAndScaleWithSrid(d, d2, l, n);
    }

    public void setCenter(double d, double d2) {
        this.mRequest.setCenter(d, d2);
    }

    public void setSize(double d) {
        this.mRequest.setSize(d);
    }

    public void setScale(long l) {
        this.mRequest.setScale(l);
    }

    public void setKeepThemesOrder(boolean bl) {
        this.mRequest.setKeepThemesOrder(bl);
    }

    public Point2D getCenter() {
        try {
            GeoFeature geoFeature = this.mRequest.getCenter();
            return geoFeature.getCenterAsPoint2D();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Point2D getRequestCenter() {
        try {
            GeoFeature geoFeature = this.mRequest.getCenter();
            return geoFeature.getCenterAsPoint2D();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFullExtent() {
        this.mRequest.setCenter(null);
        this.mRequest.setSize(-1.0);
        this.mRequest.setBox(null);
        this.mRequest.clearBoundingThemes();
    }

    public double getSize() {
        return this.mRequest.getSize();
    }

    public double getRequestSize() {
        return this.mRequest.getSize();
    }

    public String getMapTitle() {
        return this.mRequest.getTitle();
    }

    public void setMapTitle(String string) {
        this.mRequest.setTitle(string);
    }

    public String getMapTitleStyleName() {
        return this.mRequest.getTitleStyleName();
    }

    public void setMapTitleStyleName(String string) {
        this.mRequest.setTitleStyleName(string);
    }

    public void setBoundingThemes(String[] stringArray, double d, boolean bl) {
        this.setFullExtent();
        this.mRequest.setBoundingThemes(stringArray, (float)d, bl);
    }

    public void setBoundingThemesSizeHint(double d) {
        this.mRequest.setBoundingThemesSizeHint(d);
    }

    public String[] getBoundingThemes() {
        return this.mRequest.getBoundingThemes();
    }

    public double getBorderMarginForBoundingThemes() {
        return this.mRequest.getBorderMarginForBoundingThemes();
    }

    public boolean boundingThemesRespectAspectRatio() {
        return this.mRequest.boundingThemesRespectAspectRatio();
    }

    public void setMapResultFileName(String string) {
        this.mRequest.setMapFileName(string);
    }

    public String getMapResultFileName() {
        return this.mRequest.getMapFileName();
    }

    public void setDeviceSize(Dimension dimension) {
        this.mRequest.setDeviceSize(dimension);
    }

    public Dimension getDeviceSize() {
        return this.mRequest.getDeviceSize();
    }

    public String getDeviceSizeUnit() {
        return this.mRequest.getDeviceSizeUnit();
    }

    public void setDeviceSizeUnit(String string) {
        this.mRequest.setDeviceSizeUnit(string);
    }

    public int getDeviceDPI() {
        return mDPI;
    }

    public void setDeviceDPI(int n) {
        if (n < 0) {
            return;
        }
        mDPI = n;
        this.mRequest.setDeviceDPI(n);
    }

    public void setBackgroundColor(Color color) {
        this.mRequest.setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.mRequest.getBackgroundColor();
    }

    public void setBackgroundImageURL(String string) {
        this.mRequest.setBackgroundImageURL(string);
    }

    public String getBackgroundImageURL() {
        return this.mRequest.getBackgroundImageURL();
    }

    public boolean isBackgroundTransparent() {
        return this.mRequest.isBgTransparent();
    }

    public void setBackgroundTransparent(boolean bl) {
        this.mRequest.setBgTransparent(bl);
    }

    public void setIsTileRequest(boolean bl) {
        this.mRequest.setIsTileRequest(bl);
    }

    public void setMapLegend(String string) {
        this.mRequest.setMapLegend(string);
    }

    public String getMapLegend() {
        return this.mRequest.getMapLegend();
    }

    public double getMapScale() {
        if (this.mRequest == null || this.mResponse == null || this.mbr == null) {
            return Double.NaN;
        }
        double d = this.getDeviceSize().getHeight() / (double)mDPI;
        double d2 = (this.mbr[3] - this.mbr[1]) / d;
        return d2;
    }

    public void setAntiAliasing(boolean bl) {
        this.mRequest.setAntiAliasing(bl);
    }

    public boolean getAntiAliasing() {
        return this.mRequest.getAntiAliasing();
    }

    public void setImageScaling(boolean bl) {
        this.mRequest.setImageScaling(bl);
    }

    public boolean getImageScaling() {
        return this.mRequest.getImageScaling();
    }

    public String[] getEnabledThemes() {
        Vector<String> vector = new Vector<String>();
        ThemeDescriptor[] themeDescriptorArray = this.mMapDef.getThemes();
        if (themeDescriptorArray == null) {
            return new String[0];
        }
        for (int i = 0; i < themeDescriptorArray.length; ++i) {
            if (!themeDescriptorArray[i].enabled) continue;
            vector.add(themeDescriptorArray[i].name);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setImageFormat(int n) {
        if (n != 9 && n != 1 && n != 13 && n != 25 && n != 3 && n != 21 && n != 51) {
            throw new IllegalArgumentException(CMBundle.getMsg("MAPVIEWER-03005"));
        }
        this.mRequest.setImageFormat(n);
    }

    public int getImageFormat() {
        return this.mRequest.getImageFormat();
    }

    public int getNumGeoFeatures() {
        return this.mGeoFeatures == null ? 0 : this.mGeoFeatures.length;
    }

    public void setDefaultStyleForCenter(String string, String string2, String string3, double[] dArray) {
        this.mRequest.setDefaultCenterLabel(string3);
        this.mRequest.setDefaultCenterLabelStyleName(string2);
        this.mRequest.setDefaultCenterRenderStyleName(string);
        this.mRequest.setDefaultCenterRadii(dArray);
    }

    public String getDefaultCenterRenderStyleName() {
        return this.mRequest.getDefaultCenterRenderStyleName();
    }

    public String getDefaultCenterLabelStyleName() {
        return this.mRequest.getDefaultCenterLabelStyleName();
    }

    public String getDefaultCenterLabel() {
        return this.mRequest.getDefaultCenterLabel();
    }

    public double[] getDefaultCenterRadii() {
        return this.mRequest.getDefaultCenterRadii();
    }

    public void addPointFeature(double d, double d2, int n, String string, String string2, String string3, double[] dArray, boolean bl) {
        this.addPointFeature(d, d2, n, string, string2, string3, dArray, null, bl);
    }

    public void addPointFeature(double d, double d2, int n, String string, String string2, String string3, double[] dArray) {
        this.addPointFeature(d, d2, n, string, string2, string3, dArray, false);
    }

    public void addPointFeature(double d, double d2, String string, String string2, String string3, double[] dArray) {
        this.addPointFeature(d, d2, 0, string, string2, string3, dArray);
    }

    public void addPointFeature(double d, double d2, int n, String string, String string2, String string3, double[] dArray, Object[] objectArray, boolean bl) {
        this.addPointFeature(d, d2, n, string, string2, string3, dArray, objectArray, 0.0, 0.0, 0.0, bl);
    }

    public void addPointFeature(double d, double d2, int n, String string, String string2, String string3, double[] dArray, Object[] objectArray, double d3, double d4, double d5, boolean bl) {
        this.addPointFeature(d, d2, n, string, string2, string3, dArray, objectArray, d3, d4, d5, bl, null, false, null, null);
    }

    public void addPointFeature(double d, double d2, int n, String string, String string2, String string3, double[] dArray, Object[] objectArray, double d3, double d4, double d5, boolean bl, String string4, boolean bl2, String string5, String string6) {
        int n2 = 0;
        GeoFeature geoFeature = new GeoFeature(d, d2);
        geoFeature.setSrid(n);
        if (string != null) {
            geoFeature.setRenderStyleName(string);
        }
        if (string2 != null) {
            geoFeature.setLabel(string2);
        }
        if (string3 != null) {
            geoFeature.setLabelStyleName(string3);
        }
        if (dArray != null && dArray.length > 0) {
            geoFeature.setRadius(dArray);
        }
        if (objectArray != null && objectArray.length > 0) {
            geoFeature.setAttrs(objectArray);
        }
        geoFeature.setLabelAlwaysOn(bl);
        geoFeature.setMarkerOrientation(d3, d4, d5);
        geoFeature.setHiddenInfo(string4);
        geoFeature.setSelectableInSVG(bl2);
        geoFeature.setID(string5);
        geoFeature.setOnClick(string6);
        if (this.mGeoFeatures == null) {
            this.mGeoFeatures = new GeoFeature[1];
        } else {
            n2 = this.mGeoFeatures.length;
            GeoFeature[] geoFeatureArray = new GeoFeature[n2 + 1];
            System.arraycopy(this.mGeoFeatures, 0, geoFeatureArray, 0, n2);
            this.mGeoFeatures = geoFeatureArray;
        }
        this.mGeoFeatures[n2] = geoFeature;
        this.mRequest.setGeoFeatures(this.mGeoFeatures);
    }

    public void addLinearFeature(String string, double[] dArray, int n, String string2, String string3, String string4, boolean bl) {
        int n2 = 0;
        GeoFeature geoFeature = new GeoFeature();
        if (string2 != null) {
            geoFeature.setRenderStyleName(string2);
        }
        if (string3 != null) {
            geoFeature.setLabel(string3);
        }
        if (string4 != null) {
            geoFeature.setLabelStyleName(string4);
        }
        geoFeature.setSrid(n);
        geoFeature.setID(string);
        geoFeature.setLineString(dArray);
        geoFeature.setLabelAlwaysOn(bl);
        if (this.mGeoFeatures == null) {
            this.mGeoFeatures = new GeoFeature[1];
        } else {
            n2 = this.mGeoFeatures.length;
            GeoFeature[] geoFeatureArray = new GeoFeature[n2 + 1];
            System.arraycopy(this.mGeoFeatures, 0, geoFeatureArray, 0, n2);
            this.mGeoFeatures = geoFeatureArray;
        }
        this.mGeoFeatures[n2] = geoFeature;
        this.mRequest.setGeoFeatures(this.mGeoFeatures);
    }

    public void addLinearFeature(double[] dArray, int n, String string, String string2, String string3, boolean bl) {
        this.addLinearFeature(null, dArray, n, string, string2, string3, bl);
    }

    public void addLinearFeature(double[] dArray, int n, String string, String string2, String string3) {
        this.addLinearFeature(dArray, n, string, string2, string3, false);
    }

    public void addLinearFeature(double[] dArray, String string, String string2, String string3) {
        this.addLinearFeature(dArray, 0, string, string2, string3);
    }

    public void addPolygonFeature(double[][] dArray, int n, String string, String string2, String string3, boolean bl) {
        this.addPolygonFeature(null, dArray, n, string, string2, string3, bl);
    }

    public void addPolygonFeature(String string, double[][] dArray, int n, String string2, String string3, String string4, boolean bl) {
        int n2 = 0;
        GeoFeature geoFeature = new GeoFeature();
        if (string2 != null) {
            geoFeature.setRenderStyleName(string2);
        }
        if (string3 != null) {
            geoFeature.setLabel(string3);
        }
        if (string4 != null) {
            geoFeature.setLabelStyleName(string4);
        }
        geoFeature.setID(string);
        geoFeature.setSrid(n);
        geoFeature.setPolygon(dArray);
        geoFeature.setLabelAlwaysOn(bl);
        if (this.mGeoFeatures == null) {
            this.mGeoFeatures = new GeoFeature[1];
        } else {
            n2 = this.mGeoFeatures.length;
            GeoFeature[] geoFeatureArray = new GeoFeature[n2 + 1];
            System.arraycopy(this.mGeoFeatures, 0, geoFeatureArray, 0, n2);
            this.mGeoFeatures = geoFeatureArray;
        }
        this.mGeoFeatures[n2] = geoFeature;
        this.mRequest.setGeoFeatures(this.mGeoFeatures);
    }

    public void removeAllPointFeatures() {
        this.removeAllGeoFeaturesWithType(1);
    }

    public void removeAllLinearFeatures() {
        this.removeAllGeoFeaturesWithType(2);
    }

    public void removeAllPolygonFeatures() {
        this.removeAllGeoFeaturesWithType(3);
    }

    public boolean removeGeoFeature(String string) {
        GeoFeature[] geoFeatureArray;
        int n;
        if (string == null || this.mGeoFeatures == null) {
            return false;
        }
        int n2 = 0;
        int n3 = this.mGeoFeatures.length;
        for (n = 0; n < n3; ++n) {
            geoFeatureArray = this.mGeoFeatures[n];
            String string2 = geoFeatureArray.getID();
            if (string2 == null || !string2.equals(string)) continue;
            this.mGeoFeatures[n] = null;
            ++n2;
            break;
        }
        if (n2 == 0) {
            return false;
        }
        if (n2 == n3) {
            this.mGeoFeatures = null;
        } else {
            geoFeatureArray = new GeoFeature[n3 - n2];
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                if (this.mGeoFeatures[n] == null) continue;
                geoFeatureArray[n2++] = this.mGeoFeatures[n];
            }
            this.mGeoFeatures = geoFeatureArray;
        }
        this.mRequest.setGeoFeatures(this.mGeoFeatures);
        return true;
    }

    public void removeAllGeoFeaturesWithType(int n) {
        GeoFeature[] geoFeatureArray;
        int n2;
        if (this.mGeoFeatures == null) {
            return;
        }
        int n3 = 0;
        int n4 = this.mGeoFeatures.length;
        for (n2 = 0; n2 < n4; ++n2) {
            geoFeatureArray = this.mGeoFeatures[n2];
            if (geoFeatureArray.getGeomType() != n) continue;
            this.mGeoFeatures[n2] = null;
            ++n3;
        }
        if (n3 == n4) {
            this.mGeoFeatures = null;
        } else {
            geoFeatureArray = new GeoFeature[n4 - n3];
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.mGeoFeatures[n2] == null) continue;
                geoFeatureArray[n3++] = this.mGeoFeatures[n2];
            }
            this.mGeoFeatures = geoFeatureArray;
        }
        this.mRequest.setGeoFeatures(this.mGeoFeatures);
    }

    public void enableThemes(String[] stringArray) {
        this.setAllThemesEnabled(false);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.setThemeEnabled(true, stringArray[i]);
        }
    }

    public void setAllThemesEnabled(boolean bl) {
        String[] stringArray = this.getThemeNames();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.setThemeEnabled(bl, stringArray[i]);
        }
    }

    public int getNumGeoFeatures(int n) {
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        if (this.mGeoFeatures == null) {
            return 0;
        }
        int n2 = 0;
        for (GeoFeature geoFeature : this.mGeoFeatures) {
            if (geoFeature.getGeomType() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int numPointFeatures() {
        return this.getNumPointFeatures();
    }

    public int getNumPointFeatures() {
        return this.getNumGeoFeatures(1);
    }

    public int getNumLinearFeatures() {
        return this.getNumGeoFeatures(2);
    }

    public int getNumPolygonFeatures() {
        return this.getNumGeoFeatures(3);
    }

    public boolean hasThemes() {
        if (this.mMapDef != null) {
            return this.mMapDef.hasThemes();
        }
        return false;
    }

    public int getThemePosition(String string) {
        return this.mMapDef.getThemePosition(string);
    }

    public boolean getThemeEnabled(String string) {
        return this.mMapDef.isEnabled(string);
    }

    public boolean getThemeVisibleInSVG(String string) {
        return this.mMapDef.isVisibleInSVG(string);
    }

    public double[] getMapMBR() {
        return this.mbr;
    }

    public String[] getMapResponseThemeNames() {
        if (this.mResponse == null) {
            return null;
        }
        return this.mResponse.getThemeNames();
    }

    public int addPredefinedTheme(String string) {
        return this.mMapDef.addPredefinedTheme(string);
    }

    public int addPredefinedTheme(int n, String string) {
        return this.mMapDef.addPredefinedTheme(n, string);
    }

    public int addPredefinedTheme(String string, String string2) {
        return this.mMapDef.addPredefinedTheme(string, string2);
    }

    public int addPredefinedTheme(String string, String string2, Properties properties) {
        boolean bl = false;
        String string3 = "unbiased";
        int n = 8;
        if (properties != null) {
            String string4 = properties.getProperty("snap_to_tile_scale", "false");
            bl = Boolean.parseBoolean(string4);
            string3 = properties.getProperty("tile_resizing_option", "unbiased");
            string4 = properties.getProperty("current_threads", Integer.toString(8));
            try {
                n = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mMapDef.addPredefinedTheme(string, string2, bl, string3, n);
    }

    public int addPredefinedTheme(int n, String string, String string2) {
        return this.mMapDef.addPredefinedTheme(n, string, string2);
    }

    public int addPredefinedTheme(String string, String string2, String string3) {
        return this.mMapDef.addPredefinedTheme(string, string2, string3);
    }

    public int addPredefinedTheme(int n, String string, String string2, String string3) {
        return this.mMapDef.addPredefinedTheme(n, string, string2, string3);
    }

    public int addImageTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return this.mMapDef.addImageTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public int addImageTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return this.mMapDef.addImageTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public int addImageTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        return this.mMapDef.addImageTheme(string, string2, string3, string4, string5, string6, string7, bl);
    }

    public int addImageTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        return this.mMapDef.addImageTheme(n, string, string2, string3, string4, string5, string6, string7, bl);
    }

    public int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, boolean bl) {
        String string15 = null;
        return this.mMapDef.addGeoRasterTheme(string, string2, string3, string4, string5, string6, string7, string15, string8, string9, string10, string11, string12, string13, string14, bl);
    }

    public int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, boolean bl) {
        String string15 = null;
        return this.mMapDef.addGeoRasterTheme(n, string, string2, string3, string4, string5, string6, string7, string15, string8, string9, string10, string11, string12, string13, string14, bl);
    }

    public int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) {
        String string10 = null;
        return this.mMapDef.addGeoRasterTheme(string, string2, string10, string3, string4, string5, string6, string7, string8, string9, bl);
    }

    public int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) {
        String string10 = null;
        return this.mMapDef.addGeoRasterTheme(n, string, string2, string10, string3, string4, string5, string6, string7, string8, string9, bl);
    }

    public int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return this.mMapDef.addGeoRasterTheme(string, string2, string3, string4, string5, null, null, string6, string7, string8, bl);
    }

    public int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return this.mMapDef.addGeoRasterTheme(n, string, string2, string3, string4, string5, null, null, string6, string7, string8, bl);
    }

    public int addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl) {
        return this.mMapDef.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, bl);
    }

    public int addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return this.mMapDef.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, bl);
    }

    public int addJDBCTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl) {
        return this.mMapDef.addJDBCTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, bl);
    }

    public int addJDBCTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return this.mMapDef.addJDBCTheme(n, string, string2, string3, string4, string5, string6, string7, string8, bl);
    }

    public int addTopologyTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        return this.mMapDef.addTopologyTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl);
    }

    public int addTopologyTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        return this.mMapDef.addTopologyTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl);
    }

    public int addTopologyThemeFromView(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return this.mMapDef.addTopologyThemeFromView(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public int addTopologyThemeFromView(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return this.mMapDef.addTopologyThemeFromView(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public int addTopologyDebugTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2, String string7, String string8, String string9, String string10, String string11, boolean bl) {
        return this.mMapDef.addTopologyDebugTheme(n, string, string2, string3, string4, string5, string6, n2, string7, string8, string9, string10, string11, bl);
    }

    public int addTopologyDebugTheme(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, String string8, String string9, String string10, String string11, boolean bl) {
        return this.mMapDef.addTopologyDebugTheme(string, string2, string3, string4, string5, string6, n, string7, string8, string9, string10, string11, bl);
    }

    public int addNetworkTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, double d, int n2, String string7, int n3, String string8, String string9, int n4, boolean bl) {
        return this.mMapDef.addNetworkTheme(n, string, string2, string3, string4, string5, string6, d, n2, string7, n3, string8, string9, n4, bl);
    }

    public int addNetworkTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, double d, int n2, String string12, int n3, String string13, String string14, int n4, boolean bl) {
        return this.mMapDef.addNetworkTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, d, n2, string12, n3, string13, string14, n4, bl);
    }

    public int addNetworkTheme(String string, String string2, String string3, String string4, String string5, String string6, double d, int n, String string7, int n2, String string8, String string9, int n3, boolean bl) {
        return this.mMapDef.addNetworkTheme(string, string2, string3, string4, string5, string6, d, n, string7, n2, string8, string9, n3, bl);
    }

    public int addNetworkTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, double d, int n, String string12, int n2, String string13, String string14, int n3, boolean bl) {
        return this.mMapDef.addNetworkTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, d, n, string12, n2, string13, string14, n3, bl);
    }

    public int addShortestPath(int n, String string, String string2, String string3, String string4, int n2, int n3, String string5, String string6, String string7, String string8, int n4, boolean bl) {
        return this.mMapDef.addShortestPath(n, string, string2, string3, string4, n2, n3, string5, string6, string7, string8, n4, bl);
    }

    public int addShortestPath(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, String string7, String string8, int n3, boolean bl) {
        return this.mMapDef.addShortestPath(string, string2, string3, string4, n, n2, string5, string6, string7, string8, n3, bl);
    }

    public int addNetworkLinks(String string, String string2, String string3, String string4, String string5, String string6, double d, int n, int n2, boolean bl) {
        return this.mMapDef.addNetworkTheme(string, string2, string3, string4, string5, string6, d, n, null, 3, null, null, n2, bl);
    }

    public int addNetworkNodes(String string, String string2, String string3, String string4, String string5, int n, int n2, boolean bl) {
        return this.mMapDef.addNetworkTheme(string, string2, string3, string4, null, null, 0.75, 3, string5, n, null, null, n2, bl);
    }

    public int addNetworkPaths(String string, String string2, String string3, String string4, String string5, String string6, int n, boolean bl) {
        return this.mMapDef.addNetworkTheme(string, string2, string3, string4, null, null, 0.75, 3, null, 3, string5, string6, n, bl);
    }

    public int addLinksWithinCost(String string, String string2, String string3, int n, String string4, String string5, double d, String string6, int n2, boolean bl) {
        return this.mMapDef.addLinksWithinCost(string, string2, string3, n, string4, string5, d, string6, n2, bl);
    }

    public int addWMSMapTheme(String string, String string2, String[] stringArray, String[] stringArray2, Object[] objectArray) {
        return this.mMapDef.addWMSMapTheme(string, string2, "false", "1.1.1", stringArray, stringArray2, "EPSG:4326", "image/png", "true", "0xffffff", "application/vnd.ogc.se_xml", objectArray);
    }

    public int addWMSMapTheme(String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4, String string5, Object[] objectArray) {
        return this.mMapDef.addWMSMapTheme(string, string2, "false", "1.1.1", stringArray, stringArray2, string3, string4, "true", string5, "application/vnd.ogc.se_xml", objectArray);
    }

    public int addWMSMapTheme(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String string5, String string6, String string7, String string8, String string9, Object[] objectArray) {
        return this.mMapDef.addWMSMapTheme(string, string2, string3, string4, stringArray, stringArray2, string5, string6, string7, string8, string9, objectArray);
    }

    public int addMapCacheTheme(String string, String string2, String string3, boolean bl) {
        return this.mMapDef.addMapCacheTheme(string, string2, string3, bl, "unbiased");
    }

    public int addMapTileTheme(String string, String string2, String string3, boolean bl) {
        return this.mMapDef.addMapCacheTheme(string, string2, string3, bl, "unbiased");
    }

    public int addMapTileTheme(String string, String string2, String string3, boolean bl, String string4) {
        return this.mMapDef.addMapCacheTheme(string, string2, string3, bl, string4);
    }

    public int addWFSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String string10) {
        return this.mMapDef.addWFSTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, stringArray, stringArray2, string10);
    }

    public int addWFSTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String string10) {
        return this.mMapDef.addWFSTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, stringArray, stringArray2, string10);
    }

    public int addWFSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return this.mMapDef.addWFSTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, stringArray, stringArray2, stringArray3);
    }

    public int addWFSTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return this.mMapDef.addWFSTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, stringArray, stringArray2, stringArray3);
    }

    public int addWMTSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return this.mMapDef.addWMTSTheme(string, string2, string3, string4, string5, string6, string7, string8, false, "unbiased", 8);
    }

    public int addWMTSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, double d, double d2) {
        return this.mMapDef.addWMTSTheme(string, string2, string3, string4, string5, string6, string7, string8, false, "unbiased", 8, d, d2);
    }

    public int addWMTSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Properties properties, double d, double d2) {
        boolean bl = false;
        String string9 = "unbiased";
        int n = 8;
        if (properties != null) {
            String string10 = properties.getProperty("snap_to_tile_scale", "false");
            bl = Boolean.parseBoolean(string10);
            string9 = properties.getProperty("tile_resizing_option", "unbiased");
            string10 = properties.getProperty("current_threads", Integer.toString(8));
            try {
                n = Integer.parseInt(string10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mMapDef.addWMTSTheme(string, string2, string3, string4, string5, string6, string7, string8, bl, string9, n, d, d2);
    }

    public int addAnnotationTextTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        return this.mMapDef.addAnnotationTextTheme(n, string, string2, string3, string4, string5, string6, string7, bl);
    }

    public int addAnnotationTextTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) {
        return this.mMapDef.addAnnotationTextTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, bl);
    }

    public int addAnnotationTextTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        return this.mMapDef.addAnnotationTextTheme(string, string2, string3, string4, string5, string6, string7, bl);
    }

    public int addAnnotationTextTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) {
        return this.mMapDef.addAnnotationTextTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, bl);
    }

    public void setAnnoTextThemeExpressionColumn(String string, String string2) {
        this.mMapDef.setAnnoTextThemeExpressionColumn(string, string2);
    }

    public int addCustomGeometryTheme(int n, String string, String string2, String string3, Properties properties, String string4, String string5, String string6, String string7, String[] stringArray, String string8) {
        return this.mMapDef.addCustomGeometryTheme(n, string, string2, string3, properties, string4, string5, string6, string7, stringArray, string8, null, false);
    }

    public int addCustomGeometryTheme(int n, String string, String string2, String string3, Properties properties, String string4, String string5, String string6, String string7, String[] stringArray, String string8, String string9, boolean bl) {
        return this.mMapDef.addCustomGeometryTheme(n, string, string2, string3, properties, string4, string5, string6, string7, stringArray, string8, string9, bl);
    }

    public int addCustomGeometryTheme(String string, String string2, String string3, Properties properties, String string4, String string5, String string6, String string7, String[] stringArray, String string8) {
        return this.mMapDef.addCustomGeometryTheme(string, string2, string3, properties, string4, string5, string6, string7, stringArray, string8, null, false);
    }

    public int addCustomGeometryTheme(String string, String string2, String string3, Properties properties, String string4, String string5, String string6, String string7, String[] stringArray, String string8, String string9, boolean bl) {
        return this.mMapDef.addCustomGeometryTheme(string, string2, string3, properties, string4, string5, string6, string7, stringArray, string8, string9, bl);
    }

    public void deleteTheme(String string) {
        this.mMapDef.deleteTheme(string);
    }

    public void deleteAllThemes() {
        this.mMapDef.deleteAllThemes();
    }

    public void setThemeEnabled(boolean bl, String string) {
        this.mMapDef.setEnabled(bl, string);
    }

    public void setLabelAlwaysOn(boolean bl, String string) {
        this.mMapDef.setLabelAlwaysOn(bl, string);
    }

    public void setClickable(boolean bl, String string) {
        this.mMapDef.setClickable(bl, string);
    }

    public boolean isClickable(String string) {
        return this.mMapDef.isClickable(string);
    }

    public void moveThemeUp(int n) {
        this.mMapDef.moveThemeUp(n);
    }

    public void moveThemeDown(int n) {
        this.mMapDef.moveThemeDown(n);
    }

    public String getActiveTheme(double d) {
        return this.mMapDef.getActiveTheme(d);
    }

    public void setThemeScale(String string, double d, double d2) {
        this.mMapDef.setThemeScale(string, d, d2);
    }

    public void setThemeLabelScale(String string, double d, double d2) {
        this.mMapDef.setThemeLabelScale(string, d, d2);
    }

    public void setThemeScaleMode(String string, String string2) {
        this.mMapDef.setThemeScaleMode(string, string2);
    }

    public void setThemeRequestTimeout(String string, long l) {
        this.mMapDef.setThemeRequestTimeout(string, l);
    }

    public void setSnapToTileScale(String string, boolean bl) {
        this.mMapDef.setSnapToTileScale(string, bl);
    }

    public void setTileResizingOption(String string, String string2) {
        this.mMapDef.setTileResizingOption(string, string2);
    }

    public void setCurrentThreads(String string, int n) {
        this.mMapDef.setCurrentThreads(string, n);
    }

    public void setThemeVisibleInSVG(String string, boolean bl) {
        this.mMapDef.setThemeVisibleInSVG(string, bl);
    }

    public void setThemePartOfBaseMapInSVG(String string, boolean bl) {
        this.mMapDef.setThemePartOfBaseMapInSVG(string, bl);
    }

    public void setThemeSelectableInSVG(String string, boolean bl) {
        this.mMapDef.setThemeSelectableInSVG(string, bl);
    }

    public void setThemeFixedLabelInSVG(String string, boolean bl) {
        this.mMapDef.setThemeFixedLabelInSVG(string, bl);
    }

    public void setThemeSimplifyShapes(String string, boolean bl) {
        this.mMapDef.setThemeSimplifyShapes(string, bl);
    }

    public void setThemeOnClickInSVG(String string, String string2) {
        this.mMapDef.setThemeOnClickInSVG(string, string2);
    }

    public void setThemeOnMouseMoveInSVG(String string, String string2) {
        this.mMapDef.setThemeOnMouseMoveInSVG(string, string2);
    }

    public void setThemeOnMouseOverInSVG(String string, String string2) {
        this.mMapDef.setThemeOnMouseOverInSVG(string, string2);
    }

    public void setThemeOnMouseOutInSVG(String string, String string2) {
        this.mMapDef.setThemeOnMouseOutInSVG(string, string2);
    }

    public void setThemeMinDistForSVG(String string, int n) {
        this.mMapDef.setThemeMinDistForSVG(string, n);
    }

    public void setJDBCThemeKeyColumn(String string, String string2) {
        this.mMapDef.setJDBCThemeKeyColumn(string, string2);
    }

    public void setJDBCThemeHiddenInfoDef(String string, String string2) {
        this.mMapDef.setJDBCThemeHiddenInfoDef(string, string2);
    }

    public void setSVGShowInfo(boolean bl) {
        this.mRequest.setSVGShowInfo(bl);
    }

    public void setThemeFastUnpickle(String string, boolean bl) {
        this.mMapDef.setThemeFastUnpickle(string, bl);
    }

    public void setThemeReorientLines(String string, boolean bl) {
        this.mMapDef.setThemeReorientLines(string, bl);
    }

    public void setThemeUpsideDownLabels(String string, boolean bl) {
        this.mMapDef.setThemeUpsideDownLabels(string, bl);
    }

    public void setGeoRasterThemePolygonMask(String string, double[] dArray) {
        this.mMapDef.setGeoRasterThemePolygonMask(string, dArray);
    }

    public void setGeoRasterThemePolygonMaskSRID(String string, int n) {
        this.mMapDef.setGeoRasterThemePolygonMaskSRID(string, n);
    }

    public void setGeoRasterThemePolygonMask(String string, String string2, String string3, String string4, String string5, String string6) {
        this.mMapDef.setGeoRasterThemePolygonMask(string, string2, string3, string4, string5, string6);
    }

    public void setGeoRasterThemeTransparentNODATA(String string, boolean bl) {
        this.mMapDef.setGeoRasterThemeTransparentNODATA(string, bl);
    }

    public void setGeoRasterThemeAlphaBand(String string, int n) {
        this.mMapDef.setGeoRasterThemeAlphaBand(string, n);
    }

    public void setGeoRasterThemeBitmapMasks(String string, GeoRasterBitmapMask[] geoRasterBitmapMaskArray) {
        this.mMapDef.setGeoRasterThemeBitmapMasks(string, geoRasterBitmapMaskArray);
    }

    public void setGeoRasterThemeReprojectionMode(String string, String string2) {
        this.mMapDef.setGeoRasterThemeReprojectionMode(string, string2);
    }

    public void setGeoRasterThemeFilterReprojectionResult(String string, boolean bl) {
        this.mMapDef.setGeoRasterThemeFilterReprojectionResult(string, bl);
    }

    public void setGeoRasterThemeRenderInterpolationHint(String string, String string2) {
        this.mMapDef.setGeoRasterThemeRenderInterpolationHint(string, string2);
    }

    public void setNetworkThemeMultipleDirectionMarker(String string, boolean bl) {
        this.mMapDef.setNetworkThemeMultipleDirectionMarker(string, bl);
    }

    public void setNetworkThemeBiDirectionMarker(String string, String string2) {
        this.mMapDef.setNetworkThemeBiDirectionMarker(string, string2);
    }

    public void setNetworkThemeLabels(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.mMapDef.setNetworkThemeLabels(string, string2, string3, string4, string5, string6, string7);
    }

    public void setNetworkThemeDirectionMarkerSize(String string, double d, String string2) {
        this.mMapDef.setNetworkThemeDirectionMarkerSize(string, d, string2);
    }

    public void setNetworkThemeNodeMarkerSize(String string, double d, String string2) {
        this.mMapDef.setNetworkThemeNodeMarkerSize(string, d, string2);
    }

    public void setWFSThemeVersion(String string, String string2) {
        this.mMapDef.setWFSThemeVersion(string, string2);
    }

    public void setWFSThemeOutputFormat(String string, String string2) {
        this.mMapDef.setWFSThemeOutputFormat(string, string2);
    }

    public void setJDBCThemePointColumns(String string, String string2, String string3) {
        this.mMapDef.setJDBCThemePointColumns(string, string2, string3);
    }

    public void setThemeUnitAndResolution(String string, String string2, double d) {
        this.mMapDef.setThemeUnitAndResolution(string, string2, d);
    }

    public void setThemeAlpha(String string, float f) {
        this.mMapDef.setThemeAlpha(string, f);
    }

    public void setThemeTransparency(String string, float f) {
        this.mMapDef.setThemeTransparency(string, f);
    }

    public void setThemeWorkspace(String string, String string2) {
        this.mMapDef.setThemeWorkspace(string, string2);
    }

    public void setThemeWorkspaceSavedPoint(String string, String string2) {
        this.mMapDef.setThemeWorkspaceSavedPoint(string, string2);
    }

    public void setThemeWorkspaceDate(String string, String string2) {
        this.mMapDef.setThemeWorkspaceDate(string, string2);
    }

    public void setThemeWorkspaceDateFormat(String string, String string2, String string3, boolean bl) {
        this.mMapDef.setThemeWorkspaceDateFormat(string, string2, string3, bl);
    }

    public void setThemePixelsForGeneralizedView(String string, int n) {
        this.mMapDef.setThemePixelsForGeneralizedView(string, n);
    }

    public void setThemeAuthentication(String string, String string2, String string3) {
        this.mMapDef.setThemeAuthentication(string, string2, string3);
    }

    public void setNoRepetitiveLabel(String string, boolean bl) {
        this.mMapDef.setNoRepetitiveLabel(string, bl);
    }

    public void setAllowNakedPoints(String string, boolean bl) {
        this.mMapDef.setAllowNakedPoints(string, bl);
    }

    public void setPredefinedThemeParameters(String string, Object[] objectArray) {
        this.mMapDef.setPredefinedThemeParameters(string, objectArray);
    }

    public void addGeoRasterThemeOperation(String string, String string2) {
        this.mMapDef.addGeoRasterThemeOperation(string, string2);
    }

    public void addGeoRasterThemeOperation(String string, String string2, String string3, String string4) {
        this.mMapDef.addGeoRasterThemeOperation(string, string2, string3, string4);
    }

    public void deleteAllGeoRasterThemeOperations(String string) {
        this.mMapDef.deleteAllGeoRasterThemeOperations(string);
    }

    public String[] getGeoRasterThemeOperationNames(String string) {
        return this.mMapDef.getGeoRasterThemeOperationNames(string);
    }

    public void removeGeoRasterThemeOperation(String string, String string2) {
        this.mMapDef.removeGeoRasterThemeOperation(string, string2);
    }

    public Hashtable getGeoRasterThemeOperationParameters(String string, String string2) {
        return this.getGeoRasterThemeOperationParameters(string, string2);
    }

    public String[] getThemeNames() {
        return this.mMapDef.getThemeNames();
    }

    public String[] getPredefinedThemes(String string) throws Exception {
        String string2 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <list_predefined_themes data_source=\"" + string + "\"/>" + "</non_map_request>";
        this.sendXMLRequest(string2);
        String string3 = this.getXMLResponse();
        if (string3.indexOf("succeed=\"true\"") < 0) {
            throw new Exception("cannot get predefined theme names for " + string);
        }
        Vector<String> vector = new Vector<String>(13);
        int n = string3.indexOf("name=\"");
        while (n > 0) {
            int n2 = string3.indexOf(34, 6 + n);
            if (n2 > 0) {
                vector.add(string3.substring(n + 6, n2));
            }
            n = string3.indexOf("name=\"", n2);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] getPredefinedThemes(String string, String string2) throws Exception {
        String string3 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <list_predefined_themes data_source=\"" + string + "\" map=\"" + string2 + "\" />" + "</non_map_request>";
        this.sendXMLRequest(string3);
        String string4 = this.getXMLResponse();
        if (string4.indexOf("succeed=\"true\"") < 0) {
            throw new Exception("cannot get predefined theme names for " + string2 + " in " + string);
        }
        Vector<String> vector = new Vector<String>(13);
        int n = string4.indexOf("name=\"");
        while (n > 0) {
            int n2 = string4.indexOf(34, 6 + n);
            if (n2 > 0) {
                vector.add(string4.substring(n + 6, n2));
            }
            n = string4.indexOf("name=\"", n2);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public ThemeStyleInfo[] getPredefinedThemeStyles(String string, String string2) throws Exception {
        String string3 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <list_theme_styles data_source=\"" + string + "\" theme=\"" + string2 + "\" />" + "</non_map_request>";
        this.sendXMLRequest(string3);
        String string4 = this.getXMLResponse();
        if (string4.indexOf("succeed=\"true\"") < 0) {
            throw new Exception("cannot get predefined theme styles for " + string2 + " in " + string);
        }
        Vector<ThemeStyleInfo> vector = new Vector<ThemeStyleInfo>(13);
        int n = string4.indexOf("name=\"");
        while (n > 0) {
            String string5;
            ThemeStyleInfo themeStyleInfo = new ThemeStyleInfo();
            int n2 = string4.indexOf(34, 6 + n);
            if (n2 <= 0) break;
            themeStyleInfo.setName(string4.substring(n + 6, n2));
            n = string4.indexOf("type=\"", n2);
            if (n > 0 && (n2 = string4.indexOf(34, 6 + n)) > 0) {
                themeStyleInfo.setType(string4.substring(n + 6, n2));
            }
            if ((n = string4.indexOf("render=\"", n2)) > 0 && (n2 = string4.indexOf(34, 8 + n)) > 0 && (string5 = string4.substring(n + 8, n2)) != null && string5.equalsIgnoreCase("true")) {
                themeStyleInfo.setRendering(true);
            }
            if ((n = string4.indexOf("label=\"", n2)) > 0 && (n2 = string4.indexOf(34, 7 + n)) > 0 && (string5 = string4.substring(n + 7, n2)) != null && string5.equalsIgnoreCase("true")) {
                themeStyleInfo.setLabeling(true);
            }
            if ((n = string4.indexOf("highlight=\"", n2)) > 0 && (n2 = string4.indexOf(34, 11 + n)) > 0 && (string5 = string4.substring(n + 11, n2)) != null && string5.equalsIgnoreCase("true")) {
                themeStyleInfo.setHighlighting(true);
            }
            if ((n = string4.indexOf("description=\"", n2)) > 0 && (n2 = string4.indexOf(34, 13 + n)) > 0 && (string5 = string4.substring(n + 13, n2)) != null && !string5.equalsIgnoreCase("null")) {
                themeStyleInfo.setDescription(string5);
            }
            vector.add(themeStyleInfo);
            n = string4.indexOf("name=\"", n2);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new ThemeStyleInfo[vector.size()]);
    }

    public String[] getBaseMapNames(String string) throws Exception {
        String string2 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <list_maps data_source=\"" + string + "\"/>" + "</non_map_request>";
        this.sendXMLRequest(string2);
        String string3 = this.getXMLResponse();
        if (string3.indexOf("succeed=\"true\"") < 0) {
            throw new Exception("cannot get basemap names for " + string);
        }
        Vector<String> vector = new Vector<String>(13);
        int n = string3.indexOf("name=\"");
        while (n > 0) {
            int n2 = string3.indexOf(34, 6 + n);
            if (n2 > 0) {
                vector.add(string3.substring(n + 6, n2));
            }
            n = string3.indexOf("name=\"", n2);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] getPermanentStyles(String string, String string2) throws Exception {
        if (!(string2 == null || STYLE_COLOR.equalsIgnoreCase(string2) || STYLE_MARKER.equalsIgnoreCase(string2) || STYLE_LINE.equalsIgnoreCase(string2) || STYLE_TEXT.equalsIgnoreCase(string2) || STYLE_AREA.equalsIgnoreCase(string2) || STYLE_ADVANCED.equalsIgnoreCase(string2))) {
            throw new Exception("invalid style type specified.");
        }
        string2 = string2 == null ? "" : " style_type=\"" + string2 + "\"";
        String string3 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>    <list_styles data_source=\"" + string + "\"" + string2 + " />" + "</non_map_request>";
        this.sendXMLRequest(string3);
        String string4 = this.getXMLResponse();
        if (string4.indexOf("succeed=\"true\"") < 0) {
            throw new Exception("cannot get style names for type " + string2 + " in " + string);
        }
        Vector<String> vector = new Vector<String>(13);
        int n = string4.indexOf("name=\"");
        while (n > 0) {
            int n2 = string4.indexOf(34, 6 + n);
            if (n2 > 0) {
                vector.add(string4.substring(n + 6, n2));
            }
            n = string4.indexOf("name=\"", n2);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean zoomIn(double d) throws Exception {
        if (this.mRequest.getCenter() != null && this.mbr == null) {
            this.setSize(this.getSize() / d);
        } else {
            double d2 = (this.mbr[0] + this.mbr[2]) / 2.0;
            double d3 = (this.mbr[1] + this.mbr[3]) / 2.0;
            double d4 = (this.mbr[3] - this.mbr[1]) / d;
            this.setCenterAndSize(d2, d3, d4);
        }
        return this.run();
    }

    public boolean zoomOut(double d) throws Exception {
        if (this.mRequest.getCenter() != null && this.mbr == null) {
            this.setSize(this.getSize() * d);
        } else {
            double d2 = (this.mbr[0] + this.mbr[2]) / 2.0;
            double d3 = (this.mbr[1] + this.mbr[3]) / 2.0;
            double d4 = (this.mbr[3] - this.mbr[1]) * d;
            this.setCenterAndSize(d2, d3, d4);
        }
        return this.run();
    }

    public boolean zoomOut(int n, int n2, double d) throws Exception {
        Point2D point2D = this.getUserPoint(n, n2);
        this.setCenter(point2D.getX(), point2D.getY());
        if (this.mbr != null) {
            this.setSize((this.mbr[3] - this.mbr[1]) * d);
        } else {
            this.setSize(this.getSize() * d);
        }
        return this.run();
    }

    public boolean zoomIn(int n, int n2, int n3, int n4) throws Exception {
        double d = (double)(n + n3) / 2.0;
        double d2 = (double)(n2 + n4) / 2.0;
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D point2D = null;
        Point2D.Double double_2 = new Point2D.Double();
        point2D = this.getUserPoint((int)d, (int)d2);
        this.setCenter(point2D.getX(), point2D.getY());
        ((Point2D)double_).setLocation(n, n2);
        this.mResponse.getAffineTransform().transform(double_, point2D);
        ((Point2D)double_).setLocation(n3, n4);
        this.mResponse.getAffineTransform().transform(double_, double_2);
        this.setSize(Math.abs(((Point2D)double_2).getY() - point2D.getY()));
        return this.run();
    }

    public boolean zoomIn(int n, int n2, double d) throws Exception {
        Point2D point2D = this.getUserPoint(n, n2);
        this.setCenter(point2D.getX(), point2D.getY());
        if (this.mbr != null) {
            this.setSize((this.mbr[3] - this.mbr[1]) / d);
        } else {
            double d2 = Math.abs(this.getSize() / d);
            if (d2 == 0.0) {
                System.err.println("Map request size will be set to zero!");
            }
            this.setSize(d2);
        }
        return this.run();
    }

    public boolean pan(int n, int n2) throws Exception {
        Point2D point2D = this.getUserPoint(n, n2);
        this.setCenter(point2D.getX(), point2D.getY());
        if (this.mbr != null) {
            this.setSize(this.mbr[3] - this.mbr[1]);
        }
        return this.run();
    }

    public Point2D getUserPoint(int n, int n2) {
        double[] dArray;
        Object object;
        Object object2;
        Point2D.Double double_ = new Point2D.Double(n, n2);
        Point2D.Double double_2 = new Point2D.Double();
        this.mResponse.getAffineTransform().transform(double_, double_2);
        if (this.mResponse.getRotation() != 0.0 && (object2 = MapViewer.rotatePoint(double_2, (Point2D)(object = new Point2D.Double(((dArray = this.mResponse.getMBR())[0] + dArray[2]) / 2.0, (dArray[1] + dArray[3]) / 2.0)), this.mResponse.getRotation() * -1.0)) != null) {
            double_2 = new Point2D.Double();
            double_2.setLocation((Point2D)object2);
        }
        if ((dArray = this.mResponse.getMapProjectionParams()) != null) {
            object = ProjAzEd.restore(dArray);
            object2 = new Proj.P2();
            ((ProjAzEd)object).inverse(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), (Proj.P2)object2);
            ((Point2D)double_2).setLocation(((Proj.P2)object2).x, ((Proj.P2)object2).y);
        }
        return double_2;
    }

    public Point2D getUserPoint(int n, int n2, String string, int n3) {
        if (this.mResponse == null) {
            return null;
        }
        int n4 = this.mResponse.getSRID();
        Point2D point2D = this.getUserPoint(n, n2);
        if (n3 > 0 && n4 > 0 && n4 != n3) {
            String string2 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + "  type=\"query_transform_srid\" >\n" + "  <query_transform_srid in_srid=\"" + n4 + "\" out_srid=\"" + n3 + "\">" + point2D.getX() + "," + point2D.getY() + "</query_transform_srid>\n" + "</info_request>\n";
            String[][] stringArray = null;
            try {
                stringArray = this.doQueryHelper(string2);
            }
            catch (Exception exception) {
                System.out.println("Error in getUserPoint: " + exception);
                return null;
            }
            if (stringArray == null) {
                System.out.println("Null result in getUserPoint.");
                return null;
            }
            point2D = new Point2D.Double(Double.parseDouble(stringArray[1][0]), Double.parseDouble(stringArray[1][1]));
        }
        return point2D;
    }

    public Point2D getUserPoint(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, int n3) {
        if (this.mResponse == null) {
            return null;
        }
        int n4 = this.mResponse.getSRID();
        Point2D point2D = this.getUserPoint(n, n2);
        if (n3 > 0 && n4 > 0 && n4 != n3) {
            String string7 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request host=\"" + string + "\" port=\"" + string2 + "\" " + "sid=\"" + string3 + "\" user=\"" + string4 + "\" password=\"" + string5 + "\" " + "mode=\"" + string6 + "\" format=\"strict\" " + "  type=\"query_transform_srid\" >\n" + "  <query_transform_srid in_srid=\"" + n4 + "\" out_srid=\"" + n3 + "\">" + point2D.getX() + "," + point2D.getY() + "</query_transform_srid>\n" + "</info_request>\n";
            String[][] stringArray = null;
            try {
                stringArray = this.doQueryHelper(string7);
            }
            catch (Exception exception) {
                System.out.println("Error in getUserPoint: " + exception);
                return null;
            }
            if (stringArray == null) {
                System.out.println("Null result in getUserPoint.");
                return null;
            }
            point2D = new Point2D.Double(Double.parseDouble(stringArray[1][0]), Double.parseDouble(stringArray[1][1]));
        }
        return point2D;
    }

    public Point2D getUserPoint(int n, int n2, String string, String string2) {
        if (this.mResponse == null) {
            return null;
        }
        int n3 = this.mResponse.getSRID();
        Point2D point2D = this.getUserPoint(n, n2);
        String string3 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + "  type=\"query_transform_srid\" >\n" + "  <query_transform_srid in_srid=\"" + n3 + "\">" + point2D.getX() + "," + point2D.getY() + "</query_transform_srid>\n" + "  <theme name=\"" + string2 + "\"/>\n" + "</info_request>\n";
        String[][] stringArray = null;
        try {
            stringArray = this.doQueryHelper(string3);
        }
        catch (Exception exception) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        point2D = new Point2D.Double(Double.parseDouble(stringArray[1][0]), Double.parseDouble(stringArray[1][1]));
        return point2D;
    }

    public String[][] doQuery(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        String string8 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request host=\"" + string + "\" port=\"" + string2 + "\" " + "sid=\"" + string3 + "\" user=\"" + string4 + "\" password=\"" + string5 + "\" " + "mode=\"" + string6 + "\" format=\"strict\" " + this.getWorkspaceAttributesForInfoRequest() + ">\n" + MapViewer.doXMLEscape(string7) + "\n</info_request>\n";
        return this.doQueryHelper(string8);
    }

    public String[][] doQuery(String string, String string2) throws Exception {
        String string3 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + this.getWorkspaceAttributesForInfoRequest() + ">\n" + MapViewer.doXMLEscape(string2) + "\n</info_request>\n";
        return this.doQueryHelper(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[][] doQueryHelper(String string) throws Exception {
        this.connect();
        if (this.mHttp == null) {
            throw new Exception(CMBundle.getMsg("MAPVIEWER-03006"));
        }
        OutputStream outputStream = this.mHttp.getOutputStream();
        outputStream.write(REQ_PARAM.getBytes());
        outputStream.write(string.getBytes("UTF-8"));
        outputStream.flush();
        outputStream.close();
        InputStream inputStream = this.mHttp.getInputStream();
        String[][] stringArray = null;
        try {
            stringArray = this.processInfoResponse(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        finally {
            inputStream.close();
        }
        return stringArray;
    }

    public String[][] doQueryInMapWindow(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, boolean bl) throws Exception {
        int n2 = string7.toUpperCase().indexOf("WHERE");
        String string9 = null;
        string9 = n2 < 0 ? string7 + " WHERE " + this.getSpatialFilter(string8, n, bl) : string7 + " AND " + this.getSpatialFilter(string8, n, bl);
        return this.doQuery(string, string2, string3, string4, string5, string6, string9);
    }

    public String[][] doQueryInMapWindow(String string, String string2, String string3, int n, boolean bl) throws Exception {
        int n2 = string2.toUpperCase().indexOf("WHERE");
        String string4 = null;
        string4 = n2 < 0 ? string2 + " WHERE " + this.getSpatialFilter(string3, n, bl) : string2 + " AND " + this.getSpatialFilter(string3, n, bl);
        return this.doQuery(string, string4);
    }

    public String getSpatialFilter(String string, int n, boolean bl) {
        return this.getSpatialFilter(string, n, this.mbr[0], this.mbr[1], this.mbr[2], this.mbr[3], bl);
    }

    public String getSpatialFilter(String string, int n, double d, double d2, double d3, double d4, boolean bl) {
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl3 = bl2 = n > 0 && n < 32768;
        if (!bl && bl2) {
            stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", ");
            stringBuffer.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            stringBuffer.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + "))" + ", " + n + " ), " + "'querytype=WINDOW') = 'TRUE'");
            return stringBuffer.toString();
        }
        stringBuffer.append("MDSYS.SDO_FILTER(" + string + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + ")), " + "'querytype=WINDOW') = 'TRUE'");
        return stringBuffer.toString();
    }

    public String getWhereClauseForAnyInteract(String string, int n, double d, double d2, double d3, double d4, boolean bl) {
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer(256);
        boolean bl3 = bl2 = n > 0 && n < 32768;
        if (!bl && bl2) {
            stringBuffer.append("MDSYS.SDO_RELATE(" + string + ", ");
            stringBuffer.append("MDSYS.SDO_CS.VIEWPORT_TRANSFORM(");
            stringBuffer.append("MDSYS.SDO_GEOMETRY( 2003, 0, NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + "))" + ", " + n + " ), " + "'mask=ANYINTERACT querytype=WINDOW') = 'TRUE'");
            return stringBuffer.toString();
        }
        stringBuffer.append("MDSYS.SDO_RELATE(" + string + ", " + "MDSYS.SDO_GEOMETRY(2003, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + d + "," + d2 + "," + d3 + "," + d4 + ")), " + "'mask=ANYINTERACT querytype=WINDOW') = 'TRUE'");
        return stringBuffer.toString();
    }

    public String getWhereClauseForAnyInteract(String string, int n, double d, double d2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("MDSYS.SDO_RELATE(" + string + ", " + "MDSYS.SDO_GEOMETRY(2001, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", MDSYS.SDO_POINT_TYPE(" + d + "," + d2 + ",NULL), NULL, NULL), " + "'mask=ANYINTERACT querytype=WINDOW') = 'TRUE'");
        return stringBuffer.toString();
    }

    public String getWhereClauseForNN(String string, int n, double d, double d2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("MDSYS.SDO_NN(" + string + ", " + "MDSYS.SDO_GEOMETRY(2001, ");
        if (n == 0) {
            stringBuffer.append("NULL");
        } else {
            stringBuffer.append(n);
        }
        stringBuffer.append(", MDSYS.SDO_POINT_TYPE(" + d + "," + d2 + ",NULL), NULL, NULL), " + "'sdo_batch_size=1') = 'TRUE' and ROWNUM < 2");
        return stringBuffer.toString();
    }

    public String[][] queryWithinRadius(String string, String string2, String[] stringArray, String string3, double d, double d2, double d3, boolean bl) throws Exception {
        Object object;
        double d4 = d;
        double d5 = d2;
        if (bl) {
            object = this.getUserPoint((int)d, (int)d2, string, string2);
            d4 = ((Point2D)object).getX();
            d5 = ((Point2D)object).getY();
        }
        object = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            object = (String)object + "," + stringArray[i];
        }
        object = MapViewer.doXMLEscape((String)object);
        string3 = string3 != null && string3.length() > 0 ? "extra_condition=\"" + MapViewer.doXMLEscape(string3) + "\"" : "";
        String string4 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + "              type=\"query_within_radius\" " + this.getWorkspaceAttributesForInfoRequest() + ">\n" + "  <query_within_radius radius=\"" + d3 + "\">" + d4 + "," + d5 + "</query_within_radius>\n" + "  <theme name=\"" + string2 + "\" attr_columns=\"" + (String)object + "\" " + string3 + " />\n" + "</info_request>\n";
        return this.doQueryHelper(string4);
    }

    public String[][] queryAtPoint(String string, String string2, String[] stringArray, double d, double d2, String string3, boolean bl) throws Exception {
        Object object;
        double d3 = d;
        double d4 = d2;
        if (bl) {
            object = this.getUserPoint((int)d, (int)d2, string, string2);
            d3 = ((Point2D)object).getX();
            d4 = ((Point2D)object).getY();
        }
        object = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            object = (String)object + "," + stringArray[i];
        }
        object = MapViewer.doXMLEscape((String)object);
        string3 = string3 != null && string3.length() > 0 ? "extra_condition=\"" + MapViewer.doXMLEscape(string3) + "\"" : "";
        String string4 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + "              type=\"query_at_point\" " + this.getWorkspaceAttributesForInfoRequest() + ">\n" + "  <query_at_point>" + d3 + "," + d4 + "</query_at_point>\n" + "  <theme name=\"" + string2 + "\" attr_columns=\"" + (String)object + "\" " + string3 + " />\n" + "</info_request>\n";
        return this.doQueryHelper(string4);
    }

    public String[][] queryWithinRectangle(String string, String string2, String[] stringArray, double d, double d2, double d3, double d4, String string3, boolean bl) throws Exception {
        Object object;
        double d5 = d;
        double d6 = d2;
        double d7 = d + d3;
        double d8 = d2 + d4;
        if (bl) {
            object = this.getUserPoint((int)d5, (int)d6, string, string2);
            d5 = ((Point2D)object).getX();
            d6 = ((Point2D)object).getY();
            object = this.getUserPoint((int)d7, (int)d8, string, string2);
            d7 = ((Point2D)object).getX();
            d8 = ((Point2D)object).getY();
        }
        object = d5 + "," + d6 + "," + d7 + "," + d8;
        String string4 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string4 = string4 + "," + stringArray[i];
        }
        string4 = MapViewer.doXMLEscape(string4);
        string3 = string3 != null && string3.length() > 0 ? "extra_condition=\"" + MapViewer.doXMLEscape(string3) + "\"" : "";
        String string5 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + "              type=\"query_within_rectangle\" " + this.getWorkspaceAttributesForInfoRequest() + ">\n" + "  <query_within_rectangle>" + (String)object + "</query_within_rectangle>\n" + "  <theme name=\"" + string2 + "\" attr_columns=\"" + string4 + "\" " + string3 + " />\n" + "</info_request>\n";
        return this.doQueryHelper(string5);
    }

    public String[][] queryWithinArea(String string, String string2, String[] stringArray, double[] dArray, String string3, boolean bl) throws Exception {
        double[] dArray2 = dArray;
        if (bl) {
            dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length / 2; ++i) {
                Point2D point2D = this.getUserPoint((int)dArray[i * 2], (int)dArray[i * 2 + 1], string, string2);
                dArray2[i * 2] = point2D.getX();
                dArray2[i * 2 + 1] = point2D.getY();
            }
        }
        StringBuffer stringBuffer = new StringBuffer("" + dArray2[0] + "," + dArray2[1]);
        for (int i = 1; i < dArray2.length / 2; ++i) {
            stringBuffer.append("," + dArray2[i * 2] + "," + dArray2[i * 2 + 1]);
        }
        String string4 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string4 = string4 + "," + stringArray[i];
        }
        string4 = MapViewer.doXMLEscape(string4);
        string3 = string3 != null && string3.length() > 0 ? "extra_condition=\"" + MapViewer.doXMLEscape(string3) + "\"" : "";
        String string5 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + "              type=\"query_within_area\" " + this.getWorkspaceAttributesForInfoRequest() + ">\n" + "  <query_within_area>" + stringBuffer.toString() + "</query_within_area>\n" + "  <theme name=\"" + string2 + "\" attr_columns=\"" + string4 + "\" " + string3 + " />\n" + "</info_request>\n";
        return this.doQueryHelper(string5);
    }

    public String[][] queryNN(String string, String string2, String[] stringArray, int n, double d, double d2, String string3, boolean bl, String string4) throws Exception {
        Object object;
        double d3 = d;
        double d4 = d2;
        if (bl) {
            object = this.getUserPoint((int)d, (int)d2, string, string2);
            d3 = ((Point2D)object).getX();
            d4 = ((Point2D)object).getY();
        }
        if (n <= 0) {
            n = 1;
        }
        object = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            object = (String)object + "," + stringArray[i];
        }
        object = MapViewer.doXMLEscape((String)object);
        string3 = string3 != null && string3.length() > 0 ? "extra_condition=\"" + MapViewer.doXMLEscape(string3) + "\"" : "";
        string4 = string4 != null && string4.length() > 0 ? "spatial_index=\"" + string4 + "\"" : "";
        String string5 = "<?xml version=\"1.0\" standalone=\"yes\" ?><info_request datasource=\"" + string + "\" format=\"strict\" " + "              type=\"query_nn\" " + this.getWorkspaceAttributesForInfoRequest() + ">\n" + "  <query_nn k=\"" + n + "\" " + string4 + ">" + d3 + "," + d4 + "</query_nn>\n" + "  <theme name=\"" + string2 + "\" attr_columns=\"" + (String)object + "\" " + string3 + " />\n" + "</info_request>\n";
        return this.doQueryHelper(string5);
    }

    public String[][] identify(String string, String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray, String string8, int n, int n2, int n3, int n4, int n5, boolean bl) throws Exception {
        Point2D point2D = this.getUserPoint(n2, n3, string, string2, string3, string4, string5, string6, n);
        double d = point2D.getX();
        double d2 = point2D.getY();
        point2D = this.getUserPoint(n4, n5, string, string2, string3, string4, string5, string6, n);
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i] + ", ");
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        stringBuffer.append(" FROM " + string7 + " WHERE ");
        stringBuffer.append(this.getWhereClauseForAnyInteract(string8, n, d, d2, d3, d4, bl));
        return this.doQuery(string, string2, string3, string4, string5, string6, stringBuffer.toString());
    }

    public String[][] identify(String string, String string2, String[] stringArray, String string3, int n, int n2, int n3, int n4, int n5, boolean bl) throws Exception {
        Point2D point2D = this.getUserPoint(n2, n3, string, n);
        double d = point2D.getX();
        double d2 = point2D.getY();
        point2D = this.getUserPoint(n4, n5, string, n);
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i] + ", ");
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        stringBuffer.append(" FROM " + string2 + " WHERE ");
        stringBuffer.append(this.getWhereClauseForAnyInteract(string3, n, d, d2, d3, d4, bl));
        return this.doQuery(string, stringBuffer.toString());
    }

    public String[][] identify(String string, String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray, String string8, int n, int n2, int n3) throws Exception {
        Point2D point2D = this.getUserPoint(n2, n3, string, string2, string3, string4, string5, string6, n);
        double d = point2D.getX();
        double d2 = point2D.getY();
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i] + ", ");
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        stringBuffer.append(" FROM " + string7 + " WHERE ");
        stringBuffer.append(this.getWhereClauseForNN(string8, n, d, d2));
        return this.doQuery(string, string2, string3, string4, string5, "mode", stringBuffer.toString());
    }

    public String[][] identify(String string, String string2, String[] stringArray, String string3, int n, int n2, int n3) throws Exception {
        Point2D point2D = this.getUserPoint(n2, n3, string, n);
        double d = point2D.getX();
        double d2 = point2D.getY();
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("SELECT ");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i] + ", ");
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        stringBuffer.append(" FROM " + string2 + " WHERE ");
        stringBuffer.append(this.getWhereClauseForNN(string3, n, d, d2));
        return this.doQuery(string, stringBuffer.toString());
    }

    public String getMapRequestString() {
        this.xmlreq = this.mRequest.toXMLString();
        return this.xmlreq;
    }

    public String getMapResponseString() {
        return this.xmlres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run() throws Exception {
        this.xmlres = null;
        this.sendXMLRequest(this.mRequest.toXMLString());
        this.mImage = null;
        InputStream inputStream = this.mHttp.getInputStream();
        try {
            switch (this.mRequest.getImageFormat()) {
                case 0: 
                case 1: 
                case 9: {
                    this.processRawResponse(inputStream);
                    return true;
                }
                case 3: 
                case 13: 
                case 21: 
                case 25: 
                case 51: {
                    this.processImgURL(inputStream);
                    return true;
                }
            }
            return true;
        }
        finally {
            inputStream.close();
        }
    }

    public void sendXMLRequest(String string) throws Exception {
        this.connect();
        if (this.mHttp == null) {
            throw new Exception(CMBundle.getMsg("MAPVIEWER-03006"));
        }
        OutputStream outputStream = this.mHttp.getOutputStream();
        outputStream.write(REQ_PARAM.getBytes());
        outputStream.write(string.getBytes("UTF8"));
        outputStream.flush();
        outputStream.close();
        outputStream = null;
    }

    public String getXMLResponse() throws Exception {
        InputStream inputStream = this.mHttp.getInputStream();
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        return string;
    }

    public int getNumLiveFeatures() {
        return this.mResponse != null ? this.mResponse.getLiveFeatures().length : 0;
    }

    public boolean hasLiveFeatures() {
        return this.mResponse != null && this.mResponse.getLiveFeatures().length > 0;
    }

    public LiveFeature[] getLiveFeatures() {
        if (this.mResponse == null || this.mResponse.getLiveFeatures() == null || this.mResponse.getLiveFeatures().length == 0) {
            return null;
        }
        return this.mResponse.getLiveFeatures();
    }

    public String[][] getLiveFeatureAttrs(int n, int n2, int n3) {
        LiveFeature[] liveFeatureArray = this.findLiveFeatures(n, n2, n3);
        if (liveFeatureArray == null) {
            return new String[0][0];
        }
        String[][] stringArray = new String[liveFeatureArray.length][];
        for (int i = 0; i < liveFeatureArray.length; ++i) {
            stringArray[i] = liveFeatureArray[i].getAttrs();
        }
        return stringArray;
    }

    public void drawLiveFeatures(Graphics2D graphics2D, Color color, Color color2, double d, double d2) {
        LiveFeature[] liveFeatureArray = this.mResponse != null ? this.mResponse.getLiveFeatures() : new LiveFeature[]{};
        for (int i = 0; i < liveFeatureArray.length; ++i) {
            LiveFeature liveFeature = liveFeatureArray[i];
            this.drawLiveFeature(liveFeature, graphics2D, color, color2, d, d2);
        }
    }

    public void highlightFeatures(int n, int n2, int n3, int n4, Graphics2D graphics2D, Color color, Color color2, double d, double d2) {
        LiveFeature[] liveFeatureArray = this.mResponse != null ? this.mResponse.getLiveFeatures() : new LiveFeature[]{};
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, n3, n4);
        for (int i = 0; i < liveFeatureArray.length; ++i) {
            LiveFeature liveFeature = liveFeatureArray[i];
            if (!this.intersects(liveFeature, double_)) continue;
            this.drawLiveFeature(liveFeature, graphics2D, color, color2, d, d2);
        }
    }

    public void drawLiveFeature(LiveFeature liveFeature, Graphics2D graphics2D, Color color, Color color2, double d, double d2) {
        Shape shape = liveFeature.getShape();
        if (shape == null) {
            double d3 = liveFeature.getCenterX();
            double d4 = liveFeature.getCenterY();
            if (color2 != null) {
                graphics2D.setPaint(color2);
                graphics2D.fillOval((int)(d3 - d), (int)(d4 - d), (int)(d * 2.0), (int)(d * 2.0));
            }
            if (color != null) {
                graphics2D.setStroke(new BasicStroke((float)d2));
                graphics2D.setColor(color);
                graphics2D.drawOval((int)(d3 - d), (int)(d4 - d), (int)(d * 2.0), (int)(d * 2.0));
            }
        } else {
            if (color2 != null) {
                graphics2D.setPaint(color2);
                graphics2D.fill(shape);
            }
            if (color != null) {
                graphics2D.setStroke(new BasicStroke((float)d2));
                graphics2D.setColor(color);
                graphics2D.draw(shape);
            }
        }
    }

    public boolean intersects(LiveFeature liveFeature, Rectangle2D rectangle2D) {
        Shape shape = liveFeature.getShape();
        return shape != null ? shape.intersects(rectangle2D) : rectangle2D.contains(liveFeature.getCenterX(), liveFeature.getCenterY());
    }

    public LiveFeature[] findLiveFeatures(int n, int n2, int n3) {
        LiveFeature[] liveFeatureArray = this.mResponse.getLiveFeatures();
        if (liveFeatureArray == null || liveFeatureArray.length == 0) {
            return null;
        }
        Vector<LiveFeature> vector = new Vector<LiveFeature>();
        for (int i = 0; i < liveFeatureArray.length; ++i) {
            Rectangle2D rectangle2D;
            LiveFeature liveFeature = liveFeatureArray[i];
            Shape shape = liveFeature.getShape();
            if (shape != null) {
                if (liveFeature.getGeomType() == 2 || liveFeature.getGeomType() == 6) {
                    rectangle2D = shape.getBounds2D();
                    double d = rectangle2D.getWidth();
                    double d2 = rectangle2D.getHeight();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(n - n3, n2 - n3, 2 * n3, 2 * n3);
                    if (d == 0.0 && d2 == 0.0 && double_.contains(rectangle2D.getCenterX(), rectangle2D.getCenterY())) {
                        vector.add(liveFeature);
                        continue;
                    }
                    if (!double_.contains(rectangle2D) && !ShapeUtil.intersects(shape, double_)) continue;
                    vector.add(liveFeature);
                    continue;
                }
                if (!shape.contains(n, n2) && !shape.intersects(n - n3, n2 - n3, 2 * n3, 2 * n3)) continue;
                vector.add(liveFeature);
                continue;
            }
            rectangle2D = new Rectangle2D.Double(n - n3, n2 - n3, 2 * n3, 2 * n3);
            if (!rectangle2D.contains(liveFeature.getCenterX(), liveFeature.getCenterY())) continue;
            vector.add(liveFeature);
        }
        return vector.toArray(new LiveFeature[vector.size()]);
    }

    private void processRawResponse(InputStream inputStream) throws Exception {
        this.mbr = null;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.mResponse = (MapResponse)objectInputStream.readObject();
        this.mbr = this.mResponse.getMBR();
        if (this.mImage != null) {
            MapResponse.removeImageFromTracker(this.mImage);
            this.mImage.flush();
        }
        this.mImage = this.mResponse.getImage();
    }

    private void processImgURL(InputStream inputStream) throws Exception {
        String string = "error_code=\"SUCCESS\"";
        String string2 = "url=\"";
        String string3 = "\" />";
        String string4 = "<coordinates>";
        String string5 = "</coordinates>";
        String string6 = "matrix=\"";
        String string7 = "\" />";
        String string8 = "<themes>";
        String string9 = "</themes>";
        String string10 = "<theme name=\"";
        String string11 = "\" />";
        String string12 = "<rotation angle=\"";
        String string13 = "\" />";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        String string14 = null;
        String string15 = null;
        boolean bl = false;
        StringTokenizer stringTokenizer = null;
        int n13 = -1;
        int n14 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while ((n14 = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n14);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        this.xmlres = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        byteArrayOutputStream = null;
        String string16 = "xml_response=" + this.xmlres;
        this.mbr = null;
        if (string16.indexOf(string) == -1) {
            System.err.println("cannot find error code");
            System.err.println("Server response is:\n" + this.xmlres);
            bl = true;
        } else {
            n = string16.indexOf(string2);
            if (n == -1) {
                System.err.println(CMBundle.getMsg("MAPVIEWER-03007"));
                bl = true;
            } else {
                n2 = string16.indexOf(string3, n += string2.length());
                if (n2 != -1) {
                    string15 = new String(string16.substring(n, n2));
                    n3 = string16.indexOf(string4);
                    if (n3 != -1) {
                        n4 = string16.indexOf(string5, n3 += string4.length());
                        if (n4 != -1) {
                            string14 = string16.substring(n3, n4);
                            stringTokenizer = new StringTokenizer(string14, ", \n\t\r\f");
                            try {
                                double d = Double.valueOf(stringTokenizer.nextToken());
                                double d2 = Double.valueOf(stringTokenizer.nextToken());
                                double d3 = Double.valueOf(stringTokenizer.nextToken());
                                double d4 = Double.valueOf(stringTokenizer.nextToken());
                                if (this.mbr == null) {
                                    this.mbr = new double[4];
                                }
                                this.mbr[0] = d;
                                this.mbr[1] = d2;
                                this.mbr[2] = d3;
                                this.mbr[3] = d4;
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        bl = true;
                    }
                }
                if ((n5 = string16.indexOf(string6)) == -1) {
                    bl = true;
                } else {
                    n6 = string16.indexOf(string7, n5 += string6.length());
                    if (n6 != -1) {
                        Object object;
                        stringTokenizer = new StringTokenizer(string16.substring(n5, n6), ", \n\t\r\f");
                        double[] dArray = new double[6];
                        try {
                            dArray[0] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray[1] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray[2] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray[3] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray[4] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray[5] = Double.parseDouble(stringTokenizer.nextToken());
                            object = new AffineTransform(dArray);
                            this.mResponse = new MapResponse();
                            this.mResponse.setMbr(this.mbr);
                            this.mResponse.setAffineTransform((AffineTransform)object);
                            if (stringTokenizer.hasMoreTokens()) {
                                double[] dArray2 = new double[4];
                                try {
                                    dArray2[0] = Double.parseDouble(stringTokenizer.nextToken());
                                    dArray2[1] = Double.parseDouble(stringTokenizer.nextToken());
                                    dArray2[2] = Double.parseDouble(stringTokenizer.nextToken());
                                    dArray2[3] = Double.parseDouble(stringTokenizer.nextToken());
                                    this.mResponse.setMapProjectionParams(dArray2);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace(System.err);
                                }
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                        n7 = string16.indexOf(string8);
                        if (n7 > -1 && this.mResponse != null && (n8 = string16.indexOf(string9, n7 += string8.length())) > -1) {
                            n9 = string16.indexOf(string10, n7);
                            while (n9 != -1 && (n10 = string16.indexOf(string11, n9 += string10.length())) > -1) {
                                arrayList.add(string16.substring(n9, n10));
                                n9 = string16.indexOf(string10, n10);
                            }
                            if (arrayList.size() > 0) {
                                this.mResponse.setThemeNames(arrayList.toArray(new String[arrayList.size()]));
                            }
                        }
                        if ((n11 = string16.indexOf(string12)) > -1 && this.mResponse != null && (n12 = string16.indexOf(string13, n11 += string12.length())) > -1) {
                            object = string16.substring(n11, n12);
                            try {
                                this.mResponse.setRotation(Double.parseDouble((String)object));
                            }
                            catch (Exception exception) {
                                this.mResponse.setRotation(0.0);
                            }
                        }
                    }
                }
            }
        }
        if (bl) {
            throw new Exception(CMBundle.getMsg("MAPVIEWER-03001"));
        }
        this.mImageURL = string15;
    }

    private void processSVGStream(InputStream inputStream) throws Exception {
        String string = "<coordinates>";
        String string2 = "</coordinates>";
        String string3 = "matrix=\"";
        String string4 = "\" />";
        String string5 = "<themes>";
        String string6 = "</themes>";
        String string7 = "<theme name=\"";
        String string8 = "\" />";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        String string9 = null;
        StringTokenizer stringTokenizer = null;
        int n9 = -1;
        boolean bl = false;
        int n10 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while ((n10 = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n10);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        String string10 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        byteArrayOutputStream = null;
        n = string10.indexOf(string);
        if (n != -1) {
            n2 = string10.indexOf(string2, n += string.length());
            if (n2 != -1) {
                string9 = string10.substring(n, n2);
                stringTokenizer = new StringTokenizer(string9, ", \n\t\r\f");
                try {
                    double d = Double.valueOf(stringTokenizer.nextToken());
                    double d2 = Double.valueOf(stringTokenizer.nextToken());
                    double d3 = Double.valueOf(stringTokenizer.nextToken());
                    double d4 = Double.valueOf(stringTokenizer.nextToken());
                    if (this.mbr == null) {
                        this.mbr = new double[4];
                    }
                    this.mbr[0] = d;
                    this.mbr[1] = d2;
                    this.mbr[2] = d3;
                    this.mbr[3] = d4;
                }
                catch (Exception exception) {}
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        n3 = string10.indexOf(string3);
        if (n3 == -1) {
            bl = true;
        } else {
            n4 = string10.indexOf(string4, n3 += string3.length());
            if (n4 != -1) {
                stringTokenizer = new StringTokenizer(string10.substring(n3, n4), ", \n\t\r\f");
                double[] dArray = new double[6];
                try {
                    dArray[0] = Double.parseDouble(stringTokenizer.nextToken());
                    dArray[1] = Double.parseDouble(stringTokenizer.nextToken());
                    dArray[2] = Double.parseDouble(stringTokenizer.nextToken());
                    dArray[3] = Double.parseDouble(stringTokenizer.nextToken());
                    dArray[4] = Double.parseDouble(stringTokenizer.nextToken());
                    dArray[5] = Double.parseDouble(stringTokenizer.nextToken());
                    AffineTransform affineTransform = new AffineTransform(dArray);
                    this.mResponse = new MapResponse();
                    this.mResponse.setMbr(this.mbr);
                    this.mResponse.setAffineTransform(affineTransform);
                    if (stringTokenizer.hasMoreTokens()) {
                        double[] dArray2 = new double[4];
                        try {
                            dArray2[0] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray2[1] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray2[2] = Double.parseDouble(stringTokenizer.nextToken());
                            dArray2[3] = Double.parseDouble(stringTokenizer.nextToken());
                            this.mResponse.setMapProjectionParams(dArray2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                n5 = string10.indexOf(string5);
                if (n5 > -1 && this.mResponse != null && (n6 = string10.indexOf(string6, n5 += string5.length())) > -1) {
                    n7 = string10.indexOf(string7, n5);
                    while (n7 != -1 && (n8 = string10.indexOf(string8, n7 += string7.length())) > -1) {
                        arrayList.add(string10.substring(n7, n8));
                        n7 = string10.indexOf(string7, n8);
                    }
                    if (arrayList.size() > 0) {
                        this.mResponse.setThemeNames(arrayList.toArray(new String[arrayList.size()]));
                    }
                }
            }
        }
        int n11 = string10.indexOf("<g ");
        this.svgStream = n11 >= 0 ? new SVGFragment(string10.substring(string10.indexOf("<g "))) : new SVGFragment(null);
        byteArrayOutputStream = null;
    }

    String[][] processInfoResponse(InputStream inputStream) throws IOException {
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = null;
        int n2 = -1;
        while ((n2 = string.indexOf("<ROW num=")) > 0) {
            int n3 = string.indexOf(">", n2 + 4);
            n2 = n3 + 1;
            n3 = string.indexOf("</ROW>", n2);
            String string2 = string.substring(n2, n3);
            if (vector.size() == 0) {
                stringArray = this.extractColumnNames(string2);
                vector.add(stringArray);
            }
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = "<" + stringArray[i] + ">";
                String string4 = "</" + stringArray[i] + ">";
                int n4 = string2.indexOf(string3);
                int n5 = string2.indexOf(string4);
                stringArray2[i] = string2.substring(n4 + string3.length(), n5);
            }
            vector.add(stringArray2);
            string = string.substring(n3 + 6, string.length());
        }
        String[][] stringArray3 = new String[vector.size()][];
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = (String[])vector.get(i);
        }
        return stringArray3;
    }

    private String[] extractColumnNames(String string) {
        Vector<String> vector = new Vector<String>(10);
        int n = string.indexOf("<");
        while (n >= 0) {
            int n2 = string.indexOf(">", n + 1);
            String string2 = string.substring(n + 1, n2);
            vector.add(string2);
            String string3 = "</" + string2 + ">";
            n2 = string.indexOf(string3);
            n = string.indexOf("<", n2 + string3.length());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String[] listAllDynamicStyles() {
        return this.mRequest.listAllDynamicStyles();
    }

    public void removeAllDynamicStyles() throws Exception {
        this.mRequest.removeAllDynamicStyles();
    }

    public void deleteStyle(String string) throws Exception {
        this.mRequest.removeDynamicStyle(string);
    }

    public void addImageMarkerFromURL(String string, String string2) throws Exception {
        this.addImageMarkerStyleFromURL(string2, string);
    }

    public void addImageMarkerStyleFromURL(String string, String string2) throws Exception {
        String string3 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg>\n" + STY_APPEND + "    <image_marker url=\"" + XMLUtil.replaceXMLEntities(string2) + "\"/>\n" + STY_APPEND + "    <g class=\"marker\" />\n" + STY_APPEND + "  </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string3);
    }

    public void addImageMarkerStyleFromURL(String string, String string2, int n, int n2, String string3, int n3, String string4, String string5, String string6) throws Exception {
        if (string4 == null) {
            string4 = "PLAIN";
        }
        if (string5 == null) {
            string5 = "PLAIN";
        }
        String string7 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg>\n" + STY_APPEND + "    <image_marker url=\"" + XMLUtil.replaceXMLEntities(string2) + "\"/>\n" + STY_APPEND + "    <g class=\"marker\"  style=\"width:" + n + ";height:" + n2 + ";font-family:" + XMLUtil.replaceXMLEntities(string3) + ";font-size:" + n3 + "pt;fill:" + string6 + ";font-style:" + XMLUtil.replaceXMLEntities(string4) + ";font-weight:" + XMLUtil.replaceXMLEntities(string5) + "\" />\n" + STY_APPEND + "  </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string7);
    }

    public void addImageAreaFromURL(String string, String string2) throws Exception {
        this.addImageAreaStyleFromURL(string2, string);
    }

    public void addImageAreaStyleFromURL(String string, String string2) throws Exception {
        String string3 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg>\n" + STY_APPEND + "    <g class=\"area\"/>\n" + STY_APPEND + "    <image_area url=\"" + XMLUtil.replaceXMLEntities(string2) + "\"/>\n" + STY_APPEND + "  </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string3);
    }

    public void addImageAreaStyleFromURL(String string, String string2, String string3, float f, int n) throws Exception {
        if (string3 == null) {
            this.addImageAreaStyleFromURL(string, string2);
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        string3 = "stroke:" + XMLUtil.replaceXMLEntities(string3) + ";stroke-width:" + f + ";stroke-opacity:" + n;
        String string4 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg>\n" + STY_APPEND + "    <g class=\"area\" style=\"" + XMLUtil.replaceXMLEntities(string3) + "\" />\n" + STY_APPEND + "    <image_area url=\"" + XMLUtil.replaceXMLEntities(string2) + "\"/>\n" + STY_APPEND + "  </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string4);
    }

    public void addImageAreaStyleFromURL(String string, String string2, String string3) throws Exception {
        if (string3 == null) {
            this.addImageAreaStyleFromURL(string, string2);
            return;
        }
        String string4 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg>\n" + STY_APPEND + "    <g class=\"area\" style=\"line-style:" + XMLUtil.replaceXMLEntities(string3) + "\" />\n" + STY_APPEND + "    <image_area url=\"" + XMLUtil.replaceXMLEntities(string2) + "\"/>\n" + STY_APPEND + "  </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string4);
    }

    public void addColorStyle(String string, String string2, String string3, int n, int n2) throws Exception {
        String string4 = n >= 0 && n <= 255 ? "stroke-opacity:" + n + ";" : "";
        String string5 = n2 >= 0 && n2 <= 255 ? "fill-opacity:" + n2 : "";
        string2 = string2 != null && string2.length() > 0 ? "stroke:" + string2 + ";" : "";
        string3 = string3 != null && string3.length() > 0 ? "fill:" + string3 + ";" : "";
        String string6 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg width=\"1in\" height=\"1in\" >\n" + STY_APPEND + "    <g class=\"color\" style=\"" + XMLUtil.replaceXMLEntities(string2) + string4 + XMLUtil.replaceXMLEntities(string3) + string5 + "\" >\n" + STY_APPEND + "      <rect width=\"50\" height=\"50\"/>\n" + STY_APPEND + "    </g>\n" + STY_APPEND + "  </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string6);
    }

    public void addColorStyle(String string, String string2, String string3, int n, int n2, String string4) throws Exception {
        String string5 = n >= 0 && n <= 255 ? "stroke-opacity:" + n + ";" : "";
        String string6 = n2 >= 0 && n2 <= 255 ? "fill-opacity:" + n2 : "";
        String string7 = string2 = string2 != null && string2.length() > 0 ? "stroke:" + string2 + ";" : "";
        if (string4 != null) {
            string2 = string2 + "stroke-width:" + string4 + ";";
        }
        string3 = string3 != null && string3.length() > 0 ? "fill:" + string3 + ";" : "";
        String string8 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg width=\"1in\" height=\"1in\" >\n" + STY_APPEND + "    <g class=\"color\" style=\"" + XMLUtil.replaceXMLEntities(string2) + string5 + XMLUtil.replaceXMLEntities(string3) + string6 + "\" >\n" + STY_APPEND + "      <rect width=\"50\" height=\"50\"/>\n" + STY_APPEND + "    </g>\n" + STY_APPEND + "  </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string8);
    }

    public void addMarkerStyle(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        String string8;
        String string9;
        switch (n) {
            case 1: {
                string9 = "polygon points=\"" + string6 + "\"";
                break;
            }
            case 2: {
                string9 = "polyline points=\"" + string6 + "\"";
                break;
            }
            case 3: {
                string9 = "circle r=\"" + string7 + "\"";
                break;
            }
            case 4: {
                string9 = "rect points=\"" + string6 + "\"";
                break;
            }
            default: {
                string9 = "";
            }
        }
        String string10 = "";
        if (string4 != null && string4.length() > 0) {
            string10 = "width=" + XMLUtil.replaceXMLEntities(string4) + ";";
        }
        if (string5 != null && string5.length() > 0) {
            string10 = string10 + "height=" + XMLUtil.replaceXMLEntities(string5);
        }
        String string11 = string2 == null || string2.length() == 0 ? "" : "stroke:" + XMLUtil.replaceXMLEntities(string2) + ";";
        String string12 = string8 = string3 == null || string3.length() == 0 ? "" : "fill:" + XMLUtil.replaceXMLEntities(string3) + ";";
        if (string11 == null && string8 == null) {
            throw new Exception("Both stroke and fill colors cannot be null.");
        }
        String string13 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <svg>\n" + STY_APPEND + "    <g class=\"marker\" style=\"" + string11 + string8 + string10 + "\">\n" + STY_APPEND + "      <" + string9 + " />\n" + STY_APPEND + "      </g>\n" + STY_APPEND + "    </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string13);
    }

    public void addCollectionBucketStyle(String string, String[] stringArray, String[] stringArray2, String[][] stringArray3) throws Exception {
        String string2 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <AdvancedStyle>\n" + STY_APPEND + "       <BucketStyle>\n" + STY_APPEND + "         <Buckets>\n";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + "             <CollectionBucket seq=\"" + i + "\"" + " label=\"" + XMLUtil.replaceXMLEntities(stringArray[i]) + "\" style=\"" + XMLUtil.replaceXMLEntities(stringArray2[i]) + "\">\n";
            for (int j = 0; j < stringArray3[i].length; ++j) {
                if (j > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + XMLUtil.replaceXMLEntities(stringArray3[i][j]);
            }
            string2 = string2 + "</CollectionBucket>\n";
        }
        string2 = string2 + "              </Buckets>\n           </BucketStyle>\n        </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string2);
    }

    public void addRangedBucketStyle(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws Exception {
        this.addRangedBucketStyle(string, stringArray, stringArray2, stringArray3, stringArray4, null);
    }

    public void addRangedBucketStyle(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String string2) throws Exception {
        String string3 = string2 != null ? " default_style=\"" + XMLUtil.replaceXMLEntities(string2) + "\" " : "";
        String string4 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <AdvancedStyle>\n" + STY_APPEND + "       <BucketStyle>\n" + STY_APPEND + "         <Buckets" + string3 + ">\n";
        for (int i = 0; i < stringArray2.length; ++i) {
            string4 = string4 + "             <RangedBucket seq=\"" + i + "\" label=\"" + XMLUtil.replaceXMLEntities(stringArray[i]) + "\"";
            if (stringArray2[i] != null) {
                string4 = string4 + " low=\"" + XMLUtil.replaceXMLEntities(stringArray2[i]) + "\"";
            }
            if (stringArray3[i] != null) {
                string4 = string4 + " high=\"" + XMLUtil.replaceXMLEntities(stringArray3[i]) + "\"";
            }
            string4 = string4 + " style=\"" + XMLUtil.replaceXMLEntities(stringArray4[i]) + "\" />\n";
        }
        string4 = string4 + "              </Buckets>\n           </BucketStyle>\n        </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string4);
    }

    public void addBucketStyle(String string, String string2, String string3, int n, String[] stringArray) throws Exception {
        this.addBucketStyle(string, string2, string3, n, stringArray, null);
    }

    public void addBucketStyle(String string, String string2, String string3, int n, String[] stringArray, String string4) throws Exception {
        String string5 = string4 != null ? " default_style=\"" + XMLUtil.replaceXMLEntities(string4) + "\" " : "";
        String string6 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <AdvancedStyle>\n" + STY_APPEND + "       <BucketStyle>\n" + STY_APPEND + "         <Buckets " + string5;
        string6 = string6 + "low=\"" + XMLUtil.replaceXMLEntities(string2) + "\" high=\"" + XMLUtil.replaceXMLEntities(string3) + "\" nbuckets=\"" + n + "\"";
        if (stringArray != null) {
            string6 = string6 + " styles=\"";
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string6 = string6 + ",";
                }
                string6 = string6 + XMLUtil.replaceXMLEntities(stringArray[i]);
            }
            string6 = string6 + "\"/>\n";
        }
        string6 = string6 + "           </BucketStyle>\n        </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string6);
    }

    public void addColorSchemeStyle(String string, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3) throws Exception {
        this.addColorSchemeStyle(string, string2, string3, stringArray, stringArray2, stringArray3, null);
    }

    public void addColorSchemeStyle(String string, String string2, String string3, String[] stringArray, String[] stringArray2, String[] stringArray3, String string4) throws Exception {
        String string5 = string4 != null ? " default_style=\"" + XMLUtil.replaceXMLEntities(string4) + "\" " : "";
        String string6 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <AdvancedStyle>\n" + STY_APPEND + "      <ColorSchemeStyle basecolor=\"" + XMLUtil.replaceXMLEntities(string2) + "\" strokecolor=\"" + XMLUtil.replaceXMLEntities(string3) + "\">\n" + STY_APPEND + "         <Buckets" + string5 + ">\n";
        for (int i = 0; i < stringArray.length; ++i) {
            string6 = string6 + "             <RangedBucket label=\"" + XMLUtil.replaceXMLEntities(stringArray[i]) + "\"";
            if (stringArray2[i] != null) {
                string6 = string6 + " low=\"" + XMLUtil.replaceXMLEntities(stringArray2[i]) + "\"";
            }
            if (stringArray3[i] != null) {
                string6 = string6 + " high=\"" + XMLUtil.replaceXMLEntities(stringArray3[i]) + "\"";
            }
            string6 = string6 + "/>\n";
        }
        string6 = string6 + "              </Buckets>\n           </ColorSchemeStyle>\n        </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string6);
    }

    public void addColorSchemeStyle(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        this.addColorSchemeStyle(string, string2, string3, string4, string5, n, null);
    }

    public void addColorSchemeStyle(String string, String string2, String string3, String string4, String string5, int n, String string6) throws Exception {
        String string7 = string6 != null ? " default_style=\"" + XMLUtil.replaceXMLEntities(string6) + "\" " : "";
        String string8 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <AdvancedStyle>\n" + STY_APPEND + "       <ColorSchemeStyle basecolor=\"" + XMLUtil.replaceXMLEntities(string2) + "\" strokecolor=\"" + string3 + "\">\n" + STY_APPEND + "         <Buckets low=\"" + XMLUtil.replaceXMLEntities(string4) + "\" high=\"" + XMLUtil.replaceXMLEntities(string5) + "\" nbuckets=\"" + n + "\" " + string7 + "/>\n";
        string8 = string8 + "           </ColorSchemeStyle>\n        </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string8);
    }

    public void addVariableMarkerStyle(String string, String[] stringArray, String string2, int n, int n2, String[] stringArray2, String[] stringArray3) throws Exception {
        this.addVariableMarkerStyle(string, stringArray, string2, n, n2, stringArray2, stringArray3, null);
    }

    public void addVariableMarkerStyle(String string, String[] stringArray, String string2, int n, int n2, String[] stringArray2, String[] stringArray3, String string3) throws Exception {
        String string4 = string3 != null ? " default_style=\"" + XMLUtil.replaceXMLEntities(string3) + "\" " : "";
        String string5 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <AdvancedStyle>\n" + STY_APPEND + "       <VariableMarkerStyle basemarker=\"" + XMLUtil.replaceXMLEntities(string2) + "\" startsize=\"" + n + "\"" + " increment=\"" + n2 + "\">\n" + STY_APPEND + "         <Buckets" + string4 + ">\n";
        for (int i = 0; i < stringArray.length; ++i) {
            string5 = string5 + "             <RangedBucket label=\"" + XMLUtil.replaceXMLEntities(stringArray[i]) + "\"";
            if (stringArray2[i] != null) {
                string5 = string5 + " low=\"" + XMLUtil.replaceXMLEntities(stringArray2[i]) + "\"";
            }
            if (stringArray3[i] != null) {
                string5 = string5 + " high=\"" + XMLUtil.replaceXMLEntities(stringArray3[i]) + "\"";
            }
            string5 = string5 + " />\n";
        }
        string5 = string5 + "              </Buckets>\n           </VariableMarkerStyle>\n        </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string5);
    }

    public void addPieChartStyle(String string, String string2, String[] stringArray, String[] stringArray2) throws Exception {
        String string3 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <AdvancedStyle>\n" + STY_APPEND + "       <PieChartStyle pieradius=\"" + XMLUtil.replaceXMLEntities(string2) + "\">\n";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + "          <PieSlice name=\"" + XMLUtil.replaceXMLEntities(stringArray[i]) + "\"";
            string3 = string3 + " color=\"" + XMLUtil.replaceXMLEntities(stringArray2[i]) + "\" />\n";
        }
        string3 = string3 + "           </PieChartStyle>\n        </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string3);
    }

    public void addTextStyle(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        String string7 = "font-style:" + XMLUtil.replaceXMLEntities(string2) + "; font-family:" + XMLUtil.replaceXMLEntities(string3) + "; font-size:" + XMLUtil.replaceXMLEntities(string4) + "; font-weight:" + XMLUtil.replaceXMLEntities(string5) + "; fill:" + XMLUtil.replaceXMLEntities(string6) + "\">\n";
        String string8 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <svg width=\"1in\" height=\"1in\" >\n" + STY_APPEND + "      <g class=\"text\" style=\"" + string7 + STY_APPEND + "      </g>\n" + STY_APPEND + "    </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string8);
    }

    public void addTextStyleWithHalo(String string, String string2, String string3, String string4, String string5, String string6, double d) {
        String string7 = "font-style:" + XMLUtil.replaceXMLEntities(string2) + "; font-family:" + XMLUtil.replaceXMLEntities(string3) + "; font-size:" + XMLUtil.replaceXMLEntities(string4) + "; font-weight:" + XMLUtil.replaceXMLEntities(string5) + "; fill:" + XMLUtil.replaceXMLEntities(string6) + "\">\n";
        String string8 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <svg width=\"1in\" height=\"1in\" >\n" + STY_APPEND + "      <g class=\"text\" float-width=\"" + d + "\" style=\"" + string7 + STY_APPEND + "      </g>\n" + STY_APPEND + "    </svg>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string8);
    }

    public void addLineStyle(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, boolean bl2, String string7, String string8, boolean bl3, String string9, String string10) throws Exception {
        this.addLineStyle(string, string2, string3, bl, string4, string5, string6, bl2, string7, string8, bl3, string9, string10, null, 0.0, 8);
    }

    public void addLineStyle(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, boolean bl2, String string7, String string8, boolean bl3, String string9, String string10, String string11, double d, int n) throws Exception {
        String string12 = "fill:" + XMLUtil.replaceXMLEntities(string2) + ";stroke-width:" + XMLUtil.replaceXMLEntities(string3);
        int n2 = n;
        if (n2 <= 0) {
            n2 = 8;
        }
        if (string11 != null && d >= 0.0 && d <= 1.0) {
            string12 = string12 + ";marker-name:" + XMLUtil.replaceXMLEntities(string11) + ";marker-position:" + d + ";marker-size:" + n2;
        }
        String string13 = "fill:" + XMLUtil.replaceXMLEntities(string4) + ";stroke-width:" + XMLUtil.replaceXMLEntities(string5);
        if (string6 != null) {
            string13 = string13 + "\" dash=\"" + XMLUtil.replaceXMLEntities(string6);
        }
        String string14 = null;
        if (bl2) {
            string14 = "fill:" + XMLUtil.replaceXMLEntities(string7) + ";stroke-width:" + XMLUtil.replaceXMLEntities(string8);
        }
        String string15 = null;
        String string16 = null;
        if (bl3) {
            string15 = "fill:" + XMLUtil.replaceXMLEntities(string9) + "\"";
            string16 = "dash:" + XMLUtil.replaceXMLEntities(string10);
        }
        String string17 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "    <svg width=\"1in\" height=\"1in\" >\n" + STY_APPEND + "      <g class=\"line\" style=\"" + string12 + "\">\n";
        if (bl) {
            string17 = string17 + "    <line class=\"base\" style=\"" + string13 + "\" />\n";
        }
        if (bl2) {
            string17 = string17 + "    <line class=\"parallel\" style=\"" + string14 + "\" />\n";
        }
        if (bl3) {
            string17 = string17 + "    <line class=\"hashmark\" style=\"" + string15 + " dash=\"" + string16 + "\" />\n";
        }
        string17 = string17 + "          </g>\n        </svg>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string17);
    }

    public void setMapLegend(String string, String string2, String string3, String string4, String string5, String[][][] stringArray) {
        this.mRequest.setMapLegend(string, string2, string3, string4, string5, null, stringArray);
    }

    public void setMapLegend(String string, String string2, String string3, String string4, String string5, String string6, String[][][] stringArray) {
        this.mRequest.setMapLegend(string, string2, string3, string4, string5, string6, stringArray);
    }

    public void setMapLegend(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6, String[][][] stringArray) {
        this.mRequest.setMapLegend(string, string2, string3, string4, string5, n, n2, string6, stringArray);
    }

    public void setMapLegend(String string, String string2, String string3, String string4, int n, int n2, String string5, String[][][] stringArray) {
        this.mRequest.setMapLegend(string, string2, string3, string4, n, n2, string5, stringArray);
    }

    public void setMapLegendFromThemes(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6, String[] stringArray) {
        this.mRequest.setMapLegendFromThemes(string, string2, string3, string4, string5, n, n2, string6, stringArray);
    }

    public void setMapLegendFromThemes(String string, String string2, String string3, String string4, int n, int n2, String string5, String[] stringArray) {
        this.mRequest.setMapLegendFromThemes(string, string2, string3, string4, n, n2, string5, stringArray);
    }

    public void deleteMapLegend() {
        this.mRequest.deleteMapLegend();
    }

    public void setMapRequestSRID(int n) {
        this.mRequest.setSRID(n);
    }

    public int getMapRequestSRID() {
        return this.mRequest.getSRID();
    }

    public void setScaleBar(ScaleBarDef scaleBarDef) {
        this.mRequest.setScaleBar(scaleBarDef);
    }

    public ScaleBarDef getScaleBar() {
        return this.mRequest.getScaleBar();
    }

    private static String[][] parseNamedAttrs(String string) {
        int n;
        String[][] stringArray;
        if (string == null || string.length() <= 0) {
            return new String[0][];
        }
        string = string.trim();
        int n2 = string.indexOf(61);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (n2 > 0) {
            stringArray = string.substring(0, n2);
            n = string.indexOf(34, n2 + 2);
            String string2 = string.substring(n2 + 2, n);
            arrayList.add(new String[]{stringArray, string2});
            string = string.substring(n + 1, string.length());
            string = string.trim();
            n2 = string.indexOf(61);
        }
        stringArray = new String[arrayList.size()][];
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String[])arrayList.get(n);
        }
        return stringArray;
    }

    public static String doXMLEscape(String string) {
        int n = string.indexOf(38);
        while (n >= 0) {
            int n2 = string.indexOf("&amp;", n);
            if (n != n2) {
                string = string.substring(0, n) + "&amp;" + string.substring(n + 1, string.length());
            }
            n = string.indexOf(38, n + 4);
        }
        n = string.indexOf(60);
        while (n >= 0) {
            string = string.substring(0, n) + "&lt;" + string.substring(n + 1, string.length());
            n = string.indexOf(60);
        }
        n = string.indexOf(62);
        while (n >= 0) {
            string = string.substring(0, n) + "&gt;" + string.substring(n + 1, string.length());
            n = string.indexOf(62);
        }
        n = string.indexOf(34);
        while (n >= 0) {
            string = string.substring(0, n) + "&quot;" + string.substring(n + 1, string.length());
            n = string.indexOf(34);
        }
        n = string.indexOf(37);
        while (n >= 0) {
            string = string.substring(0, n) + "%" + PERCENT_ASCII + string.substring(n + 1, string.length());
            n = string.indexOf(37, n + 2);
        }
        n = string.indexOf(43);
        while (n >= 0) {
            string = string.substring(0, n) + "%" + PLUS_ASCII + string.substring(n + 1, string.length());
            n = string.indexOf(43);
        }
        n = string.indexOf(38);
        while (n >= 0) {
            string = string.substring(0, n) + "%" + AMP_ASCII + string.substring(n + 1, string.length());
            n = string.indexOf(38);
        }
        return string;
    }

    public void setSVGZoomRatio(double d) {
        this.mRequest.setSVGZoomRatio(d);
    }

    public void setShowSVGNavBar(boolean bl) {
        this.mRequest.setShowSVGNavBar(bl);
    }

    public void setSVGZoomLevels(int n) {
        this.mRequest.setSVGZoomLevels(n);
    }

    public void setSVGZoomFactor(double d) {
        this.mRequest.setSVGZoomFactor(d);
    }

    public void setSVGOnClick(String string) {
        this.mRequest.setSVGOnClick(string);
    }

    public void setSVGOnMouseMove(String string) {
        this.mRequest.setSVGOnMouseMove(string);
    }

    public void setSVGOnRectangleSelect(String string) {
        this.mRequest.setSVGOnRectangleSelect(string);
    }

    public void setSVGOnPolygonSelect(String string) {
        this.mRequest.setSVGOnPolygonSelect(string);
    }

    public void setRenderRasterBaseMapInSVG(boolean bl) {
        this.mRequest.setRenderRasterBaseMapInSVG(bl);
    }

    public void setSVGFragmentType(int n) {
        this.mRequest.setSVGFragmentType(n);
    }

    public void setSVGFragmentInDeviceCoord(boolean bl) {
        this.mRequest.setSVGFragmentInDeviceCoord(bl);
    }

    public String getSVGStreamAsString() {
        return this.svgStream.getStringValue();
    }

    public String getThemeAsHTMLAreas(String string, boolean bl) {
        return this.svgStream.getThemeAsHTMLAreas(string, bl);
    }

    public void setWorkspaceNameForInfoRequest(String string) {
        this.wspName = string;
    }

    public void setWorkspaceSavedPointForInfoRequest(String string) {
        this.wspSavedPoint = string;
    }

    public void setWorkspaceDateForInfoRequest(String string) {
        this.wspDate = string;
    }

    public void setWorkspaceDateFormatForInfoRequest(String string, String string2, boolean bl) {
        this.wspDateFormat = string;
        this.wspDateNlsparam = string2;
        this.wspTimestamp = bl;
    }

    private String getWorkspaceAttributesForInfoRequest() {
        return "" + (this.wspName != null ? " workspace_name=\"" + this.wspName + "\" " : "") + (this.wspName != null && this.wspSavedPoint != null ? " workspace_savepoint=\"" + this.wspSavedPoint + "\" " : "") + (this.wspName != null && this.wspDate != null ? " workspace_date=\"" + this.wspDate + "\" " : "") + (this.wspName != null && this.wspDate != null && !this.wspDateFormat.equals("mmddyyyyhh24miss") ? " workspace_date_format=\"" + this.wspDateFormat + "\" " : "") + (this.wspName != null && this.wspDate != null && this.wspDateNlsparam != null ? " workspace_date_nlsparam=\"" + this.wspDateNlsparam + "\" " : "") + (this.wspName != null && this.wspDate != null && this.wspTimestamp ? " workspace_date_tswtz=\"" + this.wspTimestamp + "\" " : "");
    }

    public void resetWorkspaceAttributesForInfoRequest() {
        this.wspName = null;
        this.wspSavedPoint = null;
        this.wspDate = null;
        this.wspDateFormat = "mmddyyyyhh24miss";
        this.wspDateNlsparam = null;
        this.wspTimestamp = false;
    }

    public Object putCustomProperty(Object object, Object object2) {
        return this.mRequest.putCustomProperty(object, object2);
    }

    public Object getCustomProperty(Object object) {
        return this.mRequest.getCustomProperty(object);
    }

    public Object removeCustomProperty(Object object) {
        return this.mRequest.removeCustomProperty(object);
    }

    public void clearCustomProperties() {
        this.mRequest.clearCustomProperties();
    }

    public void addNSDataProvider(String string, String string2, String string3, String string4, Properties properties, long l) {
        NsDpInfo nsDpInfo = new NsDpInfo();
        nsDpInfo.setDpId(string);
        nsDpInfo.setTheme(string2);
        nsDpInfo.setJoinColumnSpatial(string3);
        nsDpInfo.setCustomRenderStyle(string4);
        nsDpInfo.setDpParams(properties);
        this.mRequest.addNsDp(nsDpInfo);
    }

    public void removeAllNSDataProviders() {
        this.mRequest.removeAllNsDps();
    }

    public Hashtable getThemeModifiers() {
        return this.mRequest.getThemeModifiers();
    }

    public void addThemeModifier(String string, String string2, String string3) {
        this.mRequest.addThemeModifier(string, string2, string3);
    }

    public void removeThemeModifier(String string, String string2) {
        this.mRequest.removeThemeModifier(string, string2);
    }

    public void removeThemeModifiers(String string) {
        this.mRequest.removeThemeModifiers(string);
    }

    public void removeAllThemeModifiers() {
        this.mRequest.removeAllThemeModifiers();
    }

    public void setUseCachedBaseMap(boolean bl) {
        this.mRequest.setUseCachedBaseMap(bl);
    }

    public void setSnapToCachedZoomLevel(boolean bl) {
        this.mRequest.setSnapToCachedZoomLevel(bl);
    }

    public void addDotDensityStyle(String string, int n, int n2, String string2) throws Exception {
        String string3;
        String string4 = string3 = string2 != null && string2.length() > 0 ? " MarkerStyle=\"" + XMLUtil.replaceXMLEntities(string2) + "\" " : "";
        if (n <= 0) {
            n = 6;
        }
        if (n2 <= 0) {
            n2 = 6;
        }
        String string5 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <AdvancedStyle>\n" + STY_APPEND + "     <DotDensityStyle   DotWidth=\"" + n + "\" DotHeight=\"" + n2 + "\"" + string3 + ">\n" + STY_APPEND + "     </DotDensityStyle>\n" + STY_APPEND + "  </AdvancedStyle>\n" + STY_APPEND + "</style>\n";
        this.mRequest.addDynamicStyle(string, string5);
    }

    public void addCollectionStyle(String string, String[] stringArray, String[] stringArray2) throws Exception {
        if (stringArray == null) {
            return;
        }
        String string2 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n" + STY_APPEND + "  <AdvancedStyle>\n" + STY_APPEND + "     <CollectionStyle>\n";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            string2 = string2 + "          <style name=\"" + XMLUtil.replaceXMLEntities(stringArray[i]) + "\"";
            if (stringArray2 != null && stringArray2[i] != null) {
                string2 = string2 + " shape=\"" + XMLUtil.replaceXMLEntities(stringArray2[i]) + "\"";
            }
            string2 = string2 + "/>\n";
        }
        string2 = string2 + "         </CollectionStyle>\n      </AdvancedStyle>\n    </style>\n";
        this.mRequest.addDynamicStyle(string, string2);
    }

    public void setSVGInfoFont(String string) {
        this.mRequest.setSVGInfoFont(string);
    }

    public MapResponse getMapResponse() {
        return this.mResponse;
    }

    public ClientMapRequest getMapRequest() {
        return this.mRequest;
    }

    public void addStyle(String string, StyleModel styleModel) {
        if (styleModel == null || string == null) {
            throw new IllegalArgumentException("invalid argument.");
        }
        String string2 = styleModel.toXMLString();
        String string3 = "    <style name=\"" + XMLUtil.replaceXMLEntities(string) + "\">\n";
        int n = string2.indexOf("<AdvancedStyle>");
        if (n >= 0) {
            int n2 = string2.indexOf("/AdvancedStyle>", n);
            String string4 = string3 + string2.substring(n, n2 + "</AdvancedStyle>".length()) + "\n" + STY_APPEND + "</style>\n";
            this.mRequest.addDynamicStyle(string, string4);
            return;
        }
        n = string2.indexOf("<g ");
        if (n >= 0) {
            int n3 = string2.indexOf("</g>");
            String string5 = string3 + string2.substring(n, n3 + "</g>".length()) + "\n" + STY_APPEND + "</style>\n";
            this.mRequest.addDynamicStyle(string, string5);
            return;
        }
        System.err.println("invalid xml style representation.");
    }

    public void setThemeBindingParameters(String string, Object[] objectArray) {
        this.mMapDef.setPredefinedThemeParameters(string, objectArray);
    }

    public void setThemeRuntimeParameters(String string, Properties properties) {
        this.mMapDef.setThemeRuntimeParameters(string, properties);
    }

    public void setThemeRenderLabels(String string, boolean bl) {
        this.mMapDef.setThemeRenderLabels(string, bl);
    }

    public void setThemeFetchSize(String string, int n) {
        this.mMapDef.setThemeFetchSize(string, n);
    }

    public void setThemeRenderingRules(String string, RenderingRule[][] renderingRuleArray) {
        this.mMapDef.setThemeRenderingRules(string, renderingRuleArray);
    }

    public void setMapPiecesRendered(boolean bl) {
        this.mRequest.setMapPiecesRendered(bl);
    }

    public boolean isMapPiecesRendered() {
        return this.mRequest.isMapPiecesRendered();
    }

    public void setMapFootnote(String string) {
        this.mRequest.setFootnote(string);
    }

    public String getMapFootnote() {
        return this.mRequest.getFootnote();
    }

    public String getMapFootnoteStyleName() {
        return this.mRequest.getFootnoteStyleName();
    }

    public void setMapFootnoteStyleName(String string) {
        this.mRequest.setFootnoteStyleName(string);
    }

    public int getNumberOfAvailableMappers(String string) throws Exception {
        if (string == null) {
            return 0;
        }
        String string2 = "<?xml version=\"1.0\" standalone=\"yes\" ?><non_map_request>  <number_available_mappers data_source=\"" + string + "\" />" + "</non_map_request>";
        this.sendXMLRequest(string2);
        String string3 = this.getXMLResponse();
        if (string3.indexOf("count=") < 0) {
            return 0;
        }
        int n = -1;
        n = string3.indexOf("count=\"");
        int n2 = string3.indexOf("\"", n + 7);
        if (n2 < 0) {
            return 0;
        }
        String string4 = string3.substring(n + 7, n2);
        if (string4 == null || string4.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string4);
    }

    public void setMapRequestRotation(double d) {
        this.mRequest.setRotation(d);
    }

    public double getMapRequestRotation() {
        return this.mRequest.getRotation();
    }

    public double getMapResponseRotation() {
        if (this.mResponse == null) {
            return 0.0;
        }
        return this.mResponse.getRotation();
    }

    public static Point2D rotatePoint(Point2D point2D, Point2D point2D2, double d) {
        if (point2D == null || point2D2 == null || d < -360.0 || d > 360.0) {
            return null;
        }
        double d2 = Math.PI;
        double d3 = d * d2 / 180.0;
        double d4 = point2D2.getX();
        double d5 = point2D2.getY();
        double d6 = point2D.getX() - d4;
        double d7 = point2D.getY() - d5;
        double d8 = d6 * Math.cos(d3) - d7 * Math.sin(d3) + d4;
        double d9 = d6 * Math.sin(d3) + d7 * Math.cos(d3) + d5;
        return new Point2D.Double(d8, d9);
    }

    public void setNorthArrow(NorthArrow northArrow) {
        this.mRequest.setNorthArrow(northArrow);
    }

    public NorthArrow getNorthArrow() {
        return this.mRequest.getNorthArrow();
    }

    public String getCookies() {
        return this.cookies;
    }

    public void setCookies(String string) {
        this.cookies = string;
    }

    public int addWMTSTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Properties properties) {
        boolean bl = false;
        String string9 = "unbiased";
        int n = 8;
        if (properties != null) {
            String string10 = properties.getProperty("snap_to_tile_scale", "false");
            bl = Boolean.parseBoolean(string10);
            string9 = properties.getProperty("tile_resizing_option", "unbiased");
            string10 = properties.getProperty("current_threads", Integer.toString(8));
            try {
                n = Integer.parseInt(string10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mMapDef.addWMTSTheme(string, string2, string3, string4, string5, string6, string7, string8, bl, string9, n);
    }

    public int addLRSTheme(String string) {
        return this.mMapDef.addLRSTheme(string);
    }

    static {
        try {
            mDPI = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Throwable throwable) {
            System.err.println("Cannot determine native display resolution: " + throwable.getMessage());
            System.err.println("Using 96 as default DPI.");
        }
        STYLE_COLOR = "COLOR";
        STYLE_MARKER = "MARKER";
        STYLE_AREA = "AREA";
        STYLE_LINE = "LINE";
        STYLE_TEXT = "TEXT";
        STYLE_ADVANCED = "ADVANCED";
        AMP_ASCII = "" + Integer.toHexString(38);
        PERCENT_ASCII = "" + Integer.toHexString(37);
        PLUS_ASCII = "" + Integer.toHexString(43);
    }
}

