/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.util.Date;
import java.util.Properties;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.Validator;
import oracle.security.digsig.ValidatorProperties;
import oracle.security.digsig.ValidatorSPI;
import oracle.security.digsig.ValidatorStore;

class SPIValidator
extends Validator {
    private ValidatorSPI spiValidatorImpl;

    SPIValidator(KeyStoreWrapper pKeyStore, CertificateMapper pCertMapper, ValidatorStore pValidatorStore, Properties pConfig, String providerClass) throws DigitalSignatureException {
        try {
            this.spiValidatorImpl = (ValidatorSPI)Class.forName(providerClass).newInstance();
            this.spiValidatorImpl.init(pKeyStore, pCertMapper, pValidatorStore, pConfig);
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Cannot load Validator provider class " + providerClass);
        }
    }

    @Override
    public ValidatorProperties getValidatorProperties() throws DigitalSignatureException {
        return this.spiValidatorImpl.engineGetValidatorProperties();
    }

    @Override
    public int getValidationMode() {
        return this.spiValidatorImpl.engineGetValidationMode();
    }

    @Override
    public int validateCert(String cert, Date pSigningTime) throws DigitalSignatureException {
        return this.spiValidatorImpl.engineValidateCert(cert, pSigningTime);
    }
}

