/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.util.Properties;
import oracle.security.digsig.BrowserSignRequest;
import oracle.security.digsig.BrowserSignRequestSPI;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;

class SPIBrowserSignRequest
extends BrowserSignRequest {
    private BrowserSignRequestSPI spiBrowserSignRequestImpl;

    SPIBrowserSignRequest(CertificateMapper pCertMapper, Properties pConfig, String providerClass) throws DigitalSignatureException {
        try {
            Class<?> c = Class.forName(providerClass);
            this.spiBrowserSignRequestImpl = (BrowserSignRequestSPI)c.newInstance();
            this.spiBrowserSignRequestImpl.init(pCertMapper, pConfig);
        }
        catch (Exception e) {
            throw new DigitalSignatureException("Cannot load BrowserSignRequestprovider class " + providerClass);
        }
    }

    @Override
    public void start(String userID, String returnURL) throws DigitalSignatureException {
        this.spiBrowserSignRequestImpl.engineStart(userID, returnURL);
    }

    @Override
    public void update(byte[] plaintext, int offset, int length) throws DigitalSignatureException {
        this.spiBrowserSignRequestImpl.engineUpdate(plaintext, offset, length);
    }

    @Override
    public void finish() throws DigitalSignatureException {
        this.spiBrowserSignRequestImpl.engineFinish();
    }

    @Override
    public boolean isSupported(int uiType) {
        return this.spiBrowserSignRequestImpl.engineIsSupported(uiType);
    }

    @Override
    public int setBrowserSignResponse(String sigData, String sigInfo, Properties sigDataExtra) throws DigitalSignatureException {
        return this.spiBrowserSignRequestImpl.engineSetBrowserSignResponse(sigData, sigInfo, sigDataExtra);
    }

    @Override
    public String getBrowserSignRequestHTML(Properties hFields, Properties guiText, Properties bConfig) throws DigitalSignatureException {
        return this.spiBrowserSignRequestImpl.engineGetBrowserSignRequestHTML(hFields, guiText, bConfig);
    }

    @Override
    public Object getBrowserSignRequestOAF(Properties hFields, Properties guiText, Properties bConfig, Object pageContext) throws DigitalSignatureException {
        return this.spiBrowserSignRequestImpl.engineGetBrowserSignRequestOAF(hFields, guiText, bConfig, pageContext);
    }

    @Override
    public int getSignatureFormat() {
        return this.spiBrowserSignRequestImpl.engineGetSignatureFormat();
    }

    @Override
    public String getSignature() throws DigitalSignatureException {
        return this.spiBrowserSignRequestImpl.engineGetSignature();
    }

    @Override
    public void addRecipientID(String id) throws DigitalSignatureException {
        this.spiBrowserSignRequestImpl.engineAddRecipientID(id);
    }
}

