/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.pki.OraclePKIProvider;

public class KeyStoreWrapper {
    private boolean loaded = false;
    private KeyStore jdkKeyStore;

    public KeyStoreWrapper(String fileName, char[] passWord) throws DigitalSignatureException {
        try {
            FileInputStream fs = new FileInputStream(fileName);
            Security.insertProviderAt((Provider)new OraclePKIProvider(), 1);
            this.jdkKeyStore = KeyStore.getInstance("PKCS12");
            this.jdkKeyStore.load(fs, passWord);
            fs.close();
            this.loaded = true;
        }
        catch (Exception e) {
            throw new DigitalSignatureException(e.toString());
        }
    }

    public KeyStoreWrapper(String fileName, char[] passWord, Provider providerClass, String providerType) throws DigitalSignatureException {
        try {
            FileInputStream fs = new FileInputStream(fileName);
            if (providerClass != null) {
                Security.insertProviderAt(providerClass, 1);
            }
            if (providerType != null) {
                this.jdkKeyStore = KeyStore.getInstance(providerType);
                this.jdkKeyStore.load(fs, passWord);
                this.loaded = true;
            }
            fs.close();
        }
        catch (Exception e) {
            throw new DigitalSignatureException(e.toString());
        }
    }

    KeyStore getKeyStore() throws DigitalSignatureException {
        if (!this.loaded) {
            throw new DigitalSignatureException("KeyStore not loaded yet");
        }
        return this.jdkKeyStore;
    }
}

