/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.javatools.logging.Diagnostics;

public final class SwingThreadViolationDetector
extends RepaintManager {
    private WeakReference<JComponent> lastComponent;
    private Set<Violation> violations = new TreeSet<Violation>();
    private static List<ViolationException> violationExceptions = new ArrayList<ViolationException>();
    private static Report report = Report.OFF;
    private static Logger logger;
    public static final String PROPERTY_SYSTEM_REPORT_VIOLATIONS = "oracle.ide.reportEDTViolations";
    public static final String PROPERTY_SYSTEM_EXCEPTIONS_FILE = "oracle.ide.reportEDTViolations.exceptionsfile";

    private synchronized Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("EDT Violations");
            try {
                File log = Diagnostics.newFile((String)"EDT-Violation", null, (String)".log");
                if (log != null) {
                    FileHandler fh = new FileHandler(log.toString());
                    logger.addHandler(fh);
                    fh.setFormatter(new SimpleFormatter());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return logger;
    }

    public static boolean install() {
        String reportType = System.getProperty(PROPERTY_SYSTEM_REPORT_VIOLATIONS);
        if (reportType == null) {
            return true;
        }
        if (reportType.equalsIgnoreCase("bug")) {
            report = Report.BUG;
            RepaintManager.setCurrentManager(new SwingThreadViolationDetector());
        } else if (reportType.equalsIgnoreCase("console")) {
            report = Report.CONSOLE;
            RepaintManager.setCurrentManager(new SwingThreadViolationDetector());
        }
        SwingThreadViolationDetector.createExceptions();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createExceptions() {
        String exceptionsFileName = System.getProperty(PROPERTY_SYSTEM_EXCEPTIONS_FILE);
        String fullName = null;
        if (exceptionsFileName != null) {
            File file;
            if (exceptionsFileName.startsWith(".")) {
                file = new File(exceptionsFileName);
                if (file.exists()) {
                    fullName = exceptionsFileName;
                } else {
                    fullName = System.getProperty("oracle.home");
                    if (fullName == null) {
                        fullName = "";
                    }
                    if (!fullName.endsWith("/")) {
                        fullName = fullName + "/";
                    }
                    fullName = fullName + exceptionsFileName;
                }
            } else {
                fullName = exceptionsFileName;
            }
            file = new File(fullName);
            Reader reader = null;
            try {
                reader = new FileReader(file);
                reader = new BufferedReader(reader);
                String line = ((BufferedReader)reader).readLine();
                ViolationException ve = new ViolationException();
                while (line != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                        if (!ve.stackElement.isEmpty()) {
                            violationExceptions.add(ve);
                            ve = new ViolationException();
                        }
                    } else {
                        line = SwingThreadViolationDetector.formatLine(line);
                        ve.stackElement.add(line);
                    }
                    line = ((BufferedReader)reader).readLine();
                }
                if (!ve.stackElement.isEmpty()) {
                    violationExceptions.add(ve);
                }
            }
            catch (FileNotFoundException e) {
                String msg = "Cannot find file specified by the System property: oracle.ide.reportEDTViolations.exceptionsfile = " + fullName + "\nThis property is usually specified in ide.conf";
                Logger.getLogger("global").log(Level.WARNING, msg);
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations(component);
        super.addInvalidComponent(component);
    }

    @Override
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations(component);
        super.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!this.isValidThread() && c.isShowing()) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean imageUpdate = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.") && !st.getClassName().startsWith("javax.swing.SwingWorker")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            this.violationFound(c, stackTrace);
        }
    }

    private boolean isValidThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    protected void violationFound(JComponent c, StackTraceElement[] stackTrace) {
        if (this.isViolationException(stackTrace)) {
            return;
        }
        Violation v = new Violation(c, stackTrace);
        this.violations.add(v);
        v.report();
    }

    private boolean isViolationException(StackTraceElement[] stackTrace) {
        for (ViolationException ve : violationExceptions) {
            int foundLevel = -1;
            for (StackTraceElement elem : stackTrace) {
                String line = SwingThreadViolationDetector.formatLine(elem.toString());
                if (line.equals(ve.stackElement.get(++foundLevel))) {
                    if (foundLevel != ve.stackElement.size() - 1) continue;
                    return true;
                }
                foundLevel = -1;
            }
        }
        return false;
    }

    private static String formatLine(String line) {
        int braceIndex = (line = line.trim()).indexOf(40);
        if (braceIndex > -1) {
            line = line.substring(0, braceIndex);
        }
        return line;
    }

    private static class ViolationException {
        List<String> stackElement = new ArrayList<String>();

        private ViolationException() {
        }
    }

    private class Violation
    implements Comparable<Violation> {
        private final StackTraceElement[] stackTrace;
        private final String componentString;
        private long id = 0L;

        Violation(JComponent c, StackTraceElement[] stackTrace) {
            this.stackTrace = this.trimStackTrace(stackTrace);
            this.componentString = c.toString();
            for (StackTraceElement st : stackTrace) {
                this.id += (long)st.hashCode();
            }
        }

        private StackTraceElement[] trimStackTrace(StackTraceElement[] stackTrace) {
            int trimAmount = 3;
            if (stackTrace.length <= 3) {
                return stackTrace;
            }
            StackTraceElement[] trimmedStack = new StackTraceElement[stackTrace.length - 3];
            System.arraycopy(stackTrace, 3, trimmedStack, 0, stackTrace.length - 3);
            return trimmedStack;
        }

        @Override
        public int compareTo(Violation that) {
            if (this.id < that.id) {
                return -1;
            }
            if (this.id > that.id) {
                return 1;
            }
            return 0;
        }

        public void report() {
            String reportText = "Call to Swing component not from the EDT Thread - in violation of Swing's single threaded policy.";
            switch (report) {
                case BUG: {
                    IllegalStateException e = new IllegalStateException(reportText);
                    Object[] logOptions = new Object[]{this.componentString, "(" + SwingThreadViolationDetector.this.violations.size() + " total EDT violations found)\n", new FeedbackLogOptions((Throwable)e, 5)};
                    SwingThreadViolationDetector.this.getLogger().log(Level.SEVERE, reportText, logOptions);
                }
                case CONSOLE: {
                    StringBuilder sb = new StringBuilder(this.componentString + "\n");
                    for (StackTraceElement st : this.stackTrace) {
                        sb.append("\tat " + st + "\n");
                    }
                    SwingThreadViolationDetector.this.getLogger().log(Level.INFO, reportText + "\n" + sb.toString());
                }
            }
        }
    }

    private static enum Report {
        OFF,
        BUG,
        CONSOLE;

    }
}

