/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.internal.ui;

import java.awt.AWTEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import oracle.javatools.internal.ui.EventQueueFilter;
import oracle.javatools.internal.ui.EventQueueWrapper;

public abstract class AbstractInvocationEventFilter
extends EventQueueFilter {
    private static Logger _sLogger = null;
    private static Field _sInvocationEventRunnableField = null;
    private static Class _sSwingTimerRunnableClass = null;
    private static Field _sSwingTimerRunnableOuterClassField = null;
    private static Field _sSwingTimerListenerListField = null;

    @Override
    public final EventQueueFilter.Result filterEvent(EventQueueWrapper wrapper, AWTEvent event) {
        if (event instanceof InvocationEvent) {
            InvocationEvent invEvent = (InvocationEvent)event;
            Runnable runnable = AbstractInvocationEventFilter.getRunnableFromEvent(invEvent);
            return this.filterInvocationEvent(wrapper, invEvent, runnable);
        }
        return EventQueueFilter.Result.DELIVER_EVENT;
    }

    public abstract EventQueueFilter.Result filterInvocationEvent(EventQueueWrapper var1, InvocationEvent var2, Runnable var3);

    public static Runnable getRunnableFromEvent(InvocationEvent event) {
        AbstractInvocationEventFilter._ensureReflectionCacheInitialized();
        Runnable runnable = null;
        try {
            runnable = (Runnable)_sInvocationEventRunnableField.get(event);
        }
        catch (Throwable t) {
            AbstractInvocationEventFilter.getLogger().log(Level.SEVERE, "Unexpected Error: Unable to retrieve invocation event via reflection", t);
            runnable = null;
        }
        return runnable;
    }

    public static boolean isSwingTimerRunnable(Runnable runnable) {
        AbstractInvocationEventFilter._ensureReflectionCacheInitialized();
        return runnable.getClass() == _sSwingTimerRunnableClass;
    }

    public static List<ActionListener> getSwingTimerActionListeners(Runnable runnable) {
        if (AbstractInvocationEventFilter.isSwingTimerRunnable(runnable)) {
            try {
                ActionListener[] actionListeners;
                Object outerClassInstance = _sSwingTimerRunnableOuterClassField.get(runnable);
                EventListenerList listenerList = (EventListenerList)_sSwingTimerListenerListField.get(outerClassInstance);
                if (listenerList != null && (actionListeners = (ActionListener[])listenerList.getListeners(ActionListener.class)) != null) {
                    return Arrays.asList(actionListeners);
                }
            }
            catch (Throwable t) {
                AbstractInvocationEventFilter.getLogger().log(Level.SEVERE, "Unexpected Error: Unable to retrieve listener list via reflection", t);
            }
        }
        return Collections.emptyList();
    }

    private static void _ensureReflectionCacheInitialized() {
        if (_sInvocationEventRunnableField == null) {
            try {
                Class<?>[] declaredClasses;
                _sInvocationEventRunnableField = InvocationEvent.class.getDeclaredField("runnable");
                _sInvocationEventRunnableField.setAccessible(true);
                for (Class<?> candidate : declaredClasses = Timer.class.getDeclaredClasses()) {
                    if (!"javax.swing.Timer$DoPostEvent".equals(candidate.getName())) continue;
                    _sSwingTimerRunnableClass = candidate;
                    break;
                }
                if (_sSwingTimerRunnableClass == null) {
                    throw new IllegalStateException("Unexpected Error: Unable to find javax.swing.Timer inner class via reflection");
                }
                _sSwingTimerRunnableOuterClassField = _sSwingTimerRunnableClass.getDeclaredFields()[0];
                _sSwingTimerRunnableOuterClassField.setAccessible(true);
                _sSwingTimerListenerListField = Timer.class.getDeclaredField("listenerList");
                _sSwingTimerListenerListField.setAccessible(true);
            }
            catch (Throwable t) {
                IllegalStateException e = new IllegalStateException("Unexpected Error: Unable to initialize the reflection cache", t);
                AbstractInvocationEventFilter.getLogger().log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        }
    }

    protected static Logger getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger(AbstractInvocationEventFilter.class.getName());
        }
        return _sLogger;
    }
}

