/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.plugins;

import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.plugins.EditorPlugin;

public class TrailingSpacePlugin
implements EditorPlugin,
ChangeListener,
HierarchyListener {
    private BasicEditorPane _editor;
    private int _oldHeight = -1;
    private int _oldWidth = -1;
    private JViewport _viewport;

    @Override
    public void install(BasicEditorPane editor) {
        this._oldHeight = -1;
        this._oldWidth = -1;
        this._editor = editor;
        this._editor.addHierarchyListener(this);
        this.updateViewportTracking();
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        this._oldHeight = -1;
        this._oldWidth = -1;
        this._editor.removeHierarchyListener(this);
        this.clearViewportTracking();
        this._editor = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.updateTrailingCount();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        this.updateViewportTracking();
    }

    protected BasicEditorPane getEditorPane() {
        return this._editor;
    }

    protected int calculateTrailingRows(int viewportHeight) {
        FontHelper helper = this._editor.getFontHelper();
        FontMetrics metrics = helper.getFontMetrics(0, (Component)this._editor);
        int fontHeight = metrics.getHeight();
        int trailingHeight = (int)((double)viewportHeight * 0.95);
        int trailingRows = trailingHeight / fontHeight - 1;
        return Math.max(1, trailingRows);
    }

    protected int calculateTrailingColumns(int viewportWidth) {
        FontHelper helper = this._editor.getFontHelper();
        FontMetrics metrics = helper.getFontMetrics(0, (Component)this._editor);
        int fontWidth = metrics.charWidth('m');
        int trailingWidth = (int)((double)viewportWidth * 0.1);
        int trailingColumns = trailingWidth / fontWidth - 1;
        return Math.max(1, trailingColumns);
    }

    private void updateTrailingCount() {
        if (this._viewport != null && this._editor != null) {
            int newHeight = this._viewport.getHeight();
            int newWidth = this._viewport.getWidth();
            if (this._oldHeight != newHeight) {
                int trailingRows = this.calculateTrailingRows(newHeight);
                this._editor.putIntegerProperty("trailing-blank-rows", trailingRows);
                this._oldHeight = newHeight;
            }
            if (this._oldWidth != newWidth) {
                int trailingColumns = this.calculateTrailingColumns(newWidth);
                this._editor.putIntegerProperty("trailing-blank-columns", trailingColumns);
                this._oldWidth = newWidth;
            }
        }
    }

    private void updateViewportTracking() {
        Container parent;
        if (this._editor != null && (parent = this._editor.getParent()) != this._viewport) {
            this.clearViewportTracking();
            if (parent instanceof JViewport) {
                this._viewport = (JViewport)parent;
                if (this._viewport != null) {
                    this._viewport.addChangeListener(this);
                    this.updateTrailingCount();
                }
            }
        }
    }

    private void clearViewportTracking() {
        if (this._viewport != null) {
            this._viewport.removeChangeListener(this);
            this._viewport = null;
            this._oldHeight = -1;
            this._oldWidth = -1;
        }
    }
}

