/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.jsp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.html.HTMLBlockRenderer;
import oracle.javatools.editor.language.html.TagBlockRenderer;
import oracle.javatools.editor.language.java.JavaBlockRenderer;
import oracle.javatools.editor.language.jsp.JSPTagBlockRenderer;

final class JSPBlockRenderer
extends HTMLBlockRenderer {
    protected JavaBlockRenderer javaRenderer;

    JSPBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.javaRenderer = new JavaBlockRenderer(textBuffer);
        this.setRecognizeJSP(true);
    }

    @Override
    protected TagBlockRenderer createTagRenderer(TextBuffer textBuffer) {
        return new JSPTagBlockRenderer(textBuffer);
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 21: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderHTMLTag(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderJavaTag(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    protected void renderJavaTag(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        int symbolEnd;
        int symbolStart;
        int javaStartOffset = tokenStart;
        int javaEndOffset = tokenEnd;
        switch (token) {
            case 22: {
                javaStartOffset += 2;
                break;
            }
            case 23: 
            case 24: {
                javaStartOffset += 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown java tag: " + token);
            }
        }
        if (this.textBuffer.getChar(tokenEnd - 1) == '>' && this.textBuffer.getChar(tokenEnd - 2) == '%') {
            int tokenLength = tokenEnd - tokenStart;
            int endLength = Math.max(Math.min(tokenLength - 2, 2), 0);
            javaEndOffset -= endLength;
        }
        if ((symbolStart = Math.max(tokenStart, clipStart)) < (symbolEnd = Math.min(javaStartOffset, clipEnd))) {
            fragmentsList.add("html-symbol-style", symbolStart, symbolEnd);
        }
        if (javaStartOffset != javaEndOffset) {
            int newClipStart = Math.max(javaStartOffset, clipStart);
            int newClipEnd = Math.min(javaEndOffset, clipEnd);
            this.javaRenderer.renderBlock(fragmentsList, javaStartOffset, javaEndOffset, newClipStart, newClipEnd);
        }
        if (javaEndOffset != tokenEnd && (symbolStart = Math.max(javaEndOffset, clipStart)) < (symbolEnd = Math.min(tokenEnd, clipEnd))) {
            fragmentsList.add("html-symbol-style", symbolStart, symbolEnd);
        }
    }

    @Override
    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                throw new IllegalStateException("Should be sub-rendering tags");
            }
            case 25: {
                return "html-comment-style";
            }
        }
        return super.mapTokenToStyleName(token);
    }
}

