/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.OffsetDescriptionProvider;
import oracle.javatools.editor.language.java.SourceFileReducer;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;

public class JavaOffsetDescriptionProvider
implements OffsetDescriptionProvider {
    @Override
    public String getDescription(TextBuffer buffer, int offset) {
        String name = "";
        SourceFileReducer sourceFileReducer = new SourceFileReducer();
        buffer = sourceFileReducer.reduce(buffer, offset);
        offset = sourceFileReducer.getAdjustedOffsets().get(0);
        SourceFile sf = JavaParser.parse((ReadTextBuffer)buffer, (JdkVersion)JdkVersion.getMaxVersion());
        for (SourceElement se = sf.getElementAt(offset); se != null; se = se.getParent()) {
            if (se instanceof SourceMethod) {
                SourceMethod sm = (SourceMethod)se;
                name = name + JavaOffsetDescriptionProvider.getMethodName((JavaMethod)sm);
                continue;
            }
            if (se instanceof SourceClass) {
                SourceClass sc = (SourceClass)se;
                if (sc == sf.getPrimaryClass()) continue;
                name = sc.isAnonymous() ? "$." + name : JavaOffsetDescriptionProvider.getClassName((JavaClass)sc) + "." + name;
                continue;
            }
            if (se instanceof SourceImport) {
                name = "Imports";
                continue;
            }
            if (!(se instanceof SourceClassInitializer)) continue;
            name = "Initializer";
        }
        return name.equals("") ? null : name;
    }

    private static String getMethodName(JavaMethod javaMethod) {
        SourceMethod sm = javaMethod.getSourceElement();
        return sm != null ? JavaOffsetDescriptionProvider.getMethodNamePrimary(sm) : JavaOffsetDescriptionProvider.getMethodNameFallback(javaMethod);
    }

    private static String getMethodNamePrimary(SourceMethod sourceMethod) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        sourceMethod.print(pw, 1);
        String s = sw.toString();
        pw.close();
        return s;
    }

    private static String getMethodNameFallback(JavaMethod javaMethod) {
        StringBuffer name = new StringBuffer();
        if (javaMethod.isConstructor()) {
            name.append(javaMethod.getOwningClass().getName());
        } else {
            name.append(javaMethod.getName());
        }
        name.append("(");
        if (javaMethod.getParameterTypes().length > 0) {
            for (JavaType paramType : javaMethod.getParameterTypes()) {
                String paramName = paramType == null ? "?" : paramType.getName();
                name.append(paramName);
                name.append(", ");
            }
            name.delete(name.length() - 2, name.length());
        }
        name.append(") : ");
        if (javaMethod.getReturnType() != null) {
            name.append(javaMethod.getReturnType().getName());
        } else {
            name.append("void");
        }
        return name.toString();
    }

    private static String getClassName(JavaClass javaClass) {
        String s = javaClass.getName();
        SourceClass sourceClass = javaClass.getSourceElement();
        if (sourceClass != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            sourceClass.print(pw, 1);
            s = sw.toString();
            pw.close();
        }
        return s;
    }
}

