/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.diff;

import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class DiffStyles {
    public static final String DIFF_HEADER_STYLE = "diff-header-style";
    public static final String DIFF_ADDITION_STYLE = "diff-addition-style";
    public static final String DIFF_REMOVAL_STYLE = "diff-removal-style";
    public static final String[] STYLE_NAMES = new String[]{"diff-header-style", "diff-addition-style", "diff-removal-style"};
    protected static BaseStyle diffPlainStyle;
    protected static BaseStyle diffHeaderStyle;
    protected static BaseStyle diffAdditionStyle;
    protected static BaseStyle diffRemovalStyle;

    public DiffStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String name;
        BundleHelper resources = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        diffPlainStyle = builtInStyles.plainStyle;
        diffHeaderStyle = styleRegistry.lookupStyle(DIFF_HEADER_STYLE);
        if (diffHeaderStyle == null) {
            name = resources.getString("DIFF_HEADER_STYLE");
            diffHeaderStyle = styleRegistry.createStyle(DIFF_HEADER_STYLE, name, "base-attribute-header-style");
        }
        if ((diffAdditionStyle = styleRegistry.lookupStyle(DIFF_ADDITION_STYLE)) == null) {
            name = resources.getString("DIFF_ADDITION_STYLE");
            diffAdditionStyle = styleRegistry.createStyle(DIFF_ADDITION_STYLE, name, "base-attribute-addition-style");
        }
        if ((diffRemovalStyle = styleRegistry.lookupStyle(DIFF_REMOVAL_STYLE)) == null) {
            name = resources.getString("DIFF_REMOVAL_STYLE");
            diffRemovalStyle = styleRegistry.createStyle(DIFF_REMOVAL_STYLE, name, "base-attribute-removal-style");
        }
    }
}

