/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.cpp;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.cpp.CppBlockRenderer;
import oracle.javatools.editor.language.cpp.CppLanguageSupport;
import oracle.javatools.editor.language.cpp.CppStyles;
import oracle.javatools.resource.BundleHelper;

public final class CppLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"c", "cpp", "c++", "cplusplus", "h"};

    @Override
    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("CPP_MODULE_NAME");
    }

    @Override
    public String[] getStyleNames() {
        return CppStyles.STYLE_NAMES;
    }

    @Override
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("// Employee: source\n");
        buffer.append("\n");
        buffer.append("#include <stdio.h>\n");
        buffer.append("#include \"employee.h\"\n");
        buffer.append("\n");
        buffer.append("// Employee\n");
        buffer.append("Employee::Employee( Name *name, int salary )\n");
        buffer.append("{\n");
        buffer.append("  empName = name;\n");
        buffer.append("  empID = nextEmployeeID();\n");
        buffer.append("  empSalary = salary;\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("Employee::~Employee()\n");
        buffer.append("{\n");
        buffer.append("  empName = NULL;\n");
        buffer.append("  empID = -1;\n");
        buffer.append("  empSalary = -1;\n");
        buffer.append("}\n");
        buffer.append("\n");
        buffer.append("// Employee operations\n");
        buffer.append("void Employee::giveRaise( int raise )\n");
        buffer.append("{\n");
        buffer.append("  empSalary += raise;\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    @Override
    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    @Override
    public void registerStyles(StyleRegistry registry) {
        new CppStyles(registry);
    }

    @Override
    public LanguageSupport createLanguageSupport() {
        return new CppLanguageSupport();
    }

    @Override
    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new CppBlockRenderer(buffer);
    }
}

