/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import javax.swing.event.DocumentEvent;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocumentEvent;
import oracle.javatools.editor.language.AbstractDocumentRenderer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.BooleanBitmap;
import oracle.javatools.editor.language.HistoryReadTextBuffer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerOffsetsCache;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;

public abstract class LexerDocumentRenderer
extends AbstractDocumentRenderer {
    protected LexerOffsetsCache offsetsCache = null;
    protected BlockRenderer blockRenderer;
    protected Lexer lexer = null;
    protected LexerToken lexerToken = null;

    public LexerDocumentRenderer(LanguageSupport support) {
        super(support);
    }

    protected abstract BlockRenderer createBlockRenderer();

    protected final BlockRenderer getBlockRenderer() {
        if (this.blockRenderer == null) {
            this.blockRenderer = this.createBlockRenderer();
        }
        return this.blockRenderer;
    }

    protected abstract Lexer createLexer();

    protected final Lexer getLexer() {
        if (this.lexer == null) {
            this.lexer = this.createLexer();
        }
        return this.lexer;
    }

    protected final LexerToken getLexerToken() {
        if (this.lexerToken == null) {
            this.lexerToken = this.lexer.createLexerToken();
        }
        return this.lexerToken;
    }

    public final LexerOffsetsCache getOffsetsCache() {
        if (this.offsetsCache == null) {
            this.offsetsCache = this.createOffsetsCache(this);
        }
        return this.offsetsCache;
    }

    public abstract boolean isMultiLineToken(int var1);

    @Override
    public void renderRegion(StyledFragmentsList fragmentsList, int startOffset, int endOffset) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        LexerOffsetsCache cache = this.getOffsetsCache();
        int cachedStartOffset = cache.findClosestOffset(lexer, lexerToken, startOffset);
        lexer.setTextBuffer(null);
        BlockRenderer blockRenderer = this.getBlockRenderer();
        blockRenderer.renderBlock(fragmentsList, cachedStartOffset, endOffset, startOffset, endOffset);
    }

    @Override
    public void calculateDamage(DocumentEvent changes, NumberRange damageRange) {
        int tokenEnd;
        int tokenStart;
        int token;
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = this.getLineMap();
        int lineCount = lineMap.getLineCount();
        boolean isInsert = changes.getType() == DocumentEvent.EventType.INSERT;
        int changedLength = changes.getLength();
        int changedStart = changes.getOffset();
        int afterChangeEnd = isInsert ? changedLength + changedStart : changedStart;
        int beforeChangeEnd = isInsert ? changedStart : changedLength + changedStart;
        int changedLine = lineMap.getLineFromOffset(changedStart);
        if (changedLine >= lineCount - 2) {
            damageRange.start = changedLine;
            damageRange.end = lineCount - 1;
            return;
        }
        int afterLineEnd = lineMap.getLineEndOffset(changedLine);
        int beforeLineEnd = isInsert ? afterLineEnd - changedLength : afterLineEnd + changedLength;
        int beforeTokenStart = -1;
        int beforeTokenLength = -1;
        int beforeToken = 0;
        int afterTokenStart = -1;
        int afterTokenLength = -1;
        int afterToken = 0;
        Lexer lexer = this.getLexer();
        LexerToken lexerToken = this.getLexerToken();
        int lexerStartOffset = this.getOffsetsCache().findClosestOffset(lexer, lexerToken, changedStart);
        HistoryReadTextBuffer historyBuffer = HistoryReadTextBuffer.acquireReadTextBuffer((ReadTextBuffer)textBuffer, (BasicDocumentEvent)changes);
        lexer.setTextBuffer((ReadTextBuffer)historyBuffer);
        lexer.setPosition(lexerStartOffset);
        while ((token = lexer.lex(lexerToken)) != 0) {
            tokenStart = lexerToken.getStartOffset();
            tokenEnd = lexerToken.getEndOffset();
            if (tokenStart < beforeChangeEnd || tokenEnd <= beforeLineEnd) continue;
            beforeTokenStart = lexerToken.getStartOffset();
            beforeTokenLength = lexerToken.getEndOffset() - beforeTokenStart;
            beforeToken = token;
            break;
        }
        lexer.setTextBuffer(null);
        HistoryReadTextBuffer.releaseReadTextBuffer(historyBuffer);
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(lexerStartOffset);
        while ((token = lexer.lex(lexerToken)) != 0) {
            tokenStart = lexerToken.getStartOffset();
            tokenEnd = lexerToken.getEndOffset();
            if (tokenStart < afterChangeEnd || tokenEnd <= afterLineEnd) continue;
            afterTokenStart = lexerToken.getStartOffset();
            afterTokenLength = lexerToken.getEndOffset() - afterTokenStart;
            afterToken = token;
            break;
        }
        lexer.setTextBuffer(null);
        if (afterToken != 0 && beforeToken != 0) {
            int adjustedBeforeTokenStart;
            int n = adjustedBeforeTokenStart = isInsert ? beforeTokenStart + changedLength : beforeTokenStart - changedLength;
            if (adjustedBeforeTokenStart == afterTokenStart && beforeTokenLength == afterTokenLength && beforeToken == afterToken) {
                int afterLine = lineMap.getLineFromOffset(afterTokenStart);
                damageRange.start = changedLine;
                damageRange.end = Math.max(changedLine, afterLine - 1);
                return;
            }
        }
        damageRange.start = changedLine;
        damageRange.end = lineCount - 1;
    }

    @Override
    public void notifyUpdate(DocumentEvent changes) {
        if (this.offsetsCache != null) {
            int changeStartOffset = changes.getOffset();
            this.offsetsCache.invalidateOffsets(changeStartOffset);
        }
    }

    protected LexerOffsetsCache createOffsetsCache(LexerDocumentRenderer renderer) {
        return new DefaultLexerOffsetsCache(renderer);
    }

    public static class DefaultLexerOffsetsCache
    extends LexerOffsetsCache {
        private BooleanBitmap bitmap;
        private int lastValidatedLine;

        public DefaultLexerOffsetsCache(LexerDocumentRenderer documentRenderer) {
            super(documentRenderer);
            LineMap lineMap = documentRenderer.getLineMap();
            int lineCount = lineMap.getLineCount();
            this.bitmap = new BooleanBitmap(lineCount);
            this.lastValidatedLine = 0;
        }

        @Override
        protected int findClosestOffsetInternal(Lexer lexer, LexerToken lexerToken, int offset) {
            int lineToUse;
            TextBuffer textBuffer = this.getDocumentRenderer().getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            int line = lineMap.getLineFromOffset(offset);
            if (this.lastValidatedLine < line) {
                int token;
                int startLine;
                for (startLine = this.lastValidatedLine - 1; startLine > 0; --startLine) {
                    if (this.bitmap.get(startLine)) {
                        continue;
                    }
                    ++startLine;
                    break;
                }
                startLine = Math.max(0, startLine);
                int startOffset = lineMap.getLineStartOffset(startLine);
                int endLine = line - 1;
                int endOffset = lineMap.getLineEndOffset(endLine);
                int lastEndOffset = startOffset;
                int nextLineToMark = startLine;
                lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                lexer.setPosition(startOffset);
                while (lastEndOffset < endOffset && (token = lexer.lex(lexerToken)) != 0) {
                    int commentEndLine;
                    int commentStartLine;
                    int tokenStart = lexerToken.getStartOffset();
                    int tokenEnd = lexerToken.getEndOffset();
                    if (this.getDocumentRenderer().isMultiLineToken(token) && (commentStartLine = lineMap.getLineFromOffset(tokenStart)) != (commentEndLine = lineMap.getLineFromOffset(tokenEnd))) {
                        this.markBitmap(nextLineToMark, commentStartLine, false);
                        this.markBitmap(commentStartLine, commentEndLine, true);
                        nextLineToMark = commentEndLine + 1;
                    }
                    lastEndOffset = tokenEnd;
                }
                this.markBitmap(nextLineToMark, endLine, false);
                this.lastValidatedLine = line;
            }
            for (lineToUse = line - 1; lineToUse > 0; --lineToUse) {
                if (this.bitmap.get(lineToUse)) {
                    continue;
                }
                ++lineToUse;
                break;
            }
            lineToUse = Math.max(0, lineToUse);
            int offsetToUse = lineMap.getLineStartOffset(lineToUse);
            return offsetToUse;
        }

        @Override
        protected void invalidateOffsetsInternal(int startOffset) {
            LineMap lineMap = this.getDocumentRenderer().getLineMap();
            int line = lineMap.getLineFromOffset(startOffset);
            if (this.lastValidatedLine >= line) {
                this.lastValidatedLine = Math.max(0, line - 1);
            }
            int lineCount = lineMap.getLineCount();
            this.bitmap.setSize(lineCount);
        }

        private void markBitmap(int startIndex, int endIndex, boolean value) {
            for (int i = startIndex; i < endIndex; ++i) {
                this.bitmap.set(i, value);
            }
        }
    }
}

