/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import java.awt.Color;

public final class BaseStyle {
    private String name;
    private String presentationName;
    private BaseStyle parentStyle;
    private Color fgColor;
    private boolean useParentFG;
    private Color bgColor;
    private boolean useParentBG;
    private int fontStyle;
    private boolean useParentFontStyle;

    BaseStyle(String name, String presentationName, Color fgColor, Color bgColor) {
        this.name = name;
        this.presentationName = presentationName;
        this.parentStyle = null;
        this.fgColor = fgColor;
        this.useParentFG = false;
        this.bgColor = bgColor;
        this.useParentBG = false;
        this.fontStyle = 0;
        this.useParentFontStyle = false;
    }

    BaseStyle(String name, String presentationName, BaseStyle parentStyle, boolean useParentFG, Color fgColor, boolean useParentBG, Color bgColor, boolean useParentFontStyle, int fontStyle) {
        this.name = name;
        this.presentationName = presentationName;
        this.parentStyle = parentStyle;
        this.fgColor = fgColor;
        this.useParentFG = useParentFG;
        this.bgColor = bgColor;
        this.useParentBG = useParentBG;
        this.fontStyle = fontStyle;
        this.useParentFontStyle = useParentFontStyle;
    }

    public String getName() {
        return this.name;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public String toString() {
        return this.presentationName;
    }

    public boolean getHasParent() {
        return this.parentStyle != null;
    }

    public String getParentName() {
        if (this.parentStyle != null) {
            return this.parentStyle.getName();
        }
        return null;
    }

    public Color getForegroundColor() {
        if (this.useParentFG) {
            return this.parentStyle.getForegroundColor();
        }
        return this.fgColor;
    }

    void setForegroundColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public boolean getUsesParentForegroundColor() {
        return this.useParentFG;
    }

    void setUsesParentForegroundColor(boolean useParentFG) {
        if (this.getHasParent()) {
            this.useParentFG = useParentFG;
        }
    }

    public Color getBackgroundColor() {
        if (this.useParentBG) {
            return this.parentStyle.getBackgroundColor();
        }
        return this.bgColor;
    }

    void setBackgroundColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public boolean getUsesParentBackgroundColor() {
        return this.useParentBG;
    }

    void setUsesParentBackgroundColor(boolean useParentBG) {
        if (this.getHasParent()) {
            this.useParentBG = useParentBG;
        }
    }

    public int getFontStyle() {
        if (this.useParentFontStyle) {
            return this.parentStyle.getFontStyle();
        }
        return this.fontStyle;
    }

    void setFontStyle(int fontStyle) {
        if (this.getHasParent()) {
            this.fontStyle = fontStyle;
        }
    }

    public boolean getUsesParentFontStyle() {
        return this.useParentFontStyle;
    }

    void setUsesParentFontStyle(boolean useParentFontStyle) {
        if (this.getHasParent()) {
            this.useParentFontStyle = useParentFontStyle;
        }
    }
}

