/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.keys;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import oracle.javatools.editor.keys.MultiKeyHandler;
import oracle.javatools.editor.keys.MultiKeymap;

public final class KeyHandlerFactory {
    public static final String defaultHandlerName = "Default";
    private static final String[] availableHandlers = new String[]{"Default"};
    private static MultiKeymap defaultKeymap;

    public static MultiKeyHandler createHandler(String handlerName) {
        if (handlerName.equals(defaultHandlerName)) {
            return new MultiKeyHandler(defaultKeymap);
        }
        return null;
    }

    public static String[] getAvailableHandlers() {
        return availableHandlers;
    }

    public static MultiKeymap loadKeymap(String fileName) throws MissingResourceException {
        ResourceBundle resources = ResourceBundle.getBundle(fileName, Locale.getDefault());
        String delimiter = resources.getString("DELIMITER");
        if (delimiter == null || delimiter.length() <= 0) {
            delimiter = "|";
        }
        MultiKeymap keymap = new MultiKeymap();
        KeyStroke[] keys = new KeyStroke[5];
        Enumeration<String> e = resources.getKeys();
        while (e.hasMoreElements()) {
            String keyVal;
            StringTokenizer tokenizer;
            String keyDef = e.nextElement();
            if (keyDef.equals("DELIMITER") || !(tokenizer = new StringTokenizer(keyVal = resources.getString(keyDef), delimiter)).hasMoreTokens()) continue;
            String actionName = tokenizer.nextToken().trim();
            int count = 0;
            while (tokenizer.hasMoreTokens()) {
                String keyname = tokenizer.nextToken().trim();
                KeyStroke ks = KeyStroke.getKeyStroke(keyname);
                if (ks == null) {
                    throw new IllegalStateException("No keystroke for: " + actionName + " keyname: " + keyname);
                }
                if (count >= 5) {
                    throw new IllegalStateException("Too many keys in the sequence (max is 5) for: " + actionName + "=" + keyVal);
                }
                keys[count++] = ks;
            }
            keymap.put(keys, count, actionName);
        }
        return keymap;
    }

    private static void loadDefaultKeymap() throws MissingResourceException {
        defaultKeymap = KeyHandlerFactory.loadKeymap("oracle.javatools.editor.keys.DefaultKeymapping");
    }

    public static void initialize() {
    }

    static {
        try {
            KeyHandlerFactory.loadDefaultKeymap();
        }
        catch (MissingResourceException mre) {
            System.err.println("Could not load keymap: " + mre);
            System.exit(1);
        }
        catch (RuntimeException re) {
            System.err.println("Could not load keymap: " + re);
            System.exit(1);
        }
    }
}

