/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import java.awt.Graphics;
import oracle.javatools.editor.highlight.SimpleLinePainter;

public class ZigZagLinePainter
extends SimpleLinePainter {
    public static final int MIN_THICKNESS = 2;

    public ZigZagLinePainter(int thickness, int underlineType) {
        super(Math.max(2, thickness), underlineType);
    }

    @Override
    public void paintUnderline(Graphics graphics, Color color, int xPos, int width, int yTop, int yBaseline, int descent) {
        int widthToPaint;
        int yPos = this.getYPos(yTop, yBaseline, descent);
        graphics.setColor(color);
        int currentX = xPos;
        if (this._thickness == 2) {
            for (widthToPaint = width; widthToPaint > 0; widthToPaint -= 2) {
                graphics.drawLine(currentX, yPos, currentX + 1, yPos + 1);
                currentX += 2;
            }
        } else {
            boolean paintingDown = true;
            int lineLength = this._thickness - 1;
            while (widthToPaint > 0) {
                int increment = Math.min(widthToPaint, this._thickness - 2);
                if (paintingDown) {
                    graphics.drawLine(currentX, yPos, currentX + increment, yPos + increment);
                } else {
                    int adjustedY = yPos + lineLength;
                    graphics.drawLine(currentX, adjustedY, currentX + increment, adjustedY - increment);
                }
                paintingDown = !paintingDown;
                currentX += lineLength;
                widthToPaint -= lineLength;
            }
        }
    }
}

