/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightFragmentsList;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedLine;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.util.Log;

public final class HighlightLayer {
    private final BasicEditorPane _editor;
    private final ArrayList _highlightList;
    private boolean _blockUpdating;
    private static final Log LOG = new Log("expiration");
    public static final int FETCH_ALL_HIGHLIGHTS = 0;
    public static final int FETCH_RANGE_HIGHLIGHTS = 1;
    public static final int FETCH_LINE_HIGHLIGHTS = 2;

    public HighlightLayer(BasicEditorPane editor) {
        this._editor = editor;
        this._blockUpdating = false;
        this._highlightList = new ArrayList();
    }

    public BasicEditorPane getEditor() {
        return this._editor;
    }

    public boolean hasHighlights() {
        return !this._highlightList.isEmpty();
    }

    public void destroy() {
        this._editor.destroyHighlightLayer(this);
    }

    public void beginBlockUpdate() {
        this._blockUpdating = true;
    }

    public void endBlockUpdate() {
        this._blockUpdating = false;
        this._editor.repaint();
    }

    public HighlightedText addHighlight(HighlightStyle style, int startOffset, int endOffset) {
        return this.addHighlight(style, startOffset, true, endOffset, false);
    }

    public HighlightedText addHighlight(HighlightStyle style, int startOffset, boolean startOffsetBias, int endOffset, boolean endOffsetBias) {
        TextBuffer textBuffer = this.getTextBuffer();
        OffsetMark startMark = textBuffer.addOffsetMark(startOffset, startOffsetBias);
        OffsetMark endMark = textBuffer.addOffsetMark(endOffset, endOffsetBias);
        HighlightedText ht = new HighlightedText(style, startMark, endMark);
        this._highlightList.add(ht);
        this.damageRangeForAddedHighlight(style, startOffset, endOffset);
        this._editor.firePropertyChange("highlight-text", null, ht);
        return ht;
    }

    public HighlightedText addLineHighlight(HighlightStyle style, int line) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        if (line < 0 || line >= lineMap.getLineCount()) {
            return null;
        }
        int lineStart = lineMap.getLineStartOffset(line);
        int lineEnd = lineMap.getLineEndOffset(line);
        OffsetMark startMark = textBuffer.addOffsetMark(lineStart);
        OffsetMark endMark = textBuffer.addOffsetMark(lineEnd);
        HighlightedLine ht = new HighlightedLine(style, startMark, endMark);
        this._highlightList.add(ht);
        this.damageRangeForAddedHighlight(style, lineStart, lineEnd);
        this._editor.firePropertyChange("highlight-text", null, ht);
        return ht;
    }

    public void removeHighlight(HighlightedText highlightedText) {
        assert (GraphicsEnvironment.isHeadless() || SwingUtilities.isEventDispatchThread());
        int highlightIndex = this._highlightList.indexOf(highlightedText);
        if (highlightIndex != -1) {
            this._highlightList.remove(highlightIndex);
            TextBuffer textBuffer = this.getTextBuffer();
            int startOffset = highlightedText.startMark.getOffset();
            int endOffset = highlightedText.endMark.getOffset();
            textBuffer.removeOffsetMark(highlightedText.startMark);
            highlightedText.startMark = null;
            textBuffer.removeOffsetMark(highlightedText.endMark);
            highlightedText.endMark = null;
            HighlightStyle style = highlightedText.getHighlightStyle();
            this.damageRangeForRemovedHighlight(style, startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHighlights() {
        if (this._highlightList.isEmpty()) {
            return;
        }
        int startOffset = 0;
        int endOffset = 0;
        int listSize = 0;
        TextBuffer textBuffer = this.getTextBuffer();
        try {
            textBuffer.readLock();
            startOffset = textBuffer.getLength();
            endOffset = 0;
            listSize = this._highlightList.size();
            for (int i = 0; i < listSize; ++i) {
                HighlightedText highlightedText = (HighlightedText)this._highlightList.get(i);
                startOffset = Math.min(startOffset, highlightedText.startMark.getOffset());
                endOffset = Math.max(endOffset, highlightedText.endMark.getOffset());
                textBuffer.removeOffsetMark(highlightedText.startMark);
                highlightedText.startMark = null;
                textBuffer.removeOffsetMark(highlightedText.endMark);
                highlightedText.endMark = null;
            }
        }
        catch (ExpiredTextBufferException e) {
            LOG.trace("handled expiration in HighlightLayer.removeAllHighlights: {0}", (Object)e);
        }
        finally {
            textBuffer.readUnlock();
        }
        this._highlightList.clear();
        if (listSize > 0) {
            this.damageRange(startOffset, endOffset);
            this._editor.firePropertyChange("highlight-text", null, null);
        }
    }

    public void changeLineHighlight(HighlightedText highlightedLine, HighlightStyle newHighlightStyle, int newLine) {
        LineMap lineMap = this.getLineMap();
        if (newLine < 0 || newLine >= lineMap.getLineCount()) {
            return;
        }
        int highlightIndex = this._highlightList.indexOf(highlightedLine);
        if (highlightIndex != -1) {
            int startOffset = highlightedLine.startMark.getOffset();
            int endOffset = highlightedLine.endMark.getOffset();
            int newStartOffset = lineMap.getLineStartOffset(newLine);
            int newEndOffset = lineMap.getLineEndOffset(newLine);
            highlightedLine.startMark.setOffset(newStartOffset);
            highlightedLine.endMark.setOffset(newEndOffset);
            int damageStart = Math.min(startOffset, newStartOffset);
            int damageEnd = Math.max(endOffset, newEndOffset);
            highlightedLine.highlightStyle = newHighlightStyle;
            HighlightStyle style = highlightedLine.getHighlightStyle();
            this.damageRangeForRemovedHighlight(style, damageStart, damageEnd);
        }
    }

    public void changeHighlight(HighlightedText highlightedText, HighlightStyle newHighlightStyle) {
        int highlightIndex = this._highlightList.indexOf(highlightedText);
        if (highlightIndex != -1) {
            highlightedText.highlightStyle = newHighlightStyle;
            int startOffset = highlightedText.startMark.getOffset();
            int endOffset = highlightedText.endMark.getOffset();
            this.damageRange(startOffset, endOffset);
            this._editor.firePropertyChange("highlight-text", null, highlightedText);
        }
    }

    public void changeHighlight(HighlightedText highlightedText, int newStartOffset, int newEndOffset) {
        int highlightIndex = this._highlightList.indexOf(highlightedText);
        if (highlightIndex != -1) {
            int startOffset = highlightedText.startMark.getOffset();
            int endOffset = highlightedText.endMark.getOffset();
            if (highlightedText.isLineHighlight()) {
                LineMap lineMap = this.getLineMap();
                int line = lineMap.getLineFromOffset(newStartOffset);
                newStartOffset = lineMap.getLineStartOffset(line);
                newEndOffset = lineMap.getLineEndOffset(line);
            }
            highlightedText.startMark.setOffset(newStartOffset);
            highlightedText.endMark.setOffset(newEndOffset);
            int damageStart = Math.min(startOffset, newStartOffset);
            int damageEnd = Math.max(endOffset, newEndOffset);
            HighlightStyle style = highlightedText.getHighlightStyle();
            this.damageRangeForRemovedHighlight(style, damageStart, damageEnd);
        }
    }

    public void changeHighlight(HighlightedText highlightedText, HighlightStyle newHighlightStyle, int newStartOffset, int newEndOffset) {
        int highlightIndex = this._highlightList.indexOf(highlightedText);
        if (highlightIndex != -1) {
            int startOffset = highlightedText.startMark.getOffset();
            int endOffset = highlightedText.endMark.getOffset();
            if (highlightedText.isLineHighlight()) {
                LineMap lineMap = this.getLineMap();
                int line = lineMap.getLineFromOffset(newStartOffset);
                newStartOffset = lineMap.getLineStartOffset(line);
                newEndOffset = lineMap.getLineEndOffset(line);
            }
            highlightedText.highlightStyle = newHighlightStyle;
            highlightedText.startMark.setOffset(newStartOffset);
            highlightedText.endMark.setOffset(newEndOffset);
            startOffset = Math.min(startOffset, newStartOffset);
            endOffset = Math.max(endOffset, newEndOffset);
            this.damageRange(startOffset, endOffset);
            this._editor.firePropertyChange("highlight-text", null, highlightedText);
        }
    }

    public void renderHighlights(HighlightFragmentsList fragmentsList, int startOffset, int endOffset) {
        this.renderHighlights(fragmentsList, 0, startOffset, endOffset);
    }

    public void renderHighlights(HighlightFragmentsList fragmentsList, int fetchPolicy, int startOffset, int endOffset) {
        TextBuffer textBuffer = this.getTextBuffer();
        LineMap lineMap = this.getLineMap();
        int lastOffset = textBuffer.getLength();
        int lastLine = lineMap.getLineCount() - 1;
        int lastLineStart = lineMap.getLineStartOffset(lastLine);
        int listSize = this._highlightList.size();
        for (int i = 0; i < listSize; ++i) {
            boolean isRangeHighlight;
            HighlightedText highlight = (HighlightedText)this._highlightList.get(i);
            int highlightStart = highlight.getStartOffset();
            int highlightEnd = highlight.getEndOffset();
            boolean isLineHighlight = highlight.isLineHighlight();
            boolean bl = isRangeHighlight = !isLineHighlight;
            if (fetchPolicy == 1 && isLineHighlight || fetchPolicy == 2 && isRangeHighlight) continue;
            if (highlightStart >= startOffset && highlightStart <= endOffset || highlightEnd >= startOffset && highlightEnd <= endOffset || startOffset >= highlightStart && startOffset <= highlightEnd) {
                fragmentsList.add(highlight.getHighlightStyle(), highlightStart, highlightEnd);
            }
            if (!isLineHighlight || highlightStart != lastLineStart || highlightEnd != lastOffset) continue;
            fragmentsList.addSentinel(highlight.getHighlightStyle());
        }
    }

    private TextBuffer getTextBuffer() {
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        return textBuffer;
    }

    private LineMap getLineMap() {
        BasicDocument document = (BasicDocument)this._editor.getDocument();
        LineMap lineMap = document.getLineMap();
        return lineMap;
    }

    private void damageRange(int startOffset, int endOffset) {
        if (!this._blockUpdating) {
            TextUI mapper = this._editor.getUI();
            mapper.damageRange(this._editor, startOffset, endOffset);
        }
    }

    private HighlightStyle findConfiguredStyle(String styleName) {
        HighlightRegistry registry = this._editor.getHighlightRegistry();
        HighlightStyle style = registry.lookupStyle(styleName);
        return style;
    }

    private void damageRangeForAddedHighlight(HighlightStyle style, int startOffset, int endOffset) {
        if (!this._blockUpdating) {
            String styleName = style.getName();
            HighlightStyle realStyle = this.findConfiguredStyle(styleName);
            if (realStyle == null) {
                System.err.println("Highlight not found: " + styleName);
            } else if (realStyle.getEnabled()) {
                this.damageRange(startOffset, endOffset);
            }
        }
    }

    private void damageRangeForRemovedHighlight(HighlightStyle style, int startOffset, int endOffset) {
        if (style == null) {
            return;
        }
        if (!this._blockUpdating) {
            String styleName = style.getName();
            HighlightStyle realStyle = this.findConfiguredStyle(styleName);
            if (realStyle == null || !realStyle.getEnabled()) {
                return;
            }
            this.damageRange(startOffset, endOffset);
            this._editor.firePropertyChange("highlight-text", null, null);
        }
    }
}

