/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.highlight;

import java.awt.Color;
import java.awt.Graphics;
import oracle.javatools.editor.highlight.SimpleLinePainter;

public class DottedLinePainter
extends SimpleLinePainter {
    public static final int MAX_WIDTH = 6;
    public static final int MIN_WIDTH = 1;
    protected final int _dottedWidth;
    protected final int _gapWidth;

    public DottedLinePainter(int thickness, int underlineType, int dottedWidth, int gapWidth) {
        super(thickness, underlineType);
        this._dottedWidth = Math.max(Math.min(dottedWidth, 6), 1);
        this._gapWidth = Math.max(Math.min(gapWidth, 6), 1);
    }

    @Override
    public void paintUnderline(Graphics graphics, Color color, int xPos, int width, int yTop, int yBaseline, int descent) {
        int yPos = this.getYPos(yTop, yBaseline, descent);
        graphics.setColor(color);
        boolean paintingLine = true;
        int widthToPaint = width;
        int currentX = xPos;
        while (widthToPaint > 0) {
            if (paintingLine) {
                int lineWidth = Math.min(widthToPaint, this._dottedWidth);
                graphics.fillRect(currentX, yPos, lineWidth, this._thickness);
                widthToPaint -= lineWidth;
                currentX += lineWidth;
            } else {
                widthToPaint -= this._gapWidth;
                currentX += this._gapWidth;
            }
            paintingLine = !paintingLine;
        }
    }
}

