/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Timer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.resource.BundleHelper;

public final class FoldingFader {
    private static final int TIMER_DELAY = 15;
    private static final int TIMER_INITIAL_DELAY = 150;
    public static final int EXPANSION_HIGHLIGHT_PRIORITY = 100;
    public static final String EXPANSION_HIGHLIGHT_NAME = "folding-fade-highlight";
    private int step = 0;
    private static final int MAX_STEP = 20;
    private HighlightedText highLightedText;
    private HighlightLayer layer;
    private Timer timer;
    private BasicEditorPane editorPane;
    private Object block;
    private CodeFoldingModel model;
    private static boolean _rebuildRequired = false;
    private static HighlightStyle prevStyle;
    private static HashMap<Object, FoldingFader> faderCache;

    public static void registerHighlights() {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        BundleHelper resources = EditorProperties.getEditorBundle();
        registry.createStyle(EXPANSION_HIGHLIGHT_NAME, resources.getString("FOLDED_FADE_HIGHLIGHT"), true, 100, null, new Color(222, 222, 255));
    }

    private FoldingFader(CodeFoldingModel model, Object block, int[] offsets, BasicEditorPane editorPane) {
        try {
            this.model = model;
            this.block = block;
            this.editorPane = editorPane;
            this.layer = editorPane.createHighlightLayer();
            this.checkForStyleChange();
            HighlightStyle style = this.getFadeStyleForStep(this.step);
            this.highLightedText = this.layer.addHighlight(style, offsets[0], offsets[1]);
            this.timer = new Timer(15, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!FoldingFader.this.editorPane.isShowing() || FoldingFader.this.isAnyParentFolded(FoldingFader.this.block)) {
                        FoldingFader.this.disposeFader();
                        return;
                    }
                    HighlightStyle style = FoldingFader.this.getFadeStyleForStep(FoldingFader.this.step);
                    FoldingFader.this.layer.changeHighlight(FoldingFader.this.highLightedText, style);
                    FoldingFader.this.step++;
                    if (FoldingFader.this.step >= 20) {
                        FoldingFader.this.disposeFader();
                        _rebuildRequired = false;
                    }
                }
            });
            this.timer.setRepeats(true);
            this.timer.setInitialDelay(150);
            this.timer.setCoalesce(false);
            this.timer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkForStyleChange() {
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        HighlightStyle regStyle = highlightRegistry.lookupStyle(EXPANSION_HIGHLIGHT_NAME);
        if (prevStyle == null || !regStyle.equals(prevStyle)) {
            _rebuildRequired = true;
        }
        prevStyle = regStyle;
    }

    private HighlightStyle getFadeStyleForStep(int step) {
        String nameForHue;
        HighlightRegistry highlightRegistry = EditorProperties.getProperties().getHighlightRegistry();
        HighlightStyle style = highlightRegistry.lookupStyle(nameForHue = "folding-fade-highlight-" + step);
        if (style == null || _rebuildRequired) {
            Color bg;
            HighlightStyle fadeStyle = highlightRegistry.lookupStyle(EXPANSION_HIGHLIGHT_NAME);
            float ratioComplete = (float)step / 20.0f;
            Color fg = fadeStyle.getForegroundColor() == null ? null : this._getIntermediateColor(fadeStyle.getForegroundColor(), ratioComplete);
            Color color = bg = fadeStyle.getBackgroundColor() == null ? null : this._getIntermediateColor(fadeStyle.getBackgroundColor(), ratioComplete);
            if (style == null) {
                style = highlightRegistry.createTransientStyle(nameForHue, true, 100, fg, bg, fadeStyle.getFontStyle(), HighlightRegistry.lookupPredefinedPainter(fadeStyle.getUnderlinePainter()), fadeStyle.getUnderlineColor());
            } else {
                highlightRegistry.modifyStyle(nameForHue, true, 100, fg, bg, fadeStyle.getFontStyle(), HighlightRegistry.lookupPredefinedPainter(fadeStyle.getUnderlinePainter()), fadeStyle.getUnderlineColor());
            }
        }
        return style;
    }

    private Color _getIntermediateColor(Color color, float ratio) {
        int alpha = 255 - (int)Math.min(255.0f, Math.max(0.0f, 255.0f * ratio));
        Color c = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        return c;
    }

    private boolean isAnyParentFolded(Object block) {
        Object parent = this.model.getParent(block);
        if (parent == null) {
            return false;
        }
        if (!this.model.isExpanded(parent)) {
            return true;
        }
        return this.isAnyParentFolded(parent);
    }

    private void disposeFader() {
        this.timer.stop();
        faderCache.remove(this.block);
        this.layer.removeAllHighlights();
        this.editorPane.destroyHighlightLayer(this.layer);
        this.editorPane = null;
        this.layer = null;
        this.highLightedText = null;
        this.timer = null;
        this.model = null;
    }

    public static void fadeBlock(CodeFoldingModel model, Object block, int[] offsets, BasicEditorPane editorPane) {
        if (faderCache.containsKey(block)) {
            FoldingFader cachedFader = faderCache.get(block);
            cachedFader.disposeFader();
            faderCache.remove(block);
        }
        FoldingFader fader = new FoldingFader(model, block, offsets, editorPane);
        faderCache.put(block, fader);
    }

    static {
        faderCache = new HashMap();
    }
}

