/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.folding;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.event.DocumentEvent;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.editor.plugins.AbstractEditorPlugin;
import oracle.javatools.util.Log;

public abstract class AbstractCodeFoldingPlugin<B>
extends AbstractEditorPlugin {
    private CodeFoldingProvider<B> provider;
    private CodeFoldingMargin<B> margin;
    private BasicDocument.PrePostDocumentListener documentHandler;
    private boolean compoundEditInProgress;
    private static final Log LOG = new Log("compound-edit");

    @Override
    protected void installImpl(BasicEditorPane editorPane) {
        if (this.isMarginEnabled()) {
            this.attach(editorPane);
        }
    }

    @Override
    protected void deinstallImpl(BasicEditorPane editorPane) {
        if (this.margin.isVisible()) {
            this.detach(editorPane);
        }
        this.provider = null;
        this.margin = null;
    }

    @Override
    protected void propertyChangeImpl(PropertyChangeEvent e) {
        CodeFoldingMargin<B> margin = this.getMargin();
        if (margin == null) {
            return;
        }
        String propertyName = e.getPropertyName();
        if (propertyName.equals("editor-font") || propertyName.equals("trailing-blank-rows") || propertyName.equals("code-folding-highlight") || propertyName.equals("code-folding-enabled")) {
            margin.repaint();
        } else if (propertyName.equals("right-margin-color")) {
            Color fg = (Color)e.getNewValue();
            margin.setForeground(fg);
        } else if (propertyName.equals("code-folding-margin-visible")) {
            BasicEditorPane editorPane = (BasicEditorPane)e.getSource();
            boolean isVisible = (Boolean)e.getNewValue();
            if (isVisible) {
                this.attach(editorPane);
            } else {
                this.detach(editorPane);
            }
            margin.setVisible(isVisible);
        }
    }

    public void beginCompoundEdit(CodeFoldingModel<B> model) {
    }

    public void endCompoundEdit(CodeFoldingModel<B> model) {
    }

    protected abstract CodeFoldingProvider<B> createProvider();

    protected void attach(BasicEditorPane editorPane) {
        CodeFoldingMargin<B> margin = this.getMargin();
        margin.attach(editorPane);
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        this.documentHandler = this.createPrePostDocumentListener();
        if (this.documentHandler != null) {
            document.addPrePostDocumentListener(this.documentHandler);
        }
        this.compoundEditInProgress = false;
    }

    protected void detach(BasicEditorPane editorPane) {
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        if (this.documentHandler != null) {
            document.removePrePostDocumentListener(this.documentHandler);
            this.documentHandler = null;
        }
        CodeFoldingMargin<B> margin = this.getMargin();
        margin.detach(editorPane);
        this.compoundEditInProgress = false;
    }

    protected boolean isMarginEnabled() {
        EditorProperties properties = EditorProperties.getProperties();
        return properties.getBooleanProperty("code-folding-margin-visible");
    }

    protected CodeFoldingModel<B> getModel() {
        CodeFoldingMargin<B> margin = this.getMargin();
        return margin.getModel();
    }

    protected void setModel(CodeFoldingModel<B> model) {
        CodeFoldingMargin<B> margin = this.getMargin();
        margin.setModel(model);
    }

    protected CodeFoldingProvider<B> getProvider() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider;
    }

    protected CodeFoldingMargin<B> getMargin() {
        if (this.margin == null) {
            this.margin = this.createMargin();
        }
        return this.margin;
    }

    protected CodeFoldingMargin<B> createMargin() {
        return new CodeFoldingMargin<B>(this.getProvider());
    }

    protected BasicDocument.PrePostDocumentListener createPrePostDocumentListener() {
        return new DocumentHandler();
    }

    protected class DocumentHandler
    implements BasicDocument.PrePostDocumentListener {
        protected DocumentHandler() {
        }

        @Override
        public void preNotify(DocumentEvent event) {
            if (event.getType() == DocumentEvent.EventType.INSERT) {
                AbstractCodeFoldingPlugin.this.getProvider().insertUpdate(AbstractCodeFoldingPlugin.this.getModel(), event.getOffset(), event.getLength());
            } else if (event.getType() == DocumentEvent.EventType.REMOVE) {
                AbstractCodeFoldingPlugin.this.getProvider().removeUpdate(AbstractCodeFoldingPlugin.this.getModel(), event.getOffset(), event.getLength());
            }
        }

        @Override
        public void postNotify(DocumentEvent event) {
            if (AbstractCodeFoldingPlugin.this.compoundEditInProgress) {
                return;
            }
            AbstractCodeFoldingPlugin.this.getMargin().repaint();
        }

        @Override
        public void preNotify(PropertyChangeEvent event) {
            AbstractCodeFoldingPlugin.this.compoundEditInProgress = (Boolean)event.getNewValue();
            LOG.trace("code folding plugin preNotify compound-edit-in-progress {0}", AbstractCodeFoldingPlugin.this.compoundEditInProgress);
            if (AbstractCodeFoldingPlugin.this.compoundEditInProgress) {
                AbstractCodeFoldingPlugin.this.getProvider().beginCompoundEdit(AbstractCodeFoldingPlugin.this.getModel());
            } else {
                AbstractCodeFoldingPlugin.this.getProvider().endCompoundEdit(AbstractCodeFoldingPlugin.this.getModel());
            }
        }

        @Override
        public void postNotify(PropertyChangeEvent event) {
            AbstractCodeFoldingPlugin.this.compoundEditInProgress = (Boolean)event.getNewValue();
            LOG.trace("code folding plugin postNotify compound-edit-in-progress {0}", AbstractCodeFoldingPlugin.this.compoundEditInProgress);
            if (!AbstractCodeFoldingPlugin.this.compoundEditInProgress) {
                AbstractCodeFoldingPlugin.this.getMargin().repaint();
            }
        }
    }
}

