/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WeakPropertyChangeSupport {
    private transient Object source;
    private transient List<WeakReference<PropertyChangeListener>> listeners = new CopyOnWriteArrayList<WeakReference<PropertyChangeListener>>();

    public WeakPropertyChangeSupport(Object source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        List<WeakReference<PropertyChangeListener>> list = this.listeners;
        synchronized (list) {
            for (WeakReference<PropertyChangeListener> reference : this.listeners) {
                if (reference.get() != listener) continue;
                return;
            }
            this.listeners.add(new WeakReference<PropertyChangeListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        List<WeakReference<PropertyChangeListener>> list = this.listeners;
        synchronized (list) {
            for (WeakReference<PropertyChangeListener> reference : this.listeners) {
                if (reference.get() != listener) continue;
                reference.clear();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(PropertyChangeEvent event) {
        boolean compact = false;
        for (WeakReference<PropertyChangeListener> reference : this.listeners) {
            PropertyChangeListener listener = (PropertyChangeListener)reference.get();
            if (listener == null) {
                compact = true;
                continue;
            }
            try {
                listener.propertyChange(event);
            }
            catch (RuntimeException e) {
                Logger logger = Logger.getLogger(WeakPropertyChangeSupport.class.getName());
                logger.log(Level.SEVERE, "Exception thrown by PropertyChangeListener " + listener + " for " + event, e);
            }
        }
        if (compact) {
            List<WeakReference<PropertyChangeListener>> list = this.listeners;
            synchronized (list) {
                ArrayList<WeakReference<PropertyChangeListener>> copy = new ArrayList<WeakReference<PropertyChangeListener>>(this.listeners.size());
                for (WeakReference<PropertyChangeListener> reference : this.listeners) {
                    PropertyChangeListener listener = (PropertyChangeListener)reference.get();
                    if (listener == null) continue;
                    copy.add(reference);
                }
                this.listeners = new CopyOnWriteArrayList<WeakReference<PropertyChangeListener>>(copy);
            }
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null ? newValue == null : oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        this.fireEvent(event);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue == null ? newValue == null : oldValue.equals(newValue)) {
            return;
        }
        this.fireEvent(event);
    }
}

