/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.TextAction;
import oracle.javatools.buffer.GuardedException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FeedbackManager;
import oracle.javatools.editor.MultiSelectionSupport;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.SmartIndentProvider;

public abstract class BasicAction
extends TextAction {
    protected final MultiSelectionBehavior multiSelectionBehavior;
    private static final int MESSAGE_DELAY = 3000;
    private static final String LAST_ACTION = "*last-action-executed*";
    private static String spacesCache = "                ";
    private static String tabsCache = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    public BasicAction(String actionName) {
        this(actionName, MultiSelectionBehavior.IGNORE);
    }

    public BasicAction(String actionName, MultiSelectionBehavior multiSelectionBehavior) {
        super(actionName);
        this.multiSelectionBehavior = multiSelectionBehavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
        Caret caret = editor.getCaret();
        MultiSelectionSupport.MultiSelection mSelection = new MultiSelectionSupport.MultiSelection(editor.getTextBuffer(), caret.getDot(), caret.getMark());
        try {
            this.actionPerformedOnSelection(event, editor, document, mSelection, true);
        }
        finally {
            mSelection.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        BasicEditorPane editor = (BasicEditorPane)this.getTextComponent(event);
        if (editor != null) {
            BasicDocument document = (BasicDocument)editor.getDocument();
            this.lock(document);
            try {
                if (this.actionSetup(event, editor, document)) {
                    if (this.multiSelectionBehavior == MultiSelectionBehavior.PERFORM) {
                        this.actionPerformMulti(event, editor, document);
                    } else {
                        this.actionPerformed(event, editor, document);
                    }
                }
                this.actionTakedown(event, editor, document);
            }
            catch (GuardedException ge) {
                throw ge;
            }
            catch (RuntimeException e) {
                System.out.println("Warning, runtime exception caught: " + e);
                e.printStackTrace();
            }
            finally {
                this.unlock(document);
            }
            this.setLastAction(editor, this);
        }
    }

    public void actionPerformMulti(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
        this.actionPerformMultiForSelections(event, editor, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionPerformMultiForSelections(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
        editor.getMultiSelectionSupport().setIsAdjusting(true);
        try {
            Caret caret = editor.getCaret();
            MultiSelectionSupport.MultiSelection mSelection = new MultiSelectionSupport.MultiSelection(editor.getTextBuffer(), caret.getDot(), caret.getMark());
            try {
                this.actionPerformedOnSelection(event, editor, document, mSelection, true);
            }
            finally {
                mSelection.dispose();
            }
            for (MultiSelectionSupport.MultiSelection sel : editor.getMultiSelectionSupport().getMultiSelections()) {
                this.actionPerformedOnSelection(event, editor, document, sel, false);
            }
        }
        finally {
            editor.getMultiSelectionSupport().setIsAdjusting(false);
        }
    }

    public void actionPerformedOnSelection(ActionEvent event, BasicEditorPane editor, BasicDocument document, MultiSelectionSupport.MultiSelection selection, boolean isPrimarySelection) {
    }

    protected boolean actionSetup(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
        if (this.multiSelectionBehavior == MultiSelectionBehavior.REJECT && !editor.getMultiSelections().isEmpty()) {
            BasicAction.beep(editor);
            return false;
        }
        return true;
    }

    protected void actionTakedown(ActionEvent event, BasicEditorPane editor, BasicDocument document) {
    }

    protected void lock(BasicDocument document) {
        document.readLock();
    }

    protected void unlock(BasicDocument document) {
        document.readUnlock();
    }

    protected final String getName() {
        return this.getValue("Name").toString();
    }

    public final BasicAction getLastAction(BasicEditorPane editor) {
        Object lastAction = editor.getProperty(LAST_ACTION);
        return lastAction == null ? null : (BasicAction)lastAction;
    }

    private void setLastAction(BasicEditorPane editor, BasicAction action) {
        editor.putProperty(LAST_ACTION, action);
    }

    public static Point getMagicCaretPosition(BasicEditorPane editor) throws BadLocationException {
        Caret caret = editor.getCaret();
        int offset = caret.getDot();
        Point magicPosition = caret.getMagicCaretPosition();
        if (magicPosition == null) {
            Rectangle offsetRect = editor.modelToView(offset);
            magicPosition = new Point(offsetRect.x, offsetRect.y);
        }
        return magicPosition;
    }

    protected static Point getMagicCaretPosition(BasicEditorPane editor, MultiSelectionSupport.MultiSelection selection) throws BadLocationException {
        if (selection == null) {
            return BasicAction.getMagicCaretPosition(editor);
        }
        int offset = selection.getDot();
        Point magicPosition = selection.getMagicPosition();
        if (magicPosition == null) {
            Rectangle offsetRect = editor.modelToView(offset);
            magicPosition = new Point(offsetRect.x, offsetRect.y);
        }
        return magicPosition;
    }

    public static void setMagicCaretPosition(BasicEditorPane editor, Point magicPosition) {
        Caret caret = editor.getCaret();
        caret.setMagicCaretPosition(magicPosition);
    }

    protected static void setMagicCaretPosition(BasicEditorPane editor, Point magicPosition, MultiSelectionSupport.MultiSelection selection) {
        if (selection == null) {
            BasicAction.setMagicCaretPosition(editor, magicPosition);
        } else {
            selection.setMagicPosition(magicPosition);
        }
    }

    public static boolean isEditable(BasicEditorPane editor, boolean beepIfNotEditable) {
        if (editor.isEditable() && editor.isEnabled()) {
            return true;
        }
        if (beepIfNotEditable) {
            BasicAction.beep(editor);
        }
        return false;
    }

    public static void beep(BasicEditorPane editor) {
        editor.getToolkit().beep();
    }

    public static int getFontHeight(BasicEditorPane editor) {
        Font font = editor.getFont();
        FontMetrics metrics = editor.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        return fontHeight;
    }

    public static Rectangle getVisibleRect(BasicEditorPane editor) {
        Rectangle visibleRect = new Rectangle();
        editor.computeVisibleRect(visibleRect);
        return visibleRect;
    }

    public static void showMessage(BasicEditorPane editor, String message) {
        FeedbackManager feedbackManager = editor.getFeedbackManager();
        if (feedbackManager != null) {
            feedbackManager.showFeedback(editor, message, 3000);
        }
    }

    public static int getIndentSizeProperty(BasicEditorPane editor) {
        Integer indentSizeInt = (Integer)editor.getProperty("indent-size");
        return indentSizeInt;
    }

    public static int getTabSizeProperty(BasicEditorPane editor) {
        Integer tabSizeInt = (Integer)editor.getProperty("tab-size");
        return tabSizeInt;
    }

    public static boolean getUseAutoIndentProperty(BasicEditorPane editor) {
        Boolean useAutoIndentBool = (Boolean)editor.getProperty("use-auto-indent");
        return useAutoIndentBool;
    }

    public static SmartIndentProvider getSmartIndentProvider(BasicEditorPane editor, BasicDocument document) {
        boolean enabled;
        SmartIndentProvider provider;
        LanguageSupport support = document.getLanguageSupport();
        if (support != null && (provider = support.getSmartIndentProvider()) != null && (enabled = provider.isSmartIndentEnabled(editor))) {
            return provider;
        }
        return null;
    }

    public static boolean getUseTabsProperty(BasicEditorPane editor) {
        Boolean useTabsBool = (Boolean)editor.getProperty("use-tabs");
        return useTabsBool;
    }

    public static String getTab(boolean useTabs, int tabSize) {
        String tab = useTabs ? "\t" : BasicAction.getSpaces(tabSize);
        return tab;
    }

    public static String buildIndent(boolean useTabs, int tabSize, int numColumns) {
        if (numColumns <= 0) {
            return "";
        }
        if (!useTabs) {
            return BasicAction.getSpaces(numColumns);
        }
        int numTabs = numColumns / tabSize;
        int numSpaces = numColumns % tabSize;
        return BasicAction.getTabs(numTabs) + BasicAction.getSpaces(numSpaces);
    }

    public static int skipLeadingIndent(TextBuffer textBuffer, int lineStart, int lineEnd) {
        for (int offset = lineStart; offset < lineEnd; ++offset) {
            char c = textBuffer.getChar(offset);
            if (Character.isWhitespace(c)) continue;
            return offset;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpaces(int numSpaces) {
        String string = LAST_ACTION;
        synchronized (LAST_ACTION) {
            while (spacesCache.length() < numSpaces) {
                spacesCache = spacesCache + spacesCache;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return spacesCache.substring(0, numSpaces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTabs(int numTabs) {
        String string = LAST_ACTION;
        synchronized (LAST_ACTION) {
            while (tabsCache.length() < numTabs) {
                tabsCache = tabsCache + tabsCache;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tabsCache.substring(0, numTabs);
        }
    }

    static boolean makeEditable(BasicEditorPane editor) {
        return editor.makeEditable();
    }

    protected static enum MultiSelectionBehavior {
        PERFORM,
        IGNORE,
        REJECT;

    }
}

