/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.BaseOverview;

public abstract class SequenceCompareView
extends BaseCompareView {
    @Override
    protected void createOverviews() {
        if (this.getCompareMode() == CompareMode.TWO_WAY_COMPARE) {
            this._leftOverview = new OverviewComponent(this, ContributorKind.FIRST, ContributorKind.SECOND);
            this._rightOverview = new OverviewComponent(this, ContributorKind.SECOND, ContributorKind.FIRST);
        } else {
            this._leftOverview = new OverviewComponent(this, ContributorKind.FIRST, ContributorKind.ANCESTOR);
            this._rightOverview = new OverviewComponent(this, ContributorKind.SECOND, ContributorKind.ANCESTOR);
        }
    }

    @Override
    protected void initializeOverview(BaseOverview overview) {
        overview.setBorder(BorderFactory.createEmptyBorder(UIManager.getInt("ScrollBar.width"), 3, UIManager.getInt("ScrollBar.width"), 3));
        OverviewComponentMouseHandler handler = new OverviewComponentMouseHandler();
        overview.addMouseMotionListener(handler);
        overview.addMouseListener(handler);
    }

    protected SequenceCompareView() {
    }

    protected SequenceCompareView(CompareMode compareMode) {
        this(compareMode, CompareViewBias.RIGHT);
    }

    protected SequenceCompareView(CompareMode compareMode, CompareViewBias compareViewBias) {
        super(compareMode, compareViewBias);
    }

    @Override
    protected CompareModel createModel(CompareModel compareModel, CompareDifference[] differences) {
        SequenceCompareDifference[] differences0 = new SequenceCompareDifference[differences.length];
        System.arraycopy(differences, 0, differences0, 0, differences.length);
        return ((SequenceCompareModel)compareModel).createInstance((CompareDifference[])differences0);
    }

    protected Iterator getDiffBlockIterator() {
        DiffBlockIterator itr = new DiffBlockIterator();
        itr.reset();
        return itr;
    }

    private int getLineCount(ContributorKind contrib) {
        SequenceCompareContributor contributor = (SequenceCompareContributor)this.getContributor(contrib);
        return contributor != null ? contributor.getLength() : 0;
    }

    protected int getVirtualLineForReal(int line, ContributorKind contributor) {
        int virtualHeight = 0;
        int realHeight = 0;
        if (line == 0) {
            return 0;
        }
        Iterator i = this.getDiffBlockIterator();
        while (i.hasNext()) {
            SequenceCompareDifference thisBlock = (SequenceCompareDifference)i.next();
            virtualHeight += thisBlock.getMaxLength();
            if ((realHeight += thisBlock.getLength(contributor)) < line) continue;
            int delta = realHeight - line;
            return virtualHeight -= Math.min(delta, thisBlock.getLength(contributor));
        }
        return -1;
    }

    protected int getVirtualHeightLines(ContributorKind contributor) {
        int vHeight = 0;
        Iterator i = this.getDiffBlockIterator();
        while (i.hasNext()) {
            SequenceCompareDifference block = (SequenceCompareDifference)i.next();
            vHeight += contributor == null ? block.getMaxLength() : block.getLength(contributor);
        }
        return vHeight;
    }

    protected abstract Color getOverviewDifferenceColor(SequenceCompareDifference var1, boolean var2, ContributorKind var3, ContributorKind var4);

    public static class OverviewComponent
    extends BaseOverview {
        private final int SENSITIVITY_RADIUS = 10;
        protected final ContributorKind _firstContributorKind;
        protected final ContributorKind _secondContributorKind;
        private final SequenceCompareView _view;

        public OverviewComponent(SequenceCompareView view, ContributorKind firstContributorKind, ContributorKind secondContributorKind) {
            super(view);
            this._view = view;
            this.setPreferredSize(new Dimension(BaseCompareView.getOverviewWidth(), 10));
            ToolTipManager.sharedInstance().registerComponent(this);
            this._firstContributorKind = firstContributorKind;
            this._secondContributorKind = secondContributorKind;
        }

        @Override
        protected String getAccessibleDifferenceText(BaseCompareDifference difference) {
            SequenceCompareDifference diff = (SequenceCompareDifference)difference;
            if (diff.getKind() != 2) {
                return null;
            }
            int lineStart = diff.getStart(this._firstContributorKind);
            int lineEnd = lineStart + diff.getLength(this._firstContributorKind);
            return this.getDescription(diff, lineStart + 1, lineEnd - lineStart);
        }

        protected String getDescription(SequenceCompareDifference diff, int line, int lineCount) {
            ContributorKind secondKind;
            if (this._view.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                return null;
            }
            String type = "";
            ContributorKind firstKind = this._firstContributorKind == ContributorKind.FIRST ? this._firstContributorKind : this._secondContributorKind;
            ContributorKind contributorKind = secondKind = this._firstContributorKind == ContributorKind.FIRST ? this._secondContributorKind : this._firstContributorKind;
            if (this._view.isAddition((BaseCompareDifference)diff, firstKind, secondKind)) {
                type = this._view.getBundle().getString("ADDITION");
                lineCount = diff.getMaxLength();
            } else if (this._view.isRemoval((BaseCompareDifference)diff, firstKind, secondKind)) {
                type = this._view.getBundle().getString("DELETION");
                lineCount = diff.getMaxLength();
            } else if (diff.isChange(firstKind, secondKind)) {
                type = this._view.getBundle().getString("CHANGE");
            }
            String desc = lineCount > 1 ? MessageFormat.format(this._view.getBundle().getString("TIP_FORMAT_PLURAL"), type, line, lineCount) : MessageFormat.format(this._view.getBundle().getString("TIP_FORMAT_SINGULAR"), type, line, lineCount);
            return desc;
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            SequenceCompareDifference block;
            if (!this.isMasked() && (block = this.getDifferenceForPosition(me.getPoint())) != null) {
                if (this._firstContributorKind == ContributorKind.FIRST) {
                    return this.getDescription(block, this._firstContributorKind, this._secondContributorKind);
                }
                return this.getDescription(block, this._secondContributorKind, this._firstContributorKind);
            }
            return super.getToolTipText(me);
        }

        protected SequenceCompareDifference getDifferenceForPosition(Point p) {
            Insets insets = this.getInsets();
            int overviewHeight = this.getHeight() - insets.top - insets.bottom;
            int virtualHeight = this._view.getVirtualHeightLines(this._firstContributorKind);
            float vPixelsPerLine = (float)overviewHeight / (float)virtualHeight;
            int virtualYLine = 0;
            int closestRadius = Integer.MAX_VALUE;
            SequenceCompareDifference radiusDiff = null;
            Iterator i = this._view.getDiffBlockIterator();
            while (i.hasNext()) {
                SequenceCompareDifference thisBlock = (SequenceCompareDifference)i.next();
                int blockHeight = thisBlock.getLength(this._firstContributorKind);
                if (thisBlock.getKind() == 2) {
                    int y = (int)((float)virtualYLine * vPixelsPerLine) + insets.top;
                    int h = Math.max((int)((float)blockHeight * vPixelsPerLine), 1);
                    if (p.y >= y && p.y <= y + h) {
                        return thisBlock;
                    }
                    int currentRadius = Math.min(Math.abs(p.y - y), Math.abs(p.y - (y + h)));
                    if (currentRadius < closestRadius) {
                        closestRadius = currentRadius;
                        if (currentRadius <= 10) {
                            radiusDiff = thisBlock;
                        }
                    }
                }
                virtualYLine += thisBlock.getLength(this._firstContributorKind);
            }
            return radiusDiff;
        }

        private String getDescription(SequenceCompareDifference block, ContributorKind firstKind, ContributorKind secondKind) {
            if (this._view.getCompareMode() == CompareMode.THREE_WAY_MERGE) {
                return null;
            }
            if (this._view.isAddition((BaseCompareDifference)block, firstKind, secondKind)) {
                Object[] args = new String[]{String.valueOf(block.getStart(secondKind) + 1), this._view.getContributor(secondKind).getShortLabel(), String.valueOf(block.getLength(secondKind))};
                return "<html><p>" + MessageFormat.format(this._view.getBundle().getString("ADDITION_DESCRIPTION"), args) + "</p></html>";
            }
            if (block.isChange(firstKind, secondKind)) {
                Object[] args = new String[]{String.valueOf(block.getStart(firstKind) + 1), String.valueOf(block.getStart(firstKind) + block.getLength(firstKind)), this._view.getContributor(firstKind).getShortLabel(), String.valueOf(block.getStart(secondKind) + 1), String.valueOf(block.getStart(secondKind) + block.getLength(secondKind)), this._view.getContributor(secondKind).getShortLabel()};
                return "<html><p>" + MessageFormat.format(this._view.getBundle().getString("CHANGE_DESCRIPTION"), args) + "</p></html>";
            }
            if (block.isRemoval(firstKind, secondKind)) {
                Object[] args = new String[]{String.valueOf(block.getStart(firstKind) + 1), this._view.getContributor(firstKind).getShortLabel(), String.valueOf(block.getLength(firstKind))};
                return "<html><p>" + MessageFormat.format(this._view.getBundle().getString("REMOVAL_DESCRIPTION"), args) + "</p></html>";
            }
            return null;
        }

        @Override
        public void paint(Graphics g) {
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            if (height <= 0) {
                return;
            }
            g.setColor(this.getBackground());
            g.fillRect(insets.left, insets.right, width, height);
            this.paintFocus(g);
            if (this.isMasked()) {
                return;
            }
            g.translate(insets.left, insets.top);
            if (this._view.getCompareModel() != null) {
                int virtualHeight = this._view.getVirtualHeightLines(this._firstContributorKind);
                float vPixelsPerLine = (float)height / (float)virtualHeight;
                int virtualYLine = 0;
                Iterator i = this._view.getDiffBlockIterator();
                while (i.hasNext()) {
                    SequenceCompareDifference thisBlock = (SequenceCompareDifference)i.next();
                    int blockHeight = thisBlock.getLength(this._firstContributorKind);
                    if (thisBlock.getKind() == 2) {
                        Color darkerColor;
                        Color color;
                        int y = (int)((float)virtualYLine * vPixelsPerLine);
                        int h = Math.max((int)((float)blockHeight * vPixelsPerLine), 1);
                        Color blockColor = this._view.getOverviewDifferenceColor(thisBlock, this._firstContributorKind != ContributorKind.FIRST, this._firstContributorKind, this._secondContributorKind);
                        if (blockColor != null) {
                            color = blockColor;
                            darkerColor = color.darker();
                        } else {
                            color = Color.WHITE;
                            darkerColor = Color.BLACK;
                        }
                        if (h > 2) {
                            g.setColor(color);
                        } else {
                            g.setColor(darkerColor);
                        }
                        g.fillRect(0, y, width, h);
                        if (h > 2) {
                            g.setColor(darkerColor);
                            g.drawRect(0, y, width - 1, h);
                            g.drawRect(1, y + 1, width - 3, h - 2);
                        }
                        if (this.isFocusOwner() && this._view.getCurrentDifference() == thisBlock) {
                            g.setColor(UIManager.getColor("textHighlight"));
                            g.drawRect(0, y, width - 1, h);
                            g.drawRect(1, y + 1, width - 3, h - 2);
                        }
                    }
                    virtualYLine += thisBlock.getLength(this._firstContributorKind);
                }
            }
        }
    }

    public class OverviewComponentMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        @Override
        public void mouseReleased(MouseEvent me) {
            OverviewComponent component;
            SequenceCompareDifference block;
            if (me.getButton() == 1 && (block = (component = (OverviewComponent)me.getSource()).getDifferenceForPosition(me.getPoint())) != null) {
                SequenceCompareView.this.goToDifference((CompareDifference)block);
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            OverviewComponent component = (OverviewComponent)me.getSource();
            SequenceCompareDifference blockUnderCursor = component.getDifferenceForPosition(me.getPoint());
            if (blockUnderCursor == null) {
                component.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                component.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }

    private class DiffBlockIterator
    implements Iterator {
        private int _index = 0;
        private final SequenceCompareDifference _gapBlock = new SequenceCompareDifference(0);
        private SequenceCompareDifference _next = null;
        private SequenceCompareDifference _prev = this._gapBlock;

        private DiffBlockIterator() {
        }

        void reset() {
            this._index = SequenceCompareView.this.getCompareModel().getDifferences().length == 0 ? -1 : 0;
            this._gapBlock.setFirstStart(0);
            this._gapBlock.setFirstLength(0);
            this._gapBlock.setSecondStart(0);
            this._gapBlock.setSecondLength(0);
            this._gapBlock.setAncestorStart(0);
            this._gapBlock.setAncestorLength(0);
            this._next = null;
            if (this._index == -1) {
                this._gapBlock.setFirstLength(SequenceCompareView.this.getLineCount(ContributorKind.FIRST));
                this._gapBlock.setSecondLength(SequenceCompareView.this.getLineCount(ContributorKind.SECOND));
                this._gapBlock.setAncestorLength(SequenceCompareView.this.getLineCount(ContributorKind.ANCESTOR));
                this._next = this._gapBlock;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported");
        }

        @Override
        public boolean hasNext() {
            return this._next != null || this._index >= 0 && this._index < SequenceCompareView.this.getCompareModel().getDifferences().length;
        }

        public Object next() {
            if (this._next != null) {
                SequenceCompareDifference tmp = this._next;
                this._next = null;
                this._prev = tmp;
                return tmp;
            }
            SequenceCompareDifference current = (SequenceCompareDifference)SequenceCompareView.this.getCompareModel().getDifferences()[this._index];
            int firstDistance = current.getStart(ContributorKind.FIRST) - (this._prev.getStart(ContributorKind.FIRST) + this._prev.getLength(ContributorKind.FIRST));
            int secondDistance = current.getStart(ContributorKind.SECOND) - (this._prev.getStart(ContributorKind.SECOND) + this._prev.getLength(ContributorKind.SECOND));
            int ancestorDistance = current.getStart(ContributorKind.ANCESTOR) - (this._prev.getStart(ContributorKind.ANCESTOR) + this._prev.getLength(ContributorKind.ANCESTOR));
            if (firstDistance > 0 || secondDistance > 0 || ancestorDistance > 0) {
                this._gapBlock.setFirstStart(this._prev.getStart(ContributorKind.FIRST) + this._prev.getLength(ContributorKind.FIRST));
                this._gapBlock.setFirstLength(firstDistance);
                this._gapBlock.setSecondStart(this._prev.getStart(ContributorKind.SECOND) + this._prev.getLength(ContributorKind.SECOND));
                this._gapBlock.setSecondLength(secondDistance);
                this._gapBlock.setAncestorStart(this._prev.getStart(ContributorKind.ANCESTOR) + this._prev.getLength(ContributorKind.ANCESTOR));
                this._gapBlock.setAncestorLength(ancestorDistance);
                this._prev = this._gapBlock;
                return this._gapBlock;
            }
            if (this._index == SequenceCompareView.this.getCompareModel().getDifferences().length - 1) {
                this._gapBlock.setFirstStart(current.getStart(ContributorKind.FIRST) + current.getLength(ContributorKind.FIRST));
                this._gapBlock.setFirstLength(SequenceCompareView.this.getLineCount(ContributorKind.FIRST) - (current.getStart(ContributorKind.FIRST) + current.getLength(ContributorKind.FIRST)));
                this._gapBlock.setSecondStart(current.getStart(ContributorKind.SECOND) + current.getLength(ContributorKind.SECOND));
                this._gapBlock.setSecondLength(SequenceCompareView.this.getLineCount(ContributorKind.SECOND) - (current.getStart(ContributorKind.SECOND) + current.getLength(ContributorKind.SECOND)));
                this._gapBlock.setAncestorStart(current.getStart(ContributorKind.ANCESTOR) + current.getLength(ContributorKind.ANCESTOR));
                this._gapBlock.setAncestorLength(SequenceCompareView.this.getLineCount(ContributorKind.ANCESTOR) - (current.getStart(ContributorKind.ANCESTOR) + current.getLength(ContributorKind.ANCESTOR)));
                if (this._gapBlock.getLength(ContributorKind.SECOND) > 0 || this._gapBlock.getLength(ContributorKind.FIRST) > 0 || this._gapBlock.getLength(ContributorKind.ANCESTOR) > 0) {
                    this._next = this._gapBlock;
                }
            }
            this._prev = current;
            ++this._index;
            return current;
        }
    }
}

