/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.beans.PropertyChangeEvent;
import oracle.javatools.compare.CompareHighLite;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;

public class InlineCodeHighlighter
implements EditorPlugin {
    private HighlightLayer _hiliteLayer;

    @Override
    public void install(BasicEditorPane editor) {
        this._hiliteLayer = editor.createHighlightLayer();
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        if (this._hiliteLayer != null) {
            editor.destroyHighlightLayer(this._hiliteLayer);
            this._hiliteLayer = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void setHighlight(CompareHighLite[] highlite) {
        if (this._hiliteLayer == null) {
            return;
        }
        this._hiliteLayer.removeAllHighlights();
        if (highlite == null) {
            return;
        }
        for (CompareHighLite hl : highlite) {
            this._hiliteLayer.addHighlight(this.getStyle(hl.getStyle()), hl.getStartPos(), hl.getEndPos());
        }
    }

    private HighlightStyle getStyle(String style) {
        HighlightRegistry hr = EditorProperties.getProperties().getHighlightRegistry();
        return hr.lookupStyle(style);
    }
}

