/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.EditableContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.resource.CompareResource;

public final class CompareMain {
    private final File _firstFile;
    private final File _secondFile;
    private final File _ancestorFile;
    private final boolean _ignoreWhitespace;

    private CompareMain(String firstFile, String secondFile, boolean ignoreWhitespace) {
        this(firstFile, secondFile, null, ignoreWhitespace);
    }

    private CompareMain(String firstFile, String secondFile, String ancestorFile, boolean ignoreWhitespace) {
        this._firstFile = new File(firstFile);
        this._secondFile = new File(secondFile);
        this._ancestorFile = ancestorFile != null ? new File(ancestorFile) : null;
        this._ignoreWhitespace = ignoreWhitespace;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        if (args.length < 2) {
            System.err.println("You must specify two files to compare, or three files to merge.");
            System.err.println();
            System.err.println("Usage:");
            System.err.println("oradiff [-w] first-file second-file [ancestor-file]");
            System.exit(1);
        }
        boolean ignoreWhitespace = false;
        int argumentCount = args.length;
        if ("-w".equals(args[0])) {
            ignoreWhitespace = true;
            --argumentCount;
        }
        CompareMain main = null;
        main = new CompareMain(ignoreWhitespace ? args[1] : args[0], ignoreWhitespace ? args[2] : args[1], ignoreWhitespace);
        try {
            main.showCompare();
        }
        catch (CompareFailedException cfe) {
            System.err.println("Unable to compare files: " + cfe.getLocalizedMessage());
        }
    }

    private void showCompare() throws CompareFailedException {
        try {
            CompareModel model;
            if (this._firstFile.equals(this._secondFile)) {
                FileCompareContributor shared = new FileCompareContributor(this._firstFile, this._ignoreWhitespace);
                model = CompareModelFactory.createCompareModel((CompareContributor)shared, (CompareContributor)shared);
            } else {
                model = CompareModelFactory.createCompareModel((CompareContributor)new FileCompareContributor(this._firstFile, this._ignoreWhitespace), (CompareContributor)new FileCompareContributor(this._secondFile, this._ignoreWhitespace));
            }
            if (model.getDifferenceCount() == 0) {
                System.out.println("The two files are identical. Showing diff anyway (maybe I won't in future...)");
            }
            final JFrame frame = new JFrame("Oracle Diff");
            frame.setIconImage(this.getIcon("compare.gif").getImage());
            final CompareView view = CompareViewFactory.createCompareView(model);
            Component gui = view.getGUI();
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add(gui, "Center");
            frame.setDefaultCloseOperation(3);
            if (view instanceof BaseCompareView) {
                frame.getContentPane().add(((BaseCompareView)view).getHorizontalScrollComponent(), "South");
            }
            JMenuBar menuBar = new JMenuBar();
            menuBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlShadow")));
            JMenu fileMenu = new JMenu("File");
            menuBar.add(fileMenu);
            fileMenu.setMnemonic('F');
            final JMenuItem exit = new JMenuItem("Exit");
            exit.setAccelerator(KeyStroke.getKeyStroke("alt pressed F4"));
            fileMenu.add(exit);
            exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    exit.removeActionListener(this);
                    frame.setVisible(false);
                    frame.dispose();
                }
            });
            AbstractAction test = new AbstractAction("Test"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        if (CompareMain.this._ancestorFile == null) {
                            view.setModel(CompareModelFactory.createCompareModel((CompareContributor)new FileCompareContributor(new File("C:\\TestOne.java"), false), (CompareContributor)new FileCompareContributor(new File("C:\\TestTwo.java"), false)));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            fileMenu.add(test);
            frame.setJMenuBar(menuBar);
            if (view instanceof BaseCompareView) {
                this.installNavigableActions(frame, (BaseCompareView)view);
            }
            frame.pack();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(frame.getGraphicsConfiguration());
            int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - screenInsets.left - screenInsets.right;
            int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height - screenInsets.top - screenInsets.bottom;
            int myWidth = (int)((double)screenWidth * 0.7);
            int myHeight = (int)((double)screenHeight * 0.7);
            frame.setBounds((screenWidth - myWidth) / 2, (screenHeight - myHeight) / 2, myWidth, myHeight);
            frame.setVisible(true);
            frame.toFront();
            if (view instanceof BaseCompareView) {
                ((BaseCompareView)view).goToFirstDifference();
            }
        }
        catch (IOException ioe) {
            System.err.println("An error occurred comparing the two files.");
            ioe.printStackTrace();
        }
    }

    private void installNavigableActions(JFrame frame, final BaseCompareView view) {
        AbstractAction firstDiff = new AbstractAction("Go to First Difference", this.getIcon("compare_first.gif")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                view.goToFirstDifference();
            }
        };
        firstDiff.putValue("ShortDescription", "Go to First Difference");
        firstDiff.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed HOME"));
        AbstractAction lastDiff = new AbstractAction("Go to Last Difference", this.getIcon("compare_last.gif")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                view.goToLastDifference();
            }
        };
        lastDiff.putValue("ShortDescription", "Go to Last Difference");
        lastDiff.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed END"));
        AbstractAction nextDiff = new AbstractAction("Go to Next Difference", this.getIcon("compare_next.gif")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!view.goToNextDifference()) {
                    view.goToFirstDifference();
                }
            }
        };
        nextDiff.putValue("ShortDescription", "Go to Next Difference");
        nextDiff.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed RIGHT"));
        AbstractAction prevDiff = new AbstractAction("Go to Previous Difference", this.getIcon("compare_prev.gif")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!view.goToPreviousDifference()) {
                    view.goToLastDifference();
                }
            }
        };
        prevDiff.putValue("ShortDescription", "Go to Previous Difference");
        prevDiff.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed LEFT"));
        JMenu compareMenu = new JMenu("Compare");
        compareMenu.setMnemonic('C');
        frame.getJMenuBar().add(compareMenu);
        compareMenu.add(firstDiff);
        compareMenu.add(prevDiff);
        compareMenu.add(nextDiff);
        compareMenu.add(lastDiff);
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlShadow")));
        toolBar.add(firstDiff);
        toolBar.add(prevDiff);
        toolBar.add(nextDiff);
        toolBar.add(lastDiff);
        frame.getContentPane().add((Component)toolBar, "North");
    }

    private ImageIcon getIcon(String name) {
        return new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/" + name));
    }

    public static class FileCompareContributor
    extends TextCompareContributor
    implements EditableContributor {
        private final File _file;
        private final TextBuffer _textBuffer;
        private final String _type;
        private final boolean _editable;

        public FileCompareContributor(File file, boolean ignoreWhitespace) throws IOException {
            this.setIgnoreWhitespace(ignoreWhitespace);
            this._file = file;
            this._textBuffer = TextBufferFactory.createTextBuffer();
            this._textBuffer.read((Reader)new FileReader(file));
            this._textBuffer.clearModified();
            this._editable = file.canWrite();
            int sepPos = this._file.getName().lastIndexOf(46);
            this._type = sepPos > 0 && sepPos < this._file.getName().length() - 2 ? this._file.getName().substring(sepPos + 1) : "";
            this.addTextBufferListeners();
        }

        public File getFile() {
            return this._file;
        }

        public TextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        public String getShortLabel() {
            return this._file.getName();
        }

        public String getLongLabel() {
            return this._file.getPath();
        }

        public String getType() {
            return this._type;
        }

        public boolean isEditable() {
            return this._editable;
        }

        public boolean isModified() {
            return this.getTextBuffer().isModified();
        }

        public void save() throws IOException {
            FileWriter fw = new FileWriter(this._file);
            this._textBuffer.write((Writer)fw);
            fw.close();
            this._textBuffer.clearModified();
        }
    }
}

