/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.columnlayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import oracle.javatools.columnlayout.LayoutComponent;

public class LayoutLeaf
implements LayoutComponent {
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private Component m_component;
    private Insets m_insets;
    private int m_columnSpan;
    private boolean m_isRowResizable;
    private boolean m_isColumnResizable;
    private int m_anchor;
    private int m_fill;

    public LayoutLeaf(Component component, Insets insets, int columnSpan, boolean isRowResizable, boolean isColumnResizable, int anchor, int fill) {
        if (component == null) {
            throw new IllegalArgumentException("Component was null");
        }
        if (columnSpan < 1) {
            throw new IllegalArgumentException("Component must span some columns");
        }
        this.m_component = component;
        this.m_insets = insets == null ? ZERO_INSETS : insets;
        this.m_columnSpan = columnSpan;
        this.m_isRowResizable = isRowResizable;
        this.m_isColumnResizable = isColumnResizable;
        this.m_anchor = anchor;
        this.m_fill = fill;
    }

    @Override
    public void areRowsResizable(boolean[] rowConstraints, int baseRow, int rowSpan) {
        if (rowSpan < 1) {
            throw new IllegalArgumentException("Row span is too small");
        }
        if (rowSpan == 1) {
            int n = baseRow;
            rowConstraints[n] = rowConstraints[n] | this.m_isRowResizable;
        }
    }

    @Override
    public void areColumnsResizable(boolean[] columnConstraints, int baseColumn) {
        if (this.m_columnSpan == 1) {
            int n = baseColumn;
            columnConstraints[n] = columnConstraints[n] | this.m_isColumnResizable;
        }
    }

    @Override
    public int getColumnCount() {
        return this.m_columnSpan;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public void addToPanel(Container container, int baseRow, int baseColumn, boolean[] rowConstraints, boolean[] columnConstraints, int rowSpan) {
        int right;
        boolean isRowResizable = this.checkResizable(this.m_isRowResizable, rowConstraints, baseRow, rowSpan);
        boolean isColumnResizable = this.checkResizable(this.m_isColumnResizable, columnConstraints, baseColumn, this.m_columnSpan);
        if (isColumnResizable || isRowResizable) {
            this.m_component = new ResizerPanel(this.m_component, this.m_anchor, this.m_isColumnResizable || this.m_fill == 2 || this.m_fill == 1, this.m_isRowResizable || this.m_fill == 3 || this.m_fill == 1, isColumnResizable, isRowResizable);
        }
        if (this.m_isRowResizable || isRowResizable) {
            switch (this.m_fill) {
                case 0: {
                    this.m_fill = 3;
                    break;
                }
                case 2: {
                    this.m_fill = 1;
                    break;
                }
            }
        }
        if (this.m_isColumnResizable || isColumnResizable) {
            switch (this.m_fill) {
                case 0: {
                    this.m_fill = 2;
                    break;
                }
                case 3: {
                    this.m_fill = 1;
                    break;
                }
            }
        }
        int top = baseRow == 0 ? 0 : this.m_insets.top;
        int left = baseColumn == 0 ? 0 : this.m_insets.left;
        int bottom = baseRow + rowSpan == rowConstraints.length ? 0 : this.m_insets.bottom;
        int endColumn = baseColumn + this.m_columnSpan;
        int n = right = endColumn == columnConstraints.length ? 0 : this.m_insets.right;
        if (top != this.m_insets.top || left != this.m_insets.left || bottom != this.m_insets.bottom || right != this.m_insets.right) {
            this.m_insets = new Insets(top, left, bottom, right);
        }
        container.add(this.m_component, new GridBagConstraints(baseColumn, baseRow, this.m_columnSpan, rowSpan, this.m_isColumnResizable && this.m_columnSpan == 1 ? 1.0 : 0.0, this.m_isRowResizable && rowSpan == 1 ? 1.0 : 0.0, this.m_anchor, this.m_fill, this.m_insets, 0, 0));
    }

    private boolean checkResizable(boolean componentResizable, boolean[] isResizable, int base, int span) {
        if (componentResizable) {
            return true;
        }
        for (int i = base + span - 1; i >= base; --i) {
            if (!isResizable[i]) continue;
            if (!componentResizable && span > 1) {
                throw new IllegalArgumentException("A fixed component cannot span a resizable row");
            }
            return true;
        }
        return false;
    }

    private static class ResizerPanel
    extends JPanel {
        private Component m_component;
        private boolean m_isHorizontallyResizable;
        private boolean m_isVerticallyResizable;
        private Dimension m_preferredSize;

        public ResizerPanel(Component component, int anchor, boolean isComponentHorizontallyResizable, boolean isComponentVerticallyResizable, boolean isHorizontallyResizable, boolean isVerticallyResizable) {
            int fill;
            this.m_component = component;
            this.m_isHorizontallyResizable = isHorizontallyResizable;
            this.m_isVerticallyResizable = isVerticallyResizable;
            this.m_preferredSize = this.m_component.getPreferredSize();
            int n = fill = isComponentHorizontallyResizable ? 2 : 0;
            if (isComponentVerticallyResizable) {
                fill ^= 3;
            }
            this.setLayout(new GridBagLayout());
            this.add(this.m_component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, anchor, fill, ZERO_INSETS, 0, 0));
        }

        @Override
        public Dimension getPreferredSize() {
            int height;
            Dimension size = this.m_component.getPreferredSize();
            int width = this.m_isHorizontallyResizable ? 0 : size.width;
            int n = height = this.m_isVerticallyResizable ? 0 : size.height;
            if (width != this.m_preferredSize.width || height != this.m_preferredSize.height) {
                this.m_preferredSize = new Dimension(width, height);
            }
            return this.m_preferredSize;
        }

        @Override
        public boolean isEnabled() {
            return this.m_component.isEnabled();
        }

        @Override
        public boolean isVisible() {
            return this.m_component.isVisible();
        }

        @Override
        public boolean isOpaque() {
            return this.m_component.isOpaque();
        }
    }
}

