/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.util.SortedMap;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class ShowKeyMap
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"KEYMAP", "KEYMA", "KEYM"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        ConsoleService.Editor editor = consoleService.getDefaultEditor();
        switch (editor) {
            case EMACS: {
                ctx.write("Keymap for emacs editor:\n\n");
                this.printKeyStrokes(ctx, consoleService.getKeyMapHelp(ConsoleService.KeyMapType.EMACS));
                break;
            }
            case VI: {
                ctx.write("Keymap for vi editor command mode (vicmd):\n\n");
                this.printKeyStrokes(ctx, consoleService.getKeyMapHelp(ConsoleService.KeyMapType.VI_COMMAND));
                ctx.write("\nKeymap for vi editor insert mode (viins):\n\n");
                this.printKeyStrokes(ctx, consoleService.getKeyMapHelp(ConsoleService.KeyMapType.VI_INSERT));
                ctx.write("\nKeymap for vi editor visual mode:\n\n");
                this.printKeyStrokes(ctx, consoleService.getKeyMapHelp(ConsoleService.KeyMapType.VISUAL));
            }
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private void printKeyStrokes(ScriptRunnerContext ctx, SortedMap<String, String> keyHelpMap) {
        for (String keySequence : keyHelpMap.keySet()) {
            ctx.write(String.format("%1$-20s%2$s\n", keySequence, keyHelpMap.get(keySequence)));
        }
    }
}

