/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.util.Logger;

public class ShowDrivers
extends CommandListener
implements IShowCommand {
    private static final String DRIVERS = "drivers";

    @Override
    public String[] getShowAliases() {
        return new String[]{DRIVERS};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        block19: {
            ArrayList<Object> individualAL = new ArrayList();
            String simpleClassPath = System.getProperty("java.class.path");
            try {
                individualAL = this.breakDown(simpleClassPath);
                ctx.write("\n");
                ctx.write("Drivers: " + Messages.getString("SHOW_DRIVERS_BY_SERVICE"));
                if (individualAL == null) break block19;
                HashSet<String> already = new HashSet<String>();
                for (String string : individualAL) {
                    if (already.contains(string)) continue;
                    already.add(string);
                    JarFile oneJar = null;
                    try {
                        oneJar = new JarFile(string);
                        ZipEntry zip = oneJar.getEntry("META-INF/services/java.sql.Driver");
                        if (zip == null) continue;
                        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
                        decoder.onMalformedInput(CodingErrorAction.REPORT);
                        BufferedReader br = new BufferedReader(new InputStreamReader(oneJar.getInputStream(zip), decoder));
                        String readLine = null;
                        while ((readLine = br.readLine()) != null) {
                            ctx.write(string + " " + readLine + "\n");
                        }
                    }
                    catch (IOException e) {
                        if (e instanceof FileNotFoundException) continue;
                        Logger.info(ShowDrivers.class, e);
                    }
                    finally {
                        try {
                            if (oneJar == null) continue;
                            oneJar.close();
                        }
                        catch (IOException ioe) {
                            Logger.info(ShowDrivers.class, ioe);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.info(ShowDrivers.class, e);
            }
        }
        Enumeration<Driver> driverEnum = DriverManager.getDrivers();
        ctx.write("\n");
        ctx.write(Messages.getString("SHOW_DRIVERS_BY_DRIVER_MANAGER"));
        if (driverEnum != null) {
            while (driverEnum.hasMoreElements()) {
                Driver jdbcDriver = driverEnum.nextElement();
                ctx.write(MessageFormat.format(Messages.getString("SHOW_DRIVERS_DISPLAY"), jdbcDriver.getClass().getName(), jdbcDriver.getMajorVersion() + "." + jdbcDriver.getMinorVersion()));
            }
        }
        try {
            ctx.getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    ArrayList<String> breakDown(String simpleClassPath) {
        String[] simpleSplit;
        ArrayList<String> retVal = new ArrayList<String>();
        for (String s : simpleSplit = simpleClassPath.split(File.pathSeparator)) {
            if (s.contains("*")) {
                this.expand(s, retVal);
                continue;
            }
            if (!s.endsWith(".jar")) continue;
            retVal.add(s);
        }
        return retVal;
    }

    void expand(String s, ArrayList<String> addHere) {
        block6: {
            int sep = s.lastIndexOf(File.separator);
            String isDir = null;
            Object stub = null;
            if (sep == -1) {
                isDir = ".";
                stub = s;
            } else {
                isDir = s.substring(0, sep);
                stub = s.substring(sep + 1);
            }
            if (!((String)stub).endsWith(".jar")) {
                stub = (String)stub + ".jar";
            }
            PathMatcher matcher = null;
            try {
                matcher = FileSystems.getDefault().getPathMatcher("glob:" + (String)stub);
                List candidateArr = Files.list(Paths.get(isDir, new String[0])).collect(Collectors.toList());
                for (Path candidate : candidateArr) {
                    Path candidateP = candidate;
                    if (!matcher.matches(candidateP.getFileName())) continue;
                    addHere.add(isDir + File.separator + candidateP.getFileName());
                }
            }
            catch (Exception nse) {
                if (nse instanceof NoSuchFileException || nse instanceof NotDirectoryException) break block6;
                Logger.info(ShowDrivers.class, nse);
            }
        }
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getSql().trim().equalsIgnoreCase(DRIVERS)) {
            this.handleShow(conn, ctx, cmd);
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

