/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.ssh;

import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedAcceptProvider;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.session.ClientSession;

public class SQLUserInteraction
implements UserInteraction {
    private ScriptRunnerContext ctx;

    public SQLUserInteraction(ScriptRunnerContext ctx) {
        this.ctx = ctx;
    }

    public boolean isInteractionAllowed(ClientSession session) {
        return true;
    }

    public void serverVersionInfo(ClientSession session, List<String> lines) {
        if (lines != null) {
            this.ctx.write("Extended server version info\n");
            for (String line : lines) {
                this.ctx.write(line);
                this.ctx.write("\n");
            }
        }
    }

    public void welcome(ClientSession session, String banner, String lang) {
        this.ctx.write(banner + "\n");
    }

    public String[] interactive(ClientSession session, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
        String[] result = new String[]{};
        if (prompt != null && prompt.length > 0) {
            this.ctx.write(instruction + "\n");
            result = new String[prompt.length];
            SQLCliPromptedAcceptProvider p = new SQLCliPromptedAcceptProvider();
            for (int i = 0; i < prompt.length; ++i) {
                result[i] = p.getPromptedField(this.ctx, prompt[i], echo[i]);
            }
        }
        return result;
    }

    public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
        SQLCliPromptedAcceptProvider p = new SQLCliPromptedAcceptProvider();
        return p.getPromptedField(this.ctx, prompt, true);
    }
}

