/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.util.InputOutputStreams;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public final class Wallet {
    private final Map<String, Credentials> credentialsMap = new HashMap<String, Credentials>();
    private final OracleWallet oraWallet;

    static Wallet createWallet(Path walletPath) throws IOException {
        try (InputStream is = Files.newInputStream(walletPath, new OpenOption[0]);){
            InputOutputStreams streams = InputOutputStreams.instance();
            byte[] buffered = streams.asByteArray(is);
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.setWalletArray(streams.asInputStream(buffered), null);
            Wallet wallet = new Wallet(oracleWallet);
            return wallet;
        }
    }

    static Wallet createEmptyWallet() {
        try {
            OracleWallet wallet = new OracleWallet();
            wallet.createSSO();
            return new Wallet(wallet);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Wallet createWallet(OracleWallet wallet) throws IOException {
        return new Wallet(wallet);
    }

    void writeWallet(OutputStream os) throws IOException {
        try (InputStream is = this.oraWallet.getWalletArray(true);){
            InputOutputStreams.instance().copy(is, os);
        }
    }

    private Wallet(OracleWallet oraWallet) throws IOException {
        this.oraWallet = oraWallet;
        try {
            OracleSecretStore store = oraWallet.getSecretStore();
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                String key = o.toString();
                if (!key.startsWith("oracle.security.client.connect_string")) continue;
                String suffix = key.substring("oracle.security.client.connect_string".length());
                try {
                    int idx = Integer.parseInt(suffix);
                    String serviceName = new String(store.getSecret(key));
                    this.credentialsMap.put(serviceName, new Credentials(store, idx));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (OracleSecretStoreException e) {
            throw new IOException(e);
        }
    }

    public Credentials getCredentials(String spec) {
        return this.credentialsMap.get(spec);
    }

    void updateCredentials(String spec, String username, char[] pwd) throws IOException {
        try {
            OracleSecretStore store = this.oraWallet.getSecretStore();
            Enumeration e = store.internalAliases();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                String key = o.toString();
                if (!key.startsWith("oracle.security.client.connect_string")) continue;
                String suffix = key.substring("oracle.security.client.connect_string".length());
                try {
                    int idx = Integer.parseInt(suffix);
                    String serviceName = new String(store.getSecret(key));
                    if (!ModelUtil.areEqual(serviceName, spec)) continue;
                    if (username != null && pwd != null) {
                        store.setSecret("oracle.security.client.username" + idx, username.toCharArray());
                        store.setSecret("oracle.security.client.password" + idx, pwd);
                        this.credentialsMap.put(spec, new Credentials(store, idx));
                        break;
                    }
                    store.deleteSecret("oracle.security.client.connect_string" + idx);
                    store.deleteSecret("oracle.security.client.username" + idx);
                    store.deleteSecret("oracle.security.client.password" + idx);
                    this.credentialsMap.remove(spec);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            this.oraWallet.setSecretStore(store);
        }
        catch (OracleSecretStoreException e) {
            throw new IOException(e);
        }
    }

    static {
        if (null == Security.getProvider("OraclePKI")) {
            Security.insertProviderAt((Provider)new OraclePKIProvider(), Integer.MAX_VALUE);
        }
    }

    public static final class Credentials {
        private final OracleSecretStore store;
        private final int index;

        private Credentials(OracleSecretStore store, int index) {
            this.store = store;
            this.index = index;
        }

        public String getUsername() {
            return new String(this.secret("oracle.security.client.username"));
        }

        public char[] password() {
            return this.secret("oracle.security.client.password");
        }

        private char[] secret(String prefix) {
            char[] secret;
            try {
                secret = this.store.getSecret(prefix + this.index);
            }
            catch (OracleSecretStoreException ex) {
                secret = new char[]{};
            }
            return secret;
        }
    }
}

