/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.storage;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.helpers.ConnectionHelper;
import oracle.dbtools.plusplus.connections.db.helpers.ConnectionHelperFactory;
import oracle.dbtools.plusplus.connections.db.storage.ConnectionStorage;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.plusplus.connections.db.storage.Wallet;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public final class ConnectionCloner {
    private final ScriptRunnerContext ctx;
    private final MessageLogger logger;
    private NamedConnectionDefinition origin;
    private String destName;
    private Path destDir;
    private Properties dbToolsProps;
    private Wallet wallet;

    public static ConnectionCloner createCloner(ScriptRunnerContext ctx, MessageLogger logger) {
        return new ConnectionCloner(ctx, logger);
    }

    ConnectionCloner(ScriptRunnerContext ctx, MessageLogger logger) {
        this.ctx = ctx;
        this.logger = logger;
    }

    public void handleCopyError(IOException ex) {
        this.logger.logUserMessage(ex.getMessage());
    }

    public void setOrigin(NamedConnectionDefinition origin) {
        this.origin = origin;
    }

    public void setDestination(String destName) {
        this.destName = destName;
    }

    public final void cloneConnection() throws IOException {
        if (this.origin == null) {
            throw new IllegalStateException("origin not set");
        }
        if (this.destName == null) {
            throw new IllegalStateException("destination not set");
        }
        String originName = this.origin.getConnectionName();
        ConnectionStorage storage = ConnectionStorage.instance();
        this.destDir = storage.duplicateConnection(originName, this.destName, this::handleCopyError);
        Path dbTools = this.destDir.resolve("dbtools.properties");
        this.dbToolsProps = Files.exists(dbTools, new LinkOption[0]) ? ConnectionStorage.loadProperties(dbTools) : new Properties();
        this.dbToolsProps.setProperty("displayName", this.destName);
    }

    public void updateUser(String user, boolean promptForPassword) throws IOException {
        this.updateUser(user, null, promptForPassword);
    }

    public void updateUser(String user, char[] pwd, boolean promptForPassword) throws IOException {
        ConnectionHelper helper = ConnectionHelperFactory.findHelper(this.origin, this.ctx, this.logger);
        String spec = helper.getConnectionSpec();
        Path walletFile = this.destDir.resolve("cwallet.sso");
        if (Files.exists(walletFile, new LinkOption[0])) {
            this.wallet = Wallet.createWallet(walletFile);
        }
        if (this.wallet == null) {
            this.wallet = Wallet.createEmptyWallet();
        }
        if (user != null) {
            this.dbToolsProps.setProperty("userName", user);
            if (promptForPassword) {
                if (pwd == null) {
                    ConnectionDetails cd = new ConnectionDetails(spec, false, user, null, spec, null, false, -1, -1, null);
                    cd.setConnectDB(helper.getURL());
                    ConnectionDetails updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false);
                    if (updatedDetails != null) {
                        user = updatedDetails.getConnectName();
                        String connectPwd = updatedDetails.getConnectPassword();
                        if (connectPwd != null) {
                            pwd = connectPwd.toCharArray();
                        }
                    }
                }
            } else {
                pwd = null;
            }
            this.wallet.updateCredentials(spec, user, pwd);
        } else {
            this.dbToolsProps.remove("userName");
            this.wallet.updateCredentials(spec, null, null);
        }
    }

    public void saveConnection() throws IOException {
        ConnectionStorage storage = ConnectionStorage.instance();
        if (!this.dbToolsProps.isEmpty()) {
            storage.storeObject(this.destName, "dbtools.properties", this.dbToolsProps, NamedConnectionDefinition::outputProperties);
        }
        if (this.wallet != null) {
            storage.storeObject(this.destName, "cwallet.sso", this.wallet, Wallet::writeWallet);
        }
    }
}

