/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.helpers.ora;

import java.util.Properties;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.jdbc.configurators.BasicConfiguration;
import oracle.dbtools.jdbc.configurators.ConfigurationException;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.helpers.ora.BaseOracleConnectionHelper;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class BasicOracleConnectionHelper
extends BaseOracleConnectionHelper {
    BasicOracleConnectionHelper(NamedConnectionDefinition definition, ScriptRunnerContext ctx, MessageLogger logger) {
        super(definition, ctx, logger);
    }

    @Override
    public String getConnectionSpec() {
        Properties dbtoolsProperties = this.definition.getDbtoolsProperties();
        String host = dbtoolsProperties.getProperty("host");
        String port = dbtoolsProperties.getProperty("port");
        String serviceName = dbtoolsProperties.getProperty("serviceName");
        return this.getConnectionSpec(host, port, serviceName);
    }

    private BasicConfiguration createBasicConfiguration() throws ConfigurationException {
        String serviceName;
        String host;
        BasicConfiguration.Builder basicBuilder = BasicConfiguration.builder();
        Properties dbtoolsProperties = this.definition.getDbtoolsProperties();
        String port = dbtoolsProperties.getProperty("port");
        if (ModelUtil.hasLength(port)) {
            basicBuilder.port(port);
        }
        if (ModelUtil.hasLength(host = dbtoolsProperties.getProperty("host"))) {
            basicBuilder.hostname(host);
        }
        if (ModelUtil.hasLength(serviceName = dbtoolsProperties.getProperty("serviceName"))) {
            basicBuilder.servicename(serviceName);
        }
        return basicBuilder.build();
    }
}

