/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.io.IOException;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.plusplus.connections.db.ConnectionDefinitionCreator;
import oracle.dbtools.plusplus.connections.db.ConnectionSaverFactory;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.SealedString;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public class OracleConnectionSaverFactory
implements ConnectionSaverFactory {
    @Override
    public String getConnectorType() {
        return "ORACLE";
    }

    @Override
    public ConnectionSaverFactory.ConnectionSaver createConnectionSaver(ScriptRunnerContext ctx, MessageLogger logger) {
        return OracleConnectionSaver.createSaver(ctx, logger);
    }

    static class OracleConnectionSaver
    extends ConnectionDefinitionCreator
    implements ConnectionSaverFactory.ConnectionSaver {
        static OracleConnectionSaver createSaver(ScriptRunnerContext ctx, MessageLogger logger) {
            return new OracleConnectionSaver(ctx, logger);
        }

        private OracleConnectionSaver(ScriptRunnerContext ctx, MessageLogger logger) {
            super(ctx, logger);
        }

        @Override
        public boolean saveConnection(String connName, PropertyValues properties, String user, boolean skipPwd) throws IOException {
            boolean saved = false;
            String connSpec = properties.getValueOf(URLProperty.URL);
            char[] pwd = null;
            if (!ModelUtil.hasLength(user)) {
                SealedString o;
                user = properties.getValueOf(UserProperty.USER);
                if (!skipPwd && (o = properties.getValueOf(PasswordProperty.PASSWORD)) != null) {
                    pwd = ((Object)o).toString().toCharArray();
                }
            } else if (!skipPwd) {
                pwd = this.promptForPassword(connSpec, user);
            }
            this.setDbToolsPropertyValue("type", "ORACLE_DATABASE");
            this.setDbToolsPropertyValue("connectionString", connSpec);
            if (ModelUtil.hasLength(user)) {
                this.dbtoolProperties.setProperty("userName", user);
                if (pwd != null) {
                    this.wallet = this.createWallet(connSpec, user, pwd);
                }
            }
            this.connectionName = connName;
            NamedConnectionDefinition def = this.createDefinition();
            if (def != null) {
                NamedConnections.instance().addConnection(def);
                saved = true;
            }
            return saved;
        }
    }
}

