/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.connections.Location;
import oracle.dbtools.connections.db.ConnectionCreator;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DefaultConnectionCreator;
import oracle.dbtools.plusplus.connections.db.DatabaseConnection;
import oracle.dbtools.util.Logger;

class NamedConnection
implements DatabaseConnection {
    private final String name;
    private final DatabaseProvider provider;
    private final Location location;
    private final ConnectionCreator cc;
    private Connection connection;

    NamedConnection(DatabaseProvider provider, Location location) {
        this.name = provider.getName();
        this.provider = provider;
        this.location = location;
        ConnectionCreator creator = null;
        try {
            creator = DatabaseProvider.getCreator(provider);
        }
        catch (SQLException ex) {
            Logger.severe(NamedConnection.class, ex);
        }
        this.cc = creator != null ? creator : DefaultConnectionCreator.getInstance();
    }

    @Override
    public Connection getConnection(boolean force) throws SQLException {
        if (this.connection == null && force) {
            this.connection = this.provider.getConnection();
        }
        return this.connection;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.provider.getProperty("RaptorConnectionType");
    }

    @Override
    public Properties getConnectionInfo() {
        return this.provider.getProperties();
    }

    @Override
    public Connection getUniqueConnection() throws SQLException {
        return this.provider.getConnection();
    }

    @Override
    public Location getConnectionLocation() {
        return this.location;
    }

    @Override
    public boolean matchConnection(Connection conn) {
        return conn == this.connection;
    }

    @Override
    public String getURL() throws SQLException {
        return this.provider.getConnectionURL();
    }
}

