/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.xspi;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingContext;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdevimpl.vcs.xspi.VCSBugTrackingManager;

public class VCSBugComponents {
    public static final JEWTDialog createCommitOperationDialog(Component parent, String title, String hint, Component center, VCSOptionsCustomizer customizer, String helpTopicId, VCSBugTrackingContext context) {
        JEWTDialog dialog = VCSComponents.createOperationDialog(parent, title, hint, center, customizer == null ? null : customizer.getComponent(), helpTopicId, customizer.getInitialFocusComponent());
        return VCSBugComponents.createExtendBugDialog(helpTopicId, context, dialog);
    }

    public static final JEWTDialog createPatchOperationDialog(Component parent, String title, String hint, Component center, VCSOptionsCustomizer customizer, String helpTopicId, VCSBugTrackingContext context) {
        JEWTDialog dialog = VCSComponents.createOperationDialog(parent, title, hint, center, customizer == null ? null : customizer.getComponent(), helpTopicId, customizer.getInitialFocusComponent());
        return VCSBugComponents.createExtendPatchDialog(helpTopicId, context, dialog);
    }

    private static JEWTDialog createExtendBugDialog(String helpTopicId, VCSBugTrackingContext context, JEWTDialog dialog) {
        if (context == null) {
            return dialog;
        }
        Component bugUi = VCSBugTrackingManager.getInstance().getCommitUI(context);
        if (bugUi != null) {
            JPanel content = VCSBugComponents.createOperationContentPanel(dialog.getContent(), bugUi);
            dialog.setContent((Component)content);
            if (helpTopicId != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)content, helpTopicId);
            }
            dialog.setMinimumSize(500, 600);
        }
        return dialog;
    }

    private static JEWTDialog createExtendPatchDialog(String helpTopicId, VCSBugTrackingContext context, JEWTDialog dialog) {
        if (context == null) {
            return dialog;
        }
        Component bugUi = VCSBugTrackingManager.getInstance().getPatchUI(context);
        if (bugUi != null) {
            JPanel content = VCSBugComponents.createOperationContentPanel(dialog.getContent(), bugUi);
            dialog.setContent((Component)content);
            if (helpTopicId != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)content, helpTopicId);
            }
        }
        return dialog;
    }

    private static final JPanel createOperationContentPanel(Component center, Component south) {
        JPanel content = new JPanel(new BorderLayout());
        content.add(center, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(Box.createVerticalStrut(10), "North");
        panel.add(south, "Center");
        content.add((Component)panel, "South");
        return content;
    }
}

