/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;

public abstract class AsynchronousCommitListener
implements CommitListener {
    private final WizardDialog m_wizardDialog;

    protected AsynchronousCommitListener(WizardDialog wizardDialog) {
        this.m_wizardDialog = wizardDialog;
    }

    protected String getThreadName() {
        return "AsynchronousCommitListener";
    }

    protected abstract boolean commitImpl(TraversableContext var1);

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        final TraversableContext context = applyEvent.getTraversableContext();
        context.getWizardCallbacks().wizardEnableButtons(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
        final WaitCursor wc = new WaitCursor((Component)this.m_wizardDialog);
        wc.show();
        Runnable runnable = new Runnable(){

            private void resetWizard() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        wc.hide();
                        wc.dispose();
                        AsynchronousCommitListener.this.m_wizardDialog.setCursor(Cursor.getPredefinedCursor(0));
                        context.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
                    }
                });
            }

            @Override
            public void run() {
                try {
                    if (AsynchronousCommitListener.this.commitImpl(context)) {
                        AsynchronousCommitListener.this.m_wizardDialog.setVisible(false);
                    } else {
                        this.resetWizard();
                    }
                }
                catch (RuntimeException exception) {
                    ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)exception);
                    this.resetWizard();
                }
            }
        };
        Thread thread = new Thread(runnable, this.getThreadName());
        thread.start();
        throw new TraversalException(null);
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }
}

