/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdevimpl.vcs.generic.util.PatternURLFilter;

public final class VCSDirectoryWatcher {
    public static final int OPTION_CONSIDER_FILES = 1;
    public static final int OPTION_CONSIDER_DIRECTORIES = 2;
    public static final int OPTION_RECURSIVE = 4;
    private final Collection<Collection<VCSHashURL>> _listings = new ArrayList<Collection<VCSHashURL>>(5);
    private final Collection<VCSHashURL> _newWorkspaces = new ArrayList<VCSHashURL>(10);
    private final Collection<VCSHashURL> _newProjects = new ArrayList<VCSHashURL>(10);
    private final Collection<VCSHashURL> _newRegulars = new ArrayList<VCSHashURL>(10);
    private final URL _watchedDirectory;
    private PatternURLFilter _filter = null;
    private int _options;
    private boolean _watching;

    public VCSDirectoryWatcher(URL directory) {
        this._watchedDirectory = directory;
        this._watching = false;
        this._options = 5;
    }

    public VCSDirectoryWatcher(URL directory, int options) {
        this._watchedDirectory = directory;
        this._watching = false;
        this._options = options;
    }

    public URL getWatchedDirectory() {
        return this._watchedDirectory;
    }

    public synchronized void beginWatch() {
        if (this._watching) {
            throw new IllegalStateException();
        }
        this._watching = true;
        this._listings.clear();
        this._newWorkspaces.clear();
        this._newProjects.clear();
        this._listings.add(this.createSnapshot());
    }

    public synchronized void endWatch() {
        if (!this._watching) {
            throw new IllegalStateException();
        }
        this._listings.add(this.createSnapshot());
        Iterator<Collection<VCSHashURL>> it = this._listings.iterator();
        this.inspectListings(it.next(), it.next());
        this._watching = false;
    }

    public boolean hasNewWorkspaces() {
        return this._newWorkspaces.size() > 0;
    }

    public Collection getNewWorkspaces() {
        return Collections.unmodifiableCollection(VCSHashURL.convertToURLs(this._newWorkspaces));
    }

    public boolean hasNewProjects() {
        return this._newProjects.size() > 0;
    }

    public Collection getNewProjects() {
        return Collections.unmodifiableCollection(VCSHashURL.convertToURLs(this._newProjects));
    }

    public boolean hasNewRegularURLs() {
        return this._newRegulars.size() > 0;
    }

    public Collection getNewRegularURLs() {
        return Collections.unmodifiableCollection(VCSHashURL.convertToURLs(this._newRegulars));
    }

    private void inspectListings(Collection<VCSHashURL> listing, Collection<VCSHashURL> laterListing) {
        Collection<VCSHashURL> newUrls = laterListing;
        newUrls.removeAll(listing);
        for (VCSHashURL newUrl : newUrls) {
            String name = URLFileSystem.getPlatformPathName((URL)newUrl.getURL());
            if (name.endsWith(".jws")) {
                this._newWorkspaces.add(newUrl);
                continue;
            }
            if (name.endsWith(".jpr")) {
                this._newProjects.add(newUrl);
                continue;
            }
            if (!this.includeUrl(newUrl.getURL())) continue;
            this._newRegulars.add(newUrl);
        }
    }

    public String toString() {
        Iterator<VCSHashURL> it;
        StringBuilder buff = new StringBuilder(100);
        buff.append(super.toString()).append(": [base=");
        buff.append(URLFileSystem.getPlatformPathName((URL)this._watchedDirectory));
        buff.append("] ");
        if (this._watching) {
            buff.append(" [watch in progress]");
            return buff.toString();
        }
        if (this.hasNewWorkspaces()) {
            buff.append(" [workspaces=");
            it = this._newWorkspaces.iterator();
            while (it.hasNext()) {
                buff.append(URLFileSystem.getPlatformPathName((URL)((URL)((Object)it.next()))));
                if (!it.hasNext()) continue;
                buff.append(',');
            }
            buff.append(']');
        }
        if (this.hasNewProjects()) {
            buff.append(" [projects=");
            it = this._newProjects.iterator();
            while (it.hasNext()) {
                buff.append(URLFileSystem.getPlatformPathName((URL)((URL)((Object)it.next()))));
                if (!it.hasNext()) continue;
                buff.append(',');
            }
            buff.append(']');
        }
        if (!this.hasNewWorkspaces() && !this.hasNewProjects()) {
            buff.append(" [no new interesting urls]");
        }
        return buff.toString();
    }

    private Collection<VCSHashURL> createSnapshot() {
        if (this.isRecursive()) {
            VirtualFileSystemHelper.invalidateDirectoryTree((URL)this._watchedDirectory);
        } else {
            VirtualFileSystemHelper.invalidateDirectory((URL)this._watchedDirectory);
        }
        ArrayList<VCSHashURL> urls = new ArrayList<VCSHashURL>(100);
        this.listFiles(this._watchedDirectory, urls);
        return urls;
    }

    private void listFiles(URL directory, Collection<VCSHashURL> urls) {
        URL[] listing = URLFileSystem.list((URL)directory, (URLFilter)GlobalIgnoreList.getURLFilter());
        if (listing == null || listing.length == 0) {
            return;
        }
        for (int i = 0; i < listing.length; ++i) {
            boolean isDirectoryPath = URLFileSystem.isDirectoryPath((URL)listing[i]);
            if (this.considerDirectories() && isDirectoryPath) {
                urls.add(new VCSHashURL(listing[i]));
            }
            if (this.considerFiles() && !isDirectoryPath) {
                urls.add(new VCSHashURL(listing[i]));
            }
            if (!this.isRecursive() || !isDirectoryPath) continue;
            this.listFiles(listing[i], urls);
        }
    }

    private boolean isRecursive() {
        return (this._options & 4) > 0;
    }

    private boolean considerFiles() {
        return (this._options & 1) > 0;
    }

    private boolean considerDirectories() {
        return (this._options & 2) > 0;
    }

    private boolean includeUrl(URL url) {
        if (this._filter == null) {
            this._filter = new PatternURLFilter(VCSIgnoreFilters.getAllIgnoreFilters());
        }
        return this._filter.accept(url);
    }
}

