/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.net.URL;
import java.util.logging.Logger;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.generic.util.AbstractIdentifiable;

public class DelegatingURLFilter
extends AbstractIdentifiable
implements URLFilter {
    private static final Logger sLogger = Logger.getLogger(DelegatingURLFilter.class.getName());
    private static final String FILTER_TYPE_FILES_ONLY = "FILES_ONLY";
    private static final String FILTER_TYPE_FILE_PATH = "FILE_PATH";
    private static final String FILTER_TYPE_FILE_PROTOCOL = "FILE_PROTOCOL";
    private static final String FILTER_TYPE_DIRECTORIES_ONLY = "DIRECTORIES_ONLY";
    private static final String FILTER_TYPE_DIRECTORY_PATH = "DIRECTORY_PATH";
    private static final String FILTER_TYPE_HTTP_PROTOCOL = "HTTP_PROTOCOL";
    private URLFilter _delegate;
    private String _type;
    private String _protocol;

    public void setType(String type) {
        this._type = type;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public boolean accept(URL url) {
        if (this._delegate == null) {
            this._delegate = this.createDelagate();
        }
        return this._delegate.accept(url);
    }

    private URLFilter createDelagate() {
        URLFilter f = null;
        if (this._type != null) {
            if (this._type.equalsIgnoreCase(FILTER_TYPE_FILES_ONLY)) {
                f = VCSURLFilters.createFilesFilter();
            } else if (this._type.equalsIgnoreCase(FILTER_TYPE_FILE_PATH)) {
                f = VCSURLFilters.createFilePathFilter();
            } else if (this._type.equalsIgnoreCase(FILTER_TYPE_FILE_PROTOCOL)) {
                f = VCSContextUtils.createLocalProtocolFilter();
            } else if (this._type.equalsIgnoreCase(FILTER_TYPE_DIRECTORIES_ONLY)) {
                f = VCSURLFilters.createDirectoriesFilter();
            } else if (this._type.equalsIgnoreCase(FILTER_TYPE_DIRECTORY_PATH)) {
                f = VCSURLFilters.createDirectoryPathFilter();
            } else if (this._type.equalsIgnoreCase(FILTER_TYPE_HTTP_PROTOCOL)) {
                f = VCSURLFilters.createHttpProtocolFilter();
            } else {
                sLogger.severe("Unrecognised url filter type: " + this._type + ". Continuing with a default 'accept-all' instance.");
                f = VCSURLFilters.createNullFilter();
            }
        } else if (this._protocol != null) {
            f = VCSURLFilters.createProtocolFilter(this._protocol);
        }
        return f;
    }
}

